// This file is part of Awali.
// Copyright 2016-2019 Sylvain Lombardy, Victor Marsault, Jacques Sakarovitch
//
// Awali is a free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#include <awali/sttc/algos/product.hh>
#include <awali/sttc/algos/union.hh>
#include <awali/dyn/bridge-sttc/explicit-automaton.cc>

#include<set-types.hh>

namespace awali {

  extern "C" dyn::automaton_t product(dyn::automaton_t aut1, dyn::automaton_t aut2, bool keep_history) {
    auto a1 = dyn::get_stc_automaton<context1_t>(aut1);
    auto a2 = dyn::get_stc_automaton<context2_t>(aut2);
    auto res = sttc::product(a1, a2, keep_history);
    return dyn::make_automaton(res);
  }

  extern "C" dyn::automaton_t shuffle(dyn::automaton_t aut1, dyn::automaton_t aut2, bool keep_history) {
    auto a1 = dyn::get_stc_automaton<context1_t>(aut1);
    auto a2 = dyn::get_stc_automaton<context2_t>(aut2);
    auto res = sttc::shuffle(a1, a2, keep_history);
    return dyn::make_automaton(res);
  }

  extern "C" dyn::automaton_t infiltration(dyn::automaton_t aut1, dyn::automaton_t aut2, bool keep_history) {
    auto a1 = dyn::get_stc_automaton<context1_t>(aut1);
    auto a2 = dyn::get_stc_automaton<context2_t>(aut2);
    auto res = sttc::infiltration(a1, a2, keep_history);
    return dyn::make_automaton(res);
  }

  extern "C" dyn::automaton_t Union(dyn::automaton_t aut1, dyn::automaton_t aut2) {
    auto a1 = dyn::get_stc_automaton<context1_t>(aut1);
    auto a2 = dyn::get_stc_automaton<context2_t>(aut2);
    auto res = sttc::union_a(a1, a2);
    return dyn::make_automaton(res);
  }

}

#include <awali/dyn/core/any.cc>
