// This file is part of Awali.
// Copyright 2016-2019 Sylvain Lombardy, Victor Marsault, Jacques Sakarovitch
//
// Awali is a free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifndef DYN_ALGOS_SYS_HH
#define DYN_ALGOS_SYS_HH



namespace awali { namespace dyn {

  void display(automaton_t aut, const std::string& name="tmp", bool history=false, bool horizontal=true);
 
  void pdfdisplay(automaton_t aut, const std::string& name="tmp", bool history=false, bool horonztal=true);


  automaton_t parse_automaton(std::istream& i, const std::string& fmt);

  std::ostream& put(automaton_t aut, std::ostream& o, std::string& format);


  void save(const automaton_t aut, const std::string& filename, const std::string& fmt = "json");
  automaton_t load(const std::string& filename, const std::string& fmt = "json");

}}//end of ns awali::dyn



#endif
