#include "atlas_asm.h"
/*
 * Automatically Tuned Linear Algebra Software v3.11.38
 * Copyright (C) 2015 R. Clint Whaley
 * Code contributers : R. Clint Whaley, Dave Nuechterlein
 */
/*
 * w0                        x1          w2
 * int ATL_ResetAtomicCount(void *vp, int cnt)
 * Sets vp's acnt=cnt.
 * RETURNS: acnt before the reset
 */
ATL_asmdecor(ATL_ResetAtomicCount):
   add x1, x0, 128
   ATOMIC_LOOP:
      ldxr w0, [x1]         /* load exlusive into ret reg */
      stxr w2, w0, [x1]     /* w2 == 0 on exclusive success */
   cbnz w2, ATOMIC_LOOP     /* if (w2 != 0) failed; try again */
   ret
