/*
 * Automatically Tuned Linear Algebra Software v3.11.38
 * (C) Copyright 2001 R. Clint Whaley
 */
#include "atlas_lapack.h"
#ifdef TREAL
   #define my_syrk cblas_syrk
   #define my_trans CblasTrans
#else
   #define my_syrk cblas_herk
   #define my_trans CblasConjTrans
#endif

#ifdef RowMajor_
   #define MyOrder CblasRowMajor
   #define ATL_lauumU Mjoin(PATL,lauumRU)
   #define ATL_lauumL Mjoin(PATL,lauumRL)
#else
   #define MyOrder CblasColMajor
   #define ATL_lauumU Mjoin(PATL,lauumCU)
   #define ATL_lauumL Mjoin(PATL,lauumCL)
#endif

void ATL_lauumU(const int N, TYPE *A, const int lda)
{
   int Nleft, Nright;
   #ifdef TREAL
      const TYPE one=ATL_rone;
   #else
      const TYPE one[2]={ATL_rone, ATL_rzero};
   #endif
   TYPE *G, *U0=A, *U1;

   if (N > 1)
   {
      Nleft = N >> 1;
      #ifdef ATL_AMM_98LCMMN
         if (Nleft > ATL_AMM_98LCMMN)
            Nleft = (Nleft/ATL_AMM_98LCMMN)*ATL_AMM_98LCMMN;
      #endif
      Nright = N - Nleft;
      #ifdef RowMajor_
         G  = A + (Nleft SHIFT);
         U1 = G + Nleft*(lda SHIFT);
      #else
         G  = A + Nleft*(lda SHIFT);
         U1 = G + (Nleft SHIFT);
      #endif
      ATL_lauumU(Nleft, U0, lda);
      my_syrk(MyOrder, CblasUpper, CblasNoTrans, Nleft, Nright, ATL_rone,
              G, lda, ATL_rone, U0, lda);
      cblas_trmm(MyOrder, CblasRight, CblasUpper, my_trans, CblasNonUnit,
                 Nleft, Nright, one, U1, lda, G, lda);
      ATL_lauumU(Nright, U1, lda);
   }
   else *A = *A * *A;
}
