/*
 * Automatically Tuned Linear Algebra Software v3.11.38
 * (C) Copyright 1997 R. Clint Whaley
 */
#include "atlas_kern3.h"

#ifdef TREAL
   void Mjoin(Mjoin(Mjoin(PATL,sycopy),UploNM),_a1)
      (const int N, const SCALAR alpha0, const TYPE *A, const int lda, TYPE *C);
   void Mjoin(Mjoin(Mjoin(PATL,sycopy),UploNM),_aX)
      (const int N, const SCALAR alpha0, const TYPE *A, const int lda, TYPE *C);
#else
   void Mjoin(Mjoin(PATL,sycopy),UploNM)
      (const int N, const TYPE *A, const int lda, TYPE *C);
#endif

void Mjoin(Mjoin(PATL,symmL),UploNM)
   (const int M, const int N, const void *valpha, const void *A, const int lda,
    const void *B, const int ldb, const void *vbeta, void *C, const int ldc)
{
   #ifdef TREAL
      const SCALAR alpha=*( (const SCALAR *)valpha );
      const SCALAR beta =*( (const SCALAR *)vbeta  );
      const SCALAR one=1.0;
   #else
      #define alpha valpha
      #define beta vbeta
   #endif
   TYPE *a;
   void *va;

   if (N > SYMM_Xover)
   {
      va = malloc(ATL_Cachelen + (ATL_MulBySize(M)*M));
      ATL_assert(va);
      a = ATL_AlignPtr(va);
      #ifdef TREAL
         if ( SCALAR_IS_ONE(alpha) )
            Mjoin(Mjoin(Mjoin(PATL,sycopy),UploNM),_a1)(M, alpha, A, lda, a);
         else Mjoin(Mjoin(Mjoin(PATL,sycopy),UploNM),_aX)(M, alpha, A, lda, a);
         ATL_gemm(AtlasTrans, AtlasNoTrans, M, N, M, one, a, M, B, ldb,
                  beta, C, ldc);
      #else
         Mjoin(Mjoin(PATL,sycopy),UploNM)(M, A, lda, a);
         ATL_gemm(AtlasTrans, AtlasNoTrans, M, N, M, valpha, a, M, B, ldb,
                  vbeta, C, ldc);
      #endif
      free(va);
   }
   else Mjoin(PATL,refsymm)(AtlasLeft, Uplo_, M, N, alpha, A, lda, B, ldb,
                            beta, C, ldc);
}
