/*
 * Automatically Tuned Linear Algebra Software v3.11.38
 * (C) Copyright 1997 R. Clint Whaley
 */
/*
 * ===========================================================================
 * Prototypes for level 3 BLAS
 * ===========================================================================
 */
#ifndef ATLAS_LEVEL3_H
   #define ATLAS_LEVEL3_H

/*
 * Routines with standard 4 prefixes (S, D, C, Z)
 */
int ATL_sGetNB(void);
int ATL_sGetNCNB(void);
void ATL_sammm
   (enum ATLAS_TRANS,enum ATLAS_TRANS,ATL_CSZT,ATL_CSZT,ATL_CSZT,
    const float , const float*,ATL_CSZT,const float*,ATL_CSZT,
    const float ,float*,ATL_CSZT);

void ATL_sgemm(const enum ATLAS_TRANS, const enum ATLAS_TRANS,
               const int M, const int N, const int K, const float alpha,
               const float *A, const int lda, const float *B, const int ldb,
               const float beta, float *C, const int ldc);
void ATL_ssymm(const enum ATLAS_SIDE Side, const enum ATLAS_UPLO Uplo,
               const int M, const int N, const float alpha,
               const float *A, const int lda, const float *B, const int ldb,
               const float beta, float *C, const int ldc);
void ATL_ssyrk(const enum ATLAS_UPLO Uplo, const enum ATLAS_TRANS Trans,
               const int N, const int K, const float alpha,
               const float *A, const int lda, const float beta,
               float *C, const int ldc);
void ATL_ssyr2k(const enum ATLAS_UPLO Uplo, const enum ATLAS_TRANS Trans,
                const int N, const int K, const float alpha,
                const float *A, const int lda, const float *B, const int ldb,
                const float beta, float *C, const int ldc);
void ATL_strmm(const enum ATLAS_SIDE Side, const enum ATLAS_UPLO Uplo,
               const enum ATLAS_TRANS TransA, const enum ATLAS_DIAG Diag,
               const int M, const int N, const float alpha,
               const float *A, const int lda, float *B, const int ldb);
void ATL_strsm(const enum ATLAS_SIDE Side, const enum ATLAS_UPLO Uplo,
               const enum ATLAS_TRANS TransA, const enum ATLAS_DIAG Diag,
               const int M, const int N, const float alpha,
               const float *A, const int lda, float *B, const int ldb);

int ATL_dGetNB(void);
int ATL_dGetNCNB(void);
void ATL_dammm
   (enum ATLAS_TRANS,enum ATLAS_TRANS,ATL_CSZT,ATL_CSZT,ATL_CSZT,
    const double , const double*,ATL_CSZT,const double*,ATL_CSZT,
    const double ,double*,ATL_CSZT);

void ATL_dgemm(const enum ATLAS_TRANS, const enum ATLAS_TRANS,
               const int M, const int N, const int K, const double alpha,
               const double *A, const int lda, const double *B, const int ldb,
               const double beta, double *C, const int ldc);
void ATL_dsymm(const enum ATLAS_SIDE Side, const enum ATLAS_UPLO Uplo,
               const int M, const int N, const double alpha,
               const double *A, const int lda, const double *B, const int ldb,
               const double beta, double *C, const int ldc);
void ATL_dsyrk(const enum ATLAS_UPLO Uplo, const enum ATLAS_TRANS Trans,
               const int N, const int K, const double alpha,
               const double *A, const int lda, const double beta,
               double *C, const int ldc);
void ATL_dsyr2k(const enum ATLAS_UPLO Uplo, const enum ATLAS_TRANS Trans,
                const int N, const int K, const double alpha,
                const double *A, const int lda, const double *B, const int ldb,
                const double beta, double *C, const int ldc);
void ATL_dtrmm(const enum ATLAS_SIDE Side, const enum ATLAS_UPLO Uplo,
               const enum ATLAS_TRANS TransA, const enum ATLAS_DIAG Diag,
               const int M, const int N, const double alpha,
               const double *A, const int lda, double *B, const int ldb);
void ATL_dtrsm(const enum ATLAS_SIDE Side, const enum ATLAS_UPLO Uplo,
               const enum ATLAS_TRANS TransA, const enum ATLAS_DIAG Diag,
               const int M, const int N, const double alpha,
               const double *A, const int lda, double *B, const int ldb);

int ATL_cGetNB(void);
int ATL_cGetNCNB(void);
void ATL_cammm
   (enum ATLAS_TRANS,enum ATLAS_TRANS,ATL_CSZT,ATL_CSZT,ATL_CSZT,
    const float *, const float*,ATL_CSZT,const float*,ATL_CSZT,
    const float *,float*,ATL_CSZT);

void ATL_cgemm(const enum ATLAS_TRANS, const enum ATLAS_TRANS,
               const int M, const int N, const int K, const float *alpha,
               const float *A, const int lda, const float *B, const int ldb,
               const float *beta, float *C, const int ldc);
void ATL_csymm(const enum ATLAS_SIDE Side, const enum ATLAS_UPLO Uplo,
               const int M, const int N, const float *alpha,
               const float *A, const int lda, const float *B, const int ldb,
               const float *beta, float *C, const int ldc);
void ATL_csyrk(const enum ATLAS_UPLO Uplo, const enum ATLAS_TRANS Trans,
               const int N, const int K, const float *alpha,
               const float *A, const int lda, const float *beta,
               float *C, const int ldc);
void ATL_csyr2k(const enum ATLAS_UPLO Uplo, const enum ATLAS_TRANS Trans,
                const int N, const int K, const float *alpha,
                const float *A, const int lda, const float *B, const int ldb,
                const float *beta, float *C, const int ldc);
void ATL_ctrmm(const enum ATLAS_SIDE Side, const enum ATLAS_UPLO Uplo,
               const enum ATLAS_TRANS TransA, const enum ATLAS_DIAG Diag,
               const int M, const int N, const float *alpha,
               const float *A, const int lda, float *B, const int ldb);
void ATL_ctrsm(const enum ATLAS_SIDE Side, const enum ATLAS_UPLO Uplo,
               const enum ATLAS_TRANS TransA, const enum ATLAS_DIAG Diag,
               const int M, const int N, const float *alpha,
               const float *A, const int lda, float *B, const int ldb);

int ATL_zGetNB(void);
int ATL_zGetNCNB(void);
void ATL_zammm
   (enum ATLAS_TRANS,enum ATLAS_TRANS,ATL_CSZT,ATL_CSZT,ATL_CSZT,
    const double *, const double*,ATL_CSZT,const double*,ATL_CSZT,
    const double *,double*,ATL_CSZT);

void ATL_zgemm(const enum ATLAS_TRANS, const enum ATLAS_TRANS,
               const int M, const int N, const int K, const double *alpha,
               const double *A, const int lda, const double *B, const int ldb,
               const double *beta, double *C, const int ldc);
void ATL_zsymm(const enum ATLAS_SIDE Side, const enum ATLAS_UPLO Uplo,
               const int M, const int N, const double *alpha,
               const double *A, const int lda, const double *B, const int ldb,
               const double *beta, double *C, const int ldc);
void ATL_zsyrk(const enum ATLAS_UPLO Uplo, const enum ATLAS_TRANS Trans,
               const int N, const int K, const double *alpha,
               const double *A, const int lda, const double *beta,
               double *C, const int ldc);
void ATL_zsyr2k(const enum ATLAS_UPLO Uplo, const enum ATLAS_TRANS Trans,
                const int N, const int K, const double *alpha,
                const double *A, const int lda, const double *B, const int ldb,
                const double *beta, double *C, const int ldc);
void ATL_ztrmm(const enum ATLAS_SIDE Side, const enum ATLAS_UPLO Uplo,
               const enum ATLAS_TRANS TransA, const enum ATLAS_DIAG Diag,
               const int M, const int N, const double *alpha,
               const double *A, const int lda, double *B, const int ldb);
void ATL_ztrsm(const enum ATLAS_SIDE Side, const enum ATLAS_UPLO Uplo,
               const enum ATLAS_TRANS TransA, const enum ATLAS_DIAG Diag,
               const int M, const int N, const double *alpha,
               const double *A, const int lda, double *B, const int ldb);


/*
 * Routines with prefixes C and Z only
 */
void ATL_chemm(const enum ATLAS_SIDE Side, const enum ATLAS_UPLO Uplo,
               const int M, const int N, const float *alpha,
               const float *A, const int lda, const float *B, const int ldb,
               const float *beta, float *C, const int ldc);
void ATL_cherk(const enum ATLAS_UPLO Uplo, const enum ATLAS_TRANS Trans,
               const int N, const int K, const float alpha,
               const float *A, const int lda, const float beta,
               float *C, const int ldc);
void ATL_cher2k(const enum ATLAS_UPLO Uplo, const enum ATLAS_TRANS Trans,
                const int N, const int K, const float *alpha,
                const float *A, const int lda, const float *B, const int ldb,
                const float beta, float *C, const int ldc);

void ATL_zhemm(const enum ATLAS_SIDE Side, const enum ATLAS_UPLO Uplo,
               const int M, const int N, const double *alpha,
               const double *A, const int lda, const double *B, const int ldb,
               const double *beta, double *C, const int ldc);
void ATL_zherk(const enum ATLAS_UPLO Uplo, const enum ATLAS_TRANS Trans,
               const int N, const int K, const double alpha,
               const double *A, const int lda, const double beta,
               double *C, const int ldc);
void ATL_zher2k(const enum ATLAS_UPLO Uplo, const enum ATLAS_TRANS Trans,
                const int N, const int K, const double *alpha,
                const double *A, const int lda, const double *B, const int ldb,
                const double beta, double *C, const int ldc);


#endif
