#ifndef ATLAS_AMM_H
   #define ATLAS_AMM_H
#include "atlas_misc.h"
#ifndef ATL_MaxMalloc
   #include "atlas_maxmalloc.h"
#endif
#ifndef ATL_MaxMalloc
   #define ATL_MaxMalloc 268435456UL
#endif
#include "atlas_misc.h"

#ifdef TREAL
   typedef void (*cm2am_t)(const size_t, const size_t, const SCALAR,
                           const TYPE*, const size_t, TYPE*);
   typedef void (*am2cm_t)(const size_t, const size_t, const SCALAR,
                           TYPE*, const size_t, const TYPE*);
   typedef void (*ablk2cmat_t)(const size_t, const size_t, const SCALAR,
                               const TYPE*, const SCALAR, TYPE *, const size_t);
   typedef void (*cmat2ablk_t)(const size_t, const size_t, const SCALAR,
                               const TYPE*, const size_t, const SCALAR,TYPE*);
   typedef void (*ammswp_t)(ATL_CINT, TYPE*,ATL_CSZT,TYPE*);
#else
   typedef void (*cm2am_t)(const size_t, const size_t, const SCALAR,
                           const TYPE*, const size_t, TYPE*, TYPE*);
   typedef void (*am2cm_t)(const size_t, const size_t, const SCALAR,
                           TYPE*, const size_t, const TYPE*, const TYPE*);
   typedef void (*ablk2cmat_t)(const size_t, const size_t, const SCALAR,
                               const TYPE*, const TYPE*, const SCALAR,
                               TYPE *, const size_t);
   typedef void (*cmat2ablk_t)(const size_t, const size_t, const SCALAR,
                               const TYPE*, const size_t, const SCALAR,
                               TYPE*,TYPE*);
   typedef void (*ammswp_t)(ATL_CINT, TYPE*,ATL_CSZT,TYPE*,TYPE*);
#endif
typedef void (*ammkern_t)(ATL_CSZT,ATL_CSZT,ATL_CSZT,const TYPE*,const TYPE*,
                          TYPE*, const TYPE*, const TYPE*, const TYPE*);
typedef struct amminfo amminfo_t;
struct amminfo
{
   cm2am_t a2blk, b2blk;
   ablk2cmat_t Cblk2cm, Cblk2cm_b1;
   cmat2ablk_t cm2Cblk;
   ammkern_t amm_b0, amm_b1, amm_bn, amm_k1_b0, amm_k1_b1, amm_k1_bn;
   unsigned short IDX, mb, nb, kb, kbmin;
   unsigned char flag, mu, nu, ku;
};

typedef struct rkinfo rkinfo_t;
struct rkinfo
{
   size_t incAm, incAk;
   size_t incBn, incBk;
   size_t lda, ldb, ldc;
   ammkern_t amm_b0, amm_b1;      /* beta=0 ammm kern */
   cm2am_t a2blk, b2blk;          /* full-KB A/B copy routs */
   ablk2cmat_t blk2c;
   ATL_INT nfmb, nfnb, nfkb;      /* FLOOR(D/db) */
   short idx;
   unsigned short mbL, nbL, kbL;  /* D-nfdb*db */
   unsigned short MBL, NBL, KBL;  /* nmu*mu, nnu*nu, nku*ku */
   unsigned short mb, nb, kb;     /* blk fact, always mul of unrolling */
   unsigned short nmu, nnu, nmuL, nnuL; /* # U for normal & last blks */
   unsigned char flag, mu, nu, ku;
};

enum ATL_AMMALG {ATL_amm1b, ATL_ammrkK, ATL_NMK};

void Mjoin(PATL,GetBestKBInfo)
   (rkinfo_t*,rkinfo_t*,enum ATLAS_TRANS,enum ATLAS_TRANS,ATL_CSZT,
    ATL_CSZT,ATL_CSZT,size_t,size_t,size_t,const SCALAR,const SCALAR);
int Mjoin(PATL,GetSyrkInfo)
   (amminfo_t*,int, enum ATLAS_TRANS,ATL_CSZT,ATL_CSZT,int);
int Mjoin(PATL,GetRankKInfo)
   (amminfo_t *out, enum ATLAS_TRANS TA, enum ATLAS_TRANS TB, ATL_CSZT M,
    ATL_CSZT N, ATL_CSZT K, const SCALAR alpha, const SCALAR beta);
int Mjoin(PATL,GetAmmmInfo)
   (amminfo_t *out, enum ATLAS_TRANS TA, enum ATLAS_TRANS TB, ATL_CSZT M,
    ATL_CSZT N, ATL_CSZT K, const SCALAR alpha, const SCALAR beta);
#ifdef TREAL
int Mjoin(PATL,GetTrsmInfo)
   (amminfo_t *out, int ialp, enum ATLAS_TRANS TA, ATL_CSZT M, ATL_CSZT N,
    const SCALAR beta);
#endif
int Mjoin(PATL,tGetAmmmInfo)
   (amminfo_t *out, const unsigned int P, enum ATLAS_TRANS TA,
    enum ATLAS_TRANS TB, ATL_CSZT M, ATL_CSZT N, ATL_CSZT K,
    const SCALAR alpha, const SCALAR beta);
ablk2cmat_t Mjoin(PATL,tGetSyammInfo)
   (amminfo_t *out, const int P, enum ATLAS_TRANS TA, ATL_CSZT N, ATL_CSZT K,
    const SCALAR alpha, const SCALAR beta);
ablk2cmat_t Mjoin(PATL,tGetSyammInfo_K)
   (amminfo_t *out, const int P, enum ATLAS_TRANS TA, ATL_CSZT N, ATL_CSZT K);


int Mjoin(PATL,ammm_syrk)
   (const enum ATLAS_UPLO, const enum ATLAS_TRANS, ATL_CSZT,ATL_CSZT,
    const SCALAR,const TYPE*,ATL_CSZT,const SCALAR,TYPE*,ATL_CSZT);
void Mjoin(PATL,ammmK)
   (amminfo_t*, const int mb, const int nmu, const int nb, const int nnu,
    ATL_CINT nfkblks, const int kb, const int kb0, const int KB0, const TYPE *A,
    const size_t lda, const size_t incAk, const TYPE*B, const size_t ldb,
    const size_t incBk, const ablk2cmat_t blkc2c, TYPE*, const size_t ldc,
    TYPE *a, ATL_CINT inca, TYPE *b, ATL_CINT incb, TYPE *rC, TYPE *iC,
    const SCALAR alpA, const SCALAR alpB, const SCALAR alpC, const SCALAR beta);

void Mjoin(PATL,gemm)
   (const enum ATLAS_TRANS,const enum ATLAS_TRANS,ATL_CINT,ATL_CINT,ATL_CINT,
    const SCALAR, const TYPE*,ATL_CINT,const TYPE*,ATL_CINT,const SCALAR,
    TYPE*,ATL_CINT);
void Mjoin(PATL,ammm)
   (enum ATLAS_TRANS,enum ATLAS_TRANS,ATL_CSZT,ATL_CSZT,ATL_CSZT, const SCALAR,
    const TYPE*,ATL_CSZT,const TYPE*,ATL_CSZT,const SCALAR,TYPE*,ATL_CSZT);
#ifdef TREAL
void Mjoin(PATL,ammmM)(rkinfo_t*,int,int,ammkern_t,TYPE*,ATL_CINT,const TYPE*,
                       TYPE*,ATL_CINT,const TYPE*,TYPE*,TYPE);
int Mjoin(PATL,rk4n4)(enum ATLAS_TRANS,ATL_CSZT,const SCALAR,const TYPE*,
                      ATL_CSZT,const TYPE*,ATL_CSZT,TYPE*,ATL_CSZT);
#endif
int Mjoin(PATL,ammm_rk2)
   (enum ATLAS_TRANS,enum ATLAS_TRANS,ATL_CSZT,ATL_CSZT, const SCALAR,
    const TYPE*,ATL_CSZT,const TYPE*,ATL_CSZT,const SCALAR,TYPE*,ATL_CSZT);
int Mjoin(PATL,ammmREC)
   (enum ATLAS_TRANS,enum ATLAS_TRANS,ATL_CSZT,ATL_CSZT,ATL_CSZT, const SCALAR,
    const TYPE*,ATL_CSZT,const TYPE*,ATL_CSZT,const SCALAR,TYPE*,ATL_CSZT);
int Mjoin(PATL,ammmMNK)
   (enum ATLAS_TRANS,enum ATLAS_TRANS,ATL_CSZT,ATL_CSZT,ATL_CSZT, const SCALAR,
    const TYPE*,ATL_CSZT,const TYPE*,ATL_CSZT,const SCALAR,TYPE*,ATL_CSZT);
int Mjoin(PATL,ammm_aliased_rkK)
   (enum ATLAS_TRANS,enum ATLAS_TRANS,ATL_CSZT,ATL_CSZT,ATL_CSZT, const SCALAR,
    const TYPE*,ATL_CSZT,const TYPE*,ATL_CSZT,const SCALAR,TYPE*,ATL_CSZT);
int Mjoin(PATL,ammm_tN)
   (enum ATLAS_TRANS,enum ATLAS_TRANS,ATL_CSZT,ATL_CSZT,ATL_CSZT, const SCALAR,
    const TYPE*,ATL_CSZT,const TYPE*,ATL_CSZT,const SCALAR,TYPE*,ATL_CSZT);
int Mjoin(PATL,ammm_IP)
   (enum ATLAS_TRANS,enum ATLAS_TRANS,ATL_CSZT,ATL_CSZT,ATL_CSZT, const SCALAR,
    const TYPE*,ATL_CSZT,const TYPE*,ATL_CSZT,const SCALAR,TYPE*,ATL_CSZT);
int Mjoin(PATL,ammm_rkK)
   (enum ATLAS_TRANS,enum ATLAS_TRANS,ATL_CSZT,ATL_CSZT,ATL_CSZT, const SCALAR,
    const TYPE*,ATL_CSZT,const TYPE*,ATL_CSZT,const SCALAR,TYPE*,ATL_CSZT);
int Mjoin(PATL,ammm_1b)
   (enum ATLAS_TRANS,enum ATLAS_TRANS,ATL_CSZT,ATL_CSZT,ATL_CSZT, const SCALAR,
    const TYPE*,ATL_CSZT,const TYPE*,ATL_CSZT,const SCALAR,TYPE*,ATL_CSZT);
int Mjoin(PATL,ammmKMNK)
   (enum ATLAS_TRANS,enum ATLAS_TRANS,ATL_CSZT,ATL_CSZT,ATL_CSZT, const SCALAR,
    const TYPE*,ATL_CSZT,const TYPE*,ATL_CSZT,const SCALAR,TYPE*,ATL_CSZT);
int Mjoin(PATL,ammmKNMK)
   (enum ATLAS_TRANS,enum ATLAS_TRANS,ATL_CSZT,ATL_CSZT,ATL_CSZT, const SCALAR,
    const TYPE*,ATL_CSZT,const TYPE*,ATL_CSZT,const SCALAR,TYPE*,ATL_CSZT);
int Mjoin(PATL,ammmNKM)
   (enum ATLAS_TRANS,enum ATLAS_TRANS,ATL_CSZT,ATL_CSZT,ATL_CSZT, const SCALAR,
    const TYPE*,ATL_CSZT,const TYPE*,ATL_CSZT,const SCALAR,TYPE*,ATL_CSZT);
int Mjoin(PATL,ammmNMK)
   (enum ATLAS_TRANS,enum ATLAS_TRANS,ATL_CSZT,ATL_CSZT,ATL_CSZT,
    const SCALAR,const TYPE*,ATL_CSZT,const TYPE*,ATL_CSZT,const SCALAR,
    TYPE*,ATL_CSZT);
#endif  /* end include file guard */
