/*
 * Automatically Tuned Linear Algebra Software v3.11.38
 * (C) Copyright 2000 R. Clint Whaley
 */
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
void PrintUsage(char *nam)
{
   fprintf(stderr, "USAGE %s -p <pre>\n", nam);
   exit(-1);
}

void GetFlags(int nargs, char **args, char *pre)
{
   char ch;

   *pre = 'd';
   if (nargs > 1)
   {
      if (nargs != 3) PrintUsage(args[0]);
      if (args[1][0] != '-' || args[1][1] != 'p') PrintUsage(args[0]);
      ch = args[2][0];
      if (ch == 'Z') ch = 'z';
      else if (ch == 'C') ch = 'c';
      else if (ch == 'D') ch = 'd';
      else if (ch == 'S') ch = 's';
      else if (ch != 's' && ch != 'd' && ch != 'c' && ch != 'z')
         PrintUsage(args[0]);
      *pre = ch;
   }
}

#ifdef ATL_NOUSERMM
void CreateIndex(char pre)
{
   char fnam[16];
   FILE *fpout;
   sprintf(fnam, "%ccases.dsc", pre);
   fpout = fopen(fnam, "w")
   fprintf(fpout, "DUMMY INDEX FILE TO AVOID USER KERNELS\n0\n");
   fclose(fpout);
}
#else
void CreateIndex(char pre)
{
   char ln[512];
   char fnams[8][256];
   int n=1, i, j, itmp;

   sprintf(fnams[0], "CASES/%ccases.0", pre);
   #ifdef ATL_SSE1
      #ifdef ATL_SSE2
         if (pre == 'd' || pre == 'z')
            sprintf(fnams[n++], "%ccases.SSE", pre);
      #endif
      if (pre == 's' || pre == 'c')
         sprintf(fnams[n++], "%ccases.SSE", pre);
   #elif (defined(ATL_3DNow) && defined(ATL_3DNowFLOPS))
      if (pre == 's' || pre == 'c')
         sprintf(fnams[n++], "%ccases.3DN", pre);
   #endif
   sprintf(fnams[n++], "%ccases.flg", pre);
/*
 * substitute GOODGCC for gcc in compiler lines
 */
   for (i=1; i < n; i++)
   {
      sprintf(ln, "make %s flagfile=%s\n", fnams[i], fnams[i]);
      assert(system(ln) == 0);
   }
   itmp = n;

   j = sprintf(ln, "./xusercomb -o %ccases.dsc -i %d", pre, n);
   assert(n <= 8);
   for (i=0; i < n; i++) j += sprintf(ln+j, " %s", fnams[i]);
   sprintf(ln+j, "\n");
   fprintf(stdout, "%s", ln);
   assert(system(ln) == 0);
   remove(fnams[itmp]);
}
#endif

int main(int nargs, char **args)
/*
 * Creates system-dependent user matmul index file
 */
{
   char pre;
   GetFlags(nargs, args, &pre);
   CreateIndex(pre);
   return(0);
}

