#include "atlas_threads.h"
#include "atlas_cbc.h"
#include "atlas_misc.h"
/*
 * Use cache-based communication to perform a barrier for P threads.
 * This code works on any system with coherent caches (weakly-ordered OK).
 * For weakly-ordered caches, if this barrier is protecting memory, you
 * need to use the DOFENCE (cbc_) variant.
 */
#ifdef DOFENCE
   #ifdef ATL_cbc_barrier
      #undef ATL_cbc_barrier
   #endif
   #ifdef DOPOST
      #define mybarr ATL_cbc_barrier
   #else
      #define mybarr ATL_cbc_barrier_nopost0
   #endif
#else
   #ifdef DOPOST
      #define mybarr ATL_barrier
   #else
      #define mybarr ATL_barrier_nopost0
   #endif
#endif
void mybarr
(
   ATL_CUINT P,     /* # of threads to barrier */
   ATL_CUINT iam,   /* rank of calling thread in barrier */
   void *vchk
)
{
   volatile char *bchk = (vchk) ? (volatile char*)vchk : ATL_TP_PTR->bchkin;
   ATL_CUINT II = iam<<ATL_chksh;
   const char newv = !bchk[II];

   if (iam)
   {
      bchk[II] = newv;
      #ifdef DOFENCE
         ATL_membar;
      #endif
      while (*bchk != newv);
   }
   else
   {
      int i;
      for (i=1; i < P; i++)
      {
         ATL_CUINT d = i<<ATL_chksh;
         while (bchk[d] != newv);
      }
      #ifdef DOPOST
         #ifdef DOFENCE
            ATL_membar;
         #endif
         *bchk = newv;
      #endif
   }
}
