#include "atlas_asm.h"
/*
 * Automatically Tuned Linear Algebra Software v3.11.38
 * Copyright (C) 2015 R. Clint Whaley
 * Code contributers : R. Clint Whaley, Dave Nuechterlein
 */
/* w0                           x0  */
/* int ATL_DecAtomicCount(void *vp) */
.global ATL_asmdecor(ATL_DecAtomicCount)
ATL_asmdecor(ATL_DecAtomicCount):
/*
 * x0 is aptr to a cnt structure. 128 bytes in, there is an int (acnt)
 * that we want to decrement.
 * IN LOOP: attempt to get exclusive access to acnt, dec it, and return 0
 * if acnt <= 1, and acnt-1 otherwise
 */
   add  x1,x0,128        /* move to storage loc in memory */
   ATOMIC_LOOP:
      ldxr w0, [x1]      /* exclusive read of cnt into return reg (w0) */
      subs w2, w0, 1     /* dec cnt, set cond codes */
      b.lt   ZERO_RET    /* return 0 if count already below 1 */
      stxr w3, w2, [x1]  /* store decremented val, w3 0 on exclusive success */
   cbnz w3, ATOMIC_LOOP  /* if (w3 != 0) try again */

   ret

ZERO_RET:
   eor w0, w0, w0
   ret

