/*
 * Automatically Tuned Linear Algebra Software v3.11.38
 * Copyright (C) 2012, 2009 Siju Samuel
 * Code contributers : Siju Samuel, Anthony M. Castaldo, R. Clint Whaley
 */

/*
 * This is the C translation of the standard LAPACK Fortran routine:
 *      DOUBLE PRECISION FUNCTION DLAPY2( X, Y )
 *
 *      It is important to use the appropriate sqrt function for the
 *      precision given in order to test against the LAPACK fortran
 *      reference library; in particular due to high serial data
 *      dependence the SGEHRD routine can drift far enough on larger
 *      problems to appear to be in error; about 0.0004 in a single
 *      result element. (Modification by Tony Castaldo, 12/29/2011).
 *
 *  Purpose
 *  =======
 *
 *  DLAPY2 returns sqrt(x**2+y**2), taking care not to cause unnecessary
 *  overflow.
 *
 *  Arguments
 *  =========
 *
 *  X       (input) single/double precision
 *  Y       (input) single/double precision
 *          X and Y specify the values x and y.
 *
 */
#include "atlas_misc.h"
#include "cblas.h"
#include "atlas_lapack.h"
#include "math.h"

TYPE  ATL_lapy2(TYPE X, TYPE Y)
{
   TYPE  ONE=1.0, ZERO=0.0, W, Z, XABS, YABS, TEMP;

/* Find absolute values                                                       */
   XABS = Mabs(X);
   YABS = Mabs(Y);
   W = (XABS<YABS)?YABS:XABS;
   Z = (XABS<YABS)?XABS:YABS;

   if (Z == ZERO) return(W);
/* NOTE: If Z != 0, then W != 0                                               */
   TEMP = Z/W;

   TEMP = ONE + TEMP*TEMP;
   #if defined(SREAL) || defined(SCPLX)
   return(W * sqrtf(TEMP));                     /* Use single precision sqrt. */
   #else
   return(W * sqrt(TEMP));                      /* Use double precision sqrt. */
   #endif
}                                               /* END ATL_?lapy2             */


