/*
 * Automatically Tuned Linear Algebra Software v3.11.38
 * (C) Copyright 1997 R. Clint Whaley
 */
#include "atlas_kern3.h"

void Mjoin(Mjoin(PATL,hecopy),UploNM)
   (const int N, const TYPE *A, const int lda, TYPE *C);

void Mjoin(Mjoin(PATL,hemmR),UploNM)
   (const int M, const int N, const void *alpha, const void *A, const int lda,
    const void *B, const int ldb, const void *beta, void *C, const int ldc)
{
   void *va;
   TYPE *a;

   if (M > HEMM_Xover)
   {
      va = malloc(ATL_Cachelen + (ATL_MulBySize(N)*N));
      ATL_assert(va);
      a = ATL_AlignPtr(va);
      Mjoin(Mjoin(PATL,hecopy),UploNM)(N, A, lda, a);
      ATL_gemm(AtlasNoTrans, AtlasNoTrans, M, N, N, alpha, B, ldb, a, N,
               beta, C, ldc);
      free(va);
   }
   else Mjoin(PATL,refhemm)(AtlasRight, Uplo_, M, N, alpha, A, lda, B, ldb,
                            beta, C, ldc);
}
