/*
 * Automatically Tuned Linear Algebra Software v3.11.38
 * Copyright (C) 2014 R. Clint Whaley
 */
#ifndef ATLAS_BITVEC_H
   #define ATLAS_BITVEC_H
   #include "atlas_misc.h"
/*
 * A bitvector consists of an integer array.  The first element of the
 * array indicates the number of full BVs required, and the 2nd elt stores the
 * number of the remainder.
 * Assumes 32 bits per int for portability
 */
#define ATL_FreeBV(bv_) free(bv_);  /* bitvec just an int array */

int *ATL_NewBV(int nmax);
void ATL_SetBitBV(int *bv, int bpos);
void ATL_UnsetBitBV(int *bv, int bpos);
int ATL_IsBitSetBV(int *bv, int bpos);
int ATL_FindFirstUnsetBitBV(int *bv, int bs);
int ATL_FindFirstSetBitBV(int *bv, int bs);
void ATL_ReverseAllBitsBV(int *bv);
void ATL_SetAllBitsBV(int *bv);
void ATL_UnsetAllBitsBV(int *bv);
int ATL_IsBitRangeSetBV(int *bv, int b0, int bN);

#endif
