# -*- Mode: makefile-gmake; tab-width: 4; indent-tabs-mode: t -*-
#
#
# This file is part of the LibreOffice project.
#
# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.
#

$(eval $(call gb_CustomTarget_CustomTarget,filter/source/svg))

filter_SVGSRC := $(SRCDIR)/filter/source/svg
filter_SVGWORK := $(call gb_CustomTarget_get_workdir,filter/source/svg)

filter_SRC_svg_Tokens := $(filter_SVGSRC)/tokens.txt
filter_SRC_svg_GenToken := $(filter_SVGSRC)/gentoken.py
filter_SRC_svg_PresentationEngine := $(filter_SVGSRC)/presentation_engine.js
filter_SRC_svg_Js2Hxx := $(filter_SVGSRC)/js2hxx.py

filter_GEN_svg_Tokens_gperf := $(filter_SVGWORK)/tokens.gperf
filter_GEN_svg_Tokens_hxx := $(filter_SVGWORK)/tokens.hxx
filter_GEN_svg_Tokens_cxx := $(filter_SVGWORK)/tokens.cxx
filter_GEN_svg_Script_hxx := $(filter_SVGWORK)/svgscript.hxx

$(filter_GEN_svg_Tokens_gperf) : \
			$(call gb_ExternalExecutable_get_dependencies,python) \
			$(filter_SRC_svg_GenToken) $(filter_SRC_svg_Tokens) \
			| $(filter_SVGWORK)/.dir
	$(call gb_Output_announce,$(subst $(WORKDIR)/,,$@),build,GPF,3)
	$(call gb_Helper_abbreviate_dirs, \
		$(call gb_ExternalExecutable_get_command,python) \
			$(filter_SRC_svg_GenToken) \
			$(filter_SRC_svg_Tokens) $(filter_GEN_svg_Tokens_hxx) \
			$(filter_GEN_svg_Tokens_gperf))

# dummy rule: both files generated by recipe above
$(filter_GEN_svg_Tokens_hxx) : $(filter_GEN_svg_Tokens_gperf)

$(filter_GEN_svg_Tokens_cxx) : $(filter_GEN_svg_Tokens_gperf)
	$(call gb_Output_announce,$(subst $(WORKDIR)/,,$@),build,GPF,1)
	$(call gb_Helper_abbreviate_dirs, \
		 $(GPERF) --compare-strncmp -C -m 20 --switch=2 --readonly-tables $(filter_GEN_svg_Tokens_gperf) \
			 | sed -e "s/(char\*)0/(char\*)0$(COMMA) 0/g" \
			 > $(filter_GEN_svg_Tokens_cxx))

$(filter_GEN_svg_Script_hxx) : \
			$(call gb_ExternalExecutable_get_dependencies,python) \
			$(filter_SRC_svg_PresentationEngine) $(filter_SRC_svg_Js2Hxx) \
			| $(filter_SVGWORK)/.dir
	$(call gb_Output_announce,$(subst $(WORKDIR)/,,$@),build,PY ,1)
	$(call gb_Helper_abbreviate_dirs, \
		$(call gb_ExternalExecutable_get_command,python) $(filter_SRC_svg_Js2Hxx) \
			$(filter_SRC_svg_PresentationEngine) \
			$(filter_GEN_svg_Script_hxx))

$(call gb_CustomTarget_get_target,filter/source/svg) : \
	$(filter_GEN_svg_Tokens_gperf) \
	$(filter_GEN_svg_Tokens_hxx) \
	$(filter_GEN_svg_Tokens_cxx) \
	$(filter_GEN_svg_Script_hxx) \

# vim: set noet sw=4 ts=4:
