/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4; fill-column: 100 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */
#ifndef INCLUDED_CUI_INC_SIGNATURELINEDIALOGBASE_HXX
#define INCLUDED_CUI_INC_SIGNATURELINEDIALOGBASE_HXX

#include <vcl/weld.hxx>

#include <com/sun/star/frame/XModel.hpp>
#include <com/sun/star/uno/Reference.hxx>

class SignatureLineDialogBase : public weld::GenericDialogController
{
public:
    SignatureLineDialogBase(weld::Widget* pParent, css::uno::Reference<css::frame::XModel> xModel,
                            const OUString& rUIFile, const OString& rDialogId);

    virtual short run() override;

protected:
    css::uno::Reference<css::frame::XModel> m_xModel;
    static OUString getSignatureImage();
    virtual void Apply() = 0;
    static OUString getCDataString(const OUString& rString);
};

#endif

/* vim:set shiftwidth=4 softtabstop=4 expandtab cinoptions=b1,g0,N-s cinkeys+=0=break: */
