# -*- tab-width: 4; indent-tabs-mode: nil; py-indent-offset: 4 -*-
#
# This file is part of the LibreOffice project.
#
# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.
#

# generate AutoInstall files from gbuild data for further scp2 processing

from __future__ import print_function

import sys

module = sys.argv[1]
scp2componentcondition = sys.argv[2]
scp2libtemplate = sys.argv[3]
scp2exetemplate = sys.argv[4]
scp2jartemplate = sys.argv[5]
# use 'with open(file) as f:' to avoid 'ResourceWarning: unclosed file'
with open(sys.argv[6]) as f:
    sdklibs = f.readline().split()
with open(sys.argv[7]) as f:
    libs = f.readline().split()
with open(sys.argv[8]) as f:
    exes = f.readline().split()
with open(sys.argv[9]) as f:
    jars = f.readline().split()
with open(sys.argv[10]) as f:
    pkgs = f.readline().split()

if len(scp2componentcondition) > 0:
    scp2componentcondition = "," + scp2componentcondition

def escape(string):
    return string.replace(".", "_").replace("-", "_").replace("/", "_")

def to_tuple(l):
    ret = []
    i = 0
    while i < len(l):
        ret.append((l[i], l[i+1]))
        i += 2
    return ret

def to_triple(l):
    ret = []
    i = 0
    while i < len(l):
        ret.append((l[i], l[i+1], l[i+2]))
        i += 3
    return ret

print("/* autogenerated installs for group " + module + " */")
print("#define auto_" + module + "_ALL \\")

autosdklibs = [("auto_" + module + "_link_" + escape(lib),link,target) for (lib,link,target) in to_triple(sdklibs)]
autolibs = [("auto_" + module + "_lib_" + escape(lib),libfile) for (lib,libfile) in to_tuple(libs)]
autoexes = [("auto_" + module + "_exe_" + escape(exe),exefile) for (exe,exefile) in to_tuple(exes)]
autojars = [("auto_" + module + "_jar_" + escape(jar),jar + ".jar") for jar in jars]
autopkgs = [("auto_" + module + "_pkg_" + escape(pkg),pkg + ".filelist") for pkg in pkgs]

allgids = [gid for (gid,_,_) in autosdklibs] + \
          [gid for (gid,_) in autolibs] + \
          [gid for (gid,_) in autoexes] + \
          [gid for (gid,_) in autojars] + \
          [gid for (gid,_) in autopkgs]

print(", \\\n".join(["    " + gid for gid in allgids]))

for (gid, link, target) in autosdklibs:
    print("SDK_LIBRARY_LINK(" + gid + "," + link + "," + target + ")")

for (gid, libfile) in autolibs:
    print(scp2libtemplate + "(" + gid + "," + libfile + scp2componentcondition + ")")

for (gid, exefile) in autoexes:
    print(scp2exetemplate + "(" + gid + "," + exefile + scp2componentcondition + ")")

for (gid, jarfile) in autojars:
    print(scp2jartemplate + "(" + gid + "," + jarfile + scp2componentcondition + ")")

for (gid, pkgfilelist) in autopkgs:
    print("PACKAGE_FILELIST(" + gid + "," + pkgfilelist + ")")

# vim:set shiftwidth=4 softtabstop=4 expandtab:
