/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Version: MPL 1.1 / GPLv3+ / LGPLv3+
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License or as specified alternatively below. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Major Contributor(s):
 * Copyright (C) 2012 Markus Mohrhard <markus.mohrhard@googlemail.com> (initial developer)
 *
 * All Rights Reserved.
 *
 * For minor contributions see the git repository.
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 3 or later (the "GPLv3+"), or
 * the GNU Lesser General Public License Version 3 or later (the "LGPLv3+"),
 * in which case the provisions of the GPLv3+ or the LGPLv3+ are applicable
 * instead of those above.
 */

#include <test/sheet/xcellrangereferrer.hxx>
#include <com/sun/star/table/XCellRange.hpp>
#include <com/sun/star/sheet/XCellRangeAddressable.hpp>
#include <com/sun/star/sheet/XCellRangeReferrer.hpp>
#include "cppunit/extensions/HelperMacros.h"

using namespace com::sun::star::uno;

namespace apitest {

void XCellRangeReferrer::testGetReferredCells()
{
    uno::Reference< sheet::XCellRangeReferrer > xReferrer(init(), UNO_QUERY_THROW);
    uno::Reference< table::XCellRange > xReferredRange = xReferrer->getReferredCells();

    uno::Reference< sheet::XCellRangeAddressable > xAdressable( xReferredRange, UNO_QUERY_THROW );
    table::CellRangeAddress aCellRange = xAdressable->getRangeAddress();

    CPPUNIT_ASSERT_EQUAL( aCellRange.Sheet, maCellRange.Sheet );
    CPPUNIT_ASSERT_EQUAL( aCellRange.StartRow, maCellRange.StartRow );
    CPPUNIT_ASSERT_EQUAL( aCellRange.EndRow, maCellRange.EndRow );
    CPPUNIT_ASSERT_EQUAL( aCellRange.StartColumn, maCellRange.StartColumn );
    CPPUNIT_ASSERT_EQUAL( aCellRange.EndColumn, maCellRange.EndColumn );
}

}

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
