// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//     http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by make build. DO NOT EDIT

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.23.2
// source: yunikorn-scheduler-interface/si.proto

package si

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Scheduler_RegisterResourceManager_FullMethodName = "/si.v1.Scheduler/RegisterResourceManager"
	Scheduler_UpdateAllocation_FullMethodName        = "/si.v1.Scheduler/UpdateAllocation"
	Scheduler_UpdateApplication_FullMethodName       = "/si.v1.Scheduler/UpdateApplication"
	Scheduler_UpdateNode_FullMethodName              = "/si.v1.Scheduler/UpdateNode"
)

// SchedulerClient is the client API for Scheduler service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type SchedulerClient interface {
	// Register a RM, if it is a reconnect from previous RM the call will
	// trigger a cleanup of all in-memory data and resync with RM.
	RegisterResourceManager(ctx context.Context, in *RegisterResourceManagerRequest, opts ...grpc.CallOption) (*RegisterResourceManagerResponse, error)
	// Update Scheduler status (this includes node status update, allocation request
	// updates, etc. And receive updates from scheduler for allocation changes,
	// any required status changes, etc.
	// Update allocation request
	UpdateAllocation(ctx context.Context, opts ...grpc.CallOption) (Scheduler_UpdateAllocationClient, error)
	// Update application request
	UpdateApplication(ctx context.Context, opts ...grpc.CallOption) (Scheduler_UpdateApplicationClient, error)
	// Update node info
	UpdateNode(ctx context.Context, opts ...grpc.CallOption) (Scheduler_UpdateNodeClient, error)
}

type schedulerClient struct {
	cc grpc.ClientConnInterface
}

func NewSchedulerClient(cc grpc.ClientConnInterface) SchedulerClient {
	return &schedulerClient{cc}
}

func (c *schedulerClient) RegisterResourceManager(ctx context.Context, in *RegisterResourceManagerRequest, opts ...grpc.CallOption) (*RegisterResourceManagerResponse, error) {
	out := new(RegisterResourceManagerResponse)
	err := c.cc.Invoke(ctx, Scheduler_RegisterResourceManager_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *schedulerClient) UpdateAllocation(ctx context.Context, opts ...grpc.CallOption) (Scheduler_UpdateAllocationClient, error) {
	stream, err := c.cc.NewStream(ctx, &Scheduler_ServiceDesc.Streams[0], Scheduler_UpdateAllocation_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &schedulerUpdateAllocationClient{stream}
	return x, nil
}

type Scheduler_UpdateAllocationClient interface {
	Send(*AllocationRequest) error
	Recv() (*AllocationResponse, error)
	grpc.ClientStream
}

type schedulerUpdateAllocationClient struct {
	grpc.ClientStream
}

func (x *schedulerUpdateAllocationClient) Send(m *AllocationRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *schedulerUpdateAllocationClient) Recv() (*AllocationResponse, error) {
	m := new(AllocationResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *schedulerClient) UpdateApplication(ctx context.Context, opts ...grpc.CallOption) (Scheduler_UpdateApplicationClient, error) {
	stream, err := c.cc.NewStream(ctx, &Scheduler_ServiceDesc.Streams[1], Scheduler_UpdateApplication_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &schedulerUpdateApplicationClient{stream}
	return x, nil
}

type Scheduler_UpdateApplicationClient interface {
	Send(*ApplicationRequest) error
	Recv() (*ApplicationResponse, error)
	grpc.ClientStream
}

type schedulerUpdateApplicationClient struct {
	grpc.ClientStream
}

func (x *schedulerUpdateApplicationClient) Send(m *ApplicationRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *schedulerUpdateApplicationClient) Recv() (*ApplicationResponse, error) {
	m := new(ApplicationResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *schedulerClient) UpdateNode(ctx context.Context, opts ...grpc.CallOption) (Scheduler_UpdateNodeClient, error) {
	stream, err := c.cc.NewStream(ctx, &Scheduler_ServiceDesc.Streams[2], Scheduler_UpdateNode_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &schedulerUpdateNodeClient{stream}
	return x, nil
}

type Scheduler_UpdateNodeClient interface {
	Send(*NodeRequest) error
	Recv() (*NodeResponse, error)
	grpc.ClientStream
}

type schedulerUpdateNodeClient struct {
	grpc.ClientStream
}

func (x *schedulerUpdateNodeClient) Send(m *NodeRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *schedulerUpdateNodeClient) Recv() (*NodeResponse, error) {
	m := new(NodeResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// SchedulerServer is the server API for Scheduler service.
// All implementations must embed UnimplementedSchedulerServer
// for forward compatibility
type SchedulerServer interface {
	// Register a RM, if it is a reconnect from previous RM the call will
	// trigger a cleanup of all in-memory data and resync with RM.
	RegisterResourceManager(context.Context, *RegisterResourceManagerRequest) (*RegisterResourceManagerResponse, error)
	// Update Scheduler status (this includes node status update, allocation request
	// updates, etc. And receive updates from scheduler for allocation changes,
	// any required status changes, etc.
	// Update allocation request
	UpdateAllocation(Scheduler_UpdateAllocationServer) error
	// Update application request
	UpdateApplication(Scheduler_UpdateApplicationServer) error
	// Update node info
	UpdateNode(Scheduler_UpdateNodeServer) error
	mustEmbedUnimplementedSchedulerServer()
}

// UnimplementedSchedulerServer must be embedded to have forward compatible implementations.
type UnimplementedSchedulerServer struct {
}

func (UnimplementedSchedulerServer) RegisterResourceManager(context.Context, *RegisterResourceManagerRequest) (*RegisterResourceManagerResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RegisterResourceManager not implemented")
}
func (UnimplementedSchedulerServer) UpdateAllocation(Scheduler_UpdateAllocationServer) error {
	return status.Errorf(codes.Unimplemented, "method UpdateAllocation not implemented")
}
func (UnimplementedSchedulerServer) UpdateApplication(Scheduler_UpdateApplicationServer) error {
	return status.Errorf(codes.Unimplemented, "method UpdateApplication not implemented")
}
func (UnimplementedSchedulerServer) UpdateNode(Scheduler_UpdateNodeServer) error {
	return status.Errorf(codes.Unimplemented, "method UpdateNode not implemented")
}
func (UnimplementedSchedulerServer) mustEmbedUnimplementedSchedulerServer() {}

// UnsafeSchedulerServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to SchedulerServer will
// result in compilation errors.
type UnsafeSchedulerServer interface {
	mustEmbedUnimplementedSchedulerServer()
}

func RegisterSchedulerServer(s grpc.ServiceRegistrar, srv SchedulerServer) {
	s.RegisterService(&Scheduler_ServiceDesc, srv)
}

func _Scheduler_RegisterResourceManager_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RegisterResourceManagerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SchedulerServer).RegisterResourceManager(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Scheduler_RegisterResourceManager_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SchedulerServer).RegisterResourceManager(ctx, req.(*RegisterResourceManagerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Scheduler_UpdateAllocation_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(SchedulerServer).UpdateAllocation(&schedulerUpdateAllocationServer{stream})
}

type Scheduler_UpdateAllocationServer interface {
	Send(*AllocationResponse) error
	Recv() (*AllocationRequest, error)
	grpc.ServerStream
}

type schedulerUpdateAllocationServer struct {
	grpc.ServerStream
}

func (x *schedulerUpdateAllocationServer) Send(m *AllocationResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *schedulerUpdateAllocationServer) Recv() (*AllocationRequest, error) {
	m := new(AllocationRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _Scheduler_UpdateApplication_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(SchedulerServer).UpdateApplication(&schedulerUpdateApplicationServer{stream})
}

type Scheduler_UpdateApplicationServer interface {
	Send(*ApplicationResponse) error
	Recv() (*ApplicationRequest, error)
	grpc.ServerStream
}

type schedulerUpdateApplicationServer struct {
	grpc.ServerStream
}

func (x *schedulerUpdateApplicationServer) Send(m *ApplicationResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *schedulerUpdateApplicationServer) Recv() (*ApplicationRequest, error) {
	m := new(ApplicationRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _Scheduler_UpdateNode_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(SchedulerServer).UpdateNode(&schedulerUpdateNodeServer{stream})
}

type Scheduler_UpdateNodeServer interface {
	Send(*NodeResponse) error
	Recv() (*NodeRequest, error)
	grpc.ServerStream
}

type schedulerUpdateNodeServer struct {
	grpc.ServerStream
}

func (x *schedulerUpdateNodeServer) Send(m *NodeResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *schedulerUpdateNodeServer) Recv() (*NodeRequest, error) {
	m := new(NodeRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// Scheduler_ServiceDesc is the grpc.ServiceDesc for Scheduler service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Scheduler_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "si.v1.Scheduler",
	HandlerType: (*SchedulerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "RegisterResourceManager",
			Handler:    _Scheduler_RegisterResourceManager_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "UpdateAllocation",
			Handler:       _Scheduler_UpdateAllocation_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "UpdateApplication",
			Handler:       _Scheduler_UpdateApplication_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "UpdateNode",
			Handler:       _Scheduler_UpdateNode_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "yunikorn-scheduler-interface/si.proto",
}
