/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.util.lang.Classes;

public class EnumChoiceRenderer<T extends Enum<T>>
extends ChoiceRenderer<T> {
    private static final long serialVersionUID = 1L;
    private final Component resourceSource;

    public EnumChoiceRenderer() {
        this((Component)null);
    }

    public EnumChoiceRenderer(Component resourceSource) {
        this.resourceSource = resourceSource;
    }

    @Override
    public Object getDisplayValue(T object) {
        String key = this.resourceKey(object);
        String value = this.resourceSource != null ? this.resourceSource.getString(key) : Application.get().getResourceSettings().getLocalizer().getString(key, null);
        return value;
    }

    protected String resourceKey(T object) {
        return Classes.simpleName(((Enum)object).getDeclaringClass()) + "." + ((Enum)object).name();
    }

    @Override
    public String getIdValue(T object, int index) {
        return ((Enum)object).name();
    }
}

