/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import java.util.Locale;
import org.apache.wicket.Component;
import org.apache.wicket.IMarkupIdGenerator;
import org.apache.wicket.Session;
import org.apache.wicket.util.string.Strings;

public class DefaultMarkupIdGenerator
implements IMarkupIdGenerator {
    @Override
    public String generateMarkupId(Component component, boolean createIfDoesNotExist) {
        String markupIdPostfix;
        Object markupId;
        char c;
        int generatedMarkupId;
        Object storedMarkupId = component.getMarkupIdImpl();
        if (storedMarkupId instanceof String) {
            return (String)storedMarkupId;
        }
        if (storedMarkupId == null && !createIfDoesNotExist) {
            return null;
        }
        Session session = component.getSession();
        int n = generatedMarkupId = storedMarkupId instanceof Integer ? ((Integer)storedMarkupId).intValue() : session.nextSequenceValue();
        if (generatedMarkupId == 173) {
            generatedMarkupId = session.nextSequenceValue();
        }
        if (storedMarkupId == null) {
            component.setMarkupIdImpl(generatedMarkupId);
        }
        String markupIdPrefix = "id";
        if (component.getApplication().usesDevelopmentConfig()) {
            markupIdPrefix = component.getId();
        }
        if (!Character.isLetter(c = ((String)(markupId = markupIdPrefix + (markupIdPostfix = Integer.toHexString(generatedMarkupId).toLowerCase(Locale.ROOT)))).charAt(0))) {
            markupId = "id" + (String)markupId;
        }
        markupId = Strings.replaceAll((CharSequence)markupId, "_", "__").toString();
        markupId = ((String)markupId).replace('.', '_');
        markupId = ((String)markupId).replace('-', '_');
        markupId = ((String)markupId).replace(' ', '_');
        return markupId;
    }
}

