/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.AbstractCheckSelector;
import org.apache.wicket.markup.html.form.CheckBox;

public class CheckBoxSelector
extends AbstractCheckSelector {
    private static final long serialVersionUID = 1L;
    private final Set<CheckBox> connectedCheckBoxes = new HashSet<CheckBox>();
    private final Behavior cleanup = new Behavior(){
        private static final long serialVersionUID = 1L;

        @Override
        public void onRemove(Component component) {
            CheckBoxSelector.this.connectedCheckBoxes.remove(component);
            component.remove(this);
        }
    };

    public CheckBoxSelector(String id) {
        super(id);
    }

    public CheckBoxSelector(String id, CheckBox ... boxes) {
        super(id);
        for (CheckBox box : boxes) {
            this.connectedCheckBoxes.add(box);
            box.add(this.cleanup);
        }
    }

    @Override
    protected CharSequence getFindCheckboxesFunction() {
        return String.format("Wicket.CheckboxSelector.getCheckboxesFunction(%s)", this.buildMarkupIdJSArrayLiteral(this.getCheckBoxes()));
    }

    protected Iterable<? extends CheckBox> getCheckBoxes() {
        return this.connectedCheckBoxes;
    }

    private String buildMarkupIdJSArrayLiteral(Iterable<? extends CheckBox> components) {
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        if (components.iterator().hasNext()) {
            for (Component component : components) {
                buf.append('\'').append(component.getMarkupId()).append("', ");
            }
            buf.delete(buf.length() - 2, buf.length());
        }
        buf.append(']');
        return buf.toString();
    }

    public static final Iterable<CheckBox> collectCheckBoxes(WebMarkupContainer container) {
        ArrayList<CheckBox> checkBoxes = new ArrayList<CheckBox>();
        container.visitChildren(CheckBox.class, (child, visit) -> checkBoxes.add((CheckBox)child));
        return checkBoxes;
    }
}

