/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.ops4j.lang.NullArgumentException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServicePropertiesUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ServicePropertiesUtils.class);

    private ServicePropertiesUtils() {
    }

    public static String getStringProperty(ServiceReference<?> serviceReference, String key) {
        NullArgumentException.validateNotNull(serviceReference, "Service reference");
        NullArgumentException.validateNotEmpty(key, true, "Property key");
        Object value = serviceReference.getProperty(key);
        if (value != null && !(value instanceof String)) {
            LOG.error("Property [" + key + "] value must be a String");
            return null;
        }
        return (String)value;
    }

    public static Boolean getBooleanProperty(ServiceReference<?> serviceReference, String key) {
        String stringProperty = ServicePropertiesUtils.getStringProperty(serviceReference, key);
        return Boolean.parseBoolean(stringProperty);
    }

    public static Integer getIntegerProperty(ServiceReference<?> serviceReference, String key) {
        NullArgumentException.validateNotNull(serviceReference, "Service reference");
        NullArgumentException.validateNotEmpty(key, true, "Property key");
        Object value = serviceReference.getProperty(key);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value != null) {
            try {
                return Integer.parseInt(String.valueOf(value));
            }
            catch (NumberFormatException e) {
                String message = String.format("Property [%s] value must be an Integer: %s", key, e.getMessage());
                LOG.error(message, (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public static String[] getArrayOfStringProperty(ServiceReference<?> serviceReference, String key) {
        NullArgumentException.validateNotNull(serviceReference, "Service reference");
        NullArgumentException.validateNotEmpty(key, true, "Property key");
        Object value = serviceReference.getProperty(key);
        if (value instanceof String) {
            return new String[]{((String)value).trim()};
        }
        if (value instanceof String[]) {
            return (String[])value;
        }
        if (value instanceof Collection) {
            Collection collectionValues = (Collection)value;
            String[] values = new String[collectionValues.size()];
            int i = 0;
            for (Object current : collectionValues) {
                values[i++] = current != null ? String.valueOf(current).trim() : null;
            }
            return values;
        }
        return null;
    }

    public static Map<String, Object> getSubsetStartingWith(ServiceReference<?> serviceReference, String prefix) {
        HashMap<String, Object> subset = new HashMap<String, Object>();
        for (String key : serviceReference.getPropertyKeys()) {
            if (key == null || !key.startsWith(prefix) || key.trim().length() <= prefix.length()) continue;
            subset.put(key.substring(prefix.length()), serviceReference.getProperty(key));
        }
        if (subset.isEmpty()) {
            return null;
        }
        return subset;
    }

    public static Object mergePropertyListOfStringsToArrayOfStrings(Object objectToMerge, List<String> listOfStrings) {
        HashSet<String> setToMerge = new HashSet<String>();
        setToMerge.addAll(listOfStrings);
        if (objectToMerge instanceof String && ((String)objectToMerge).trim().length() != 0) {
            setToMerge.add((String)objectToMerge);
        } else if (objectToMerge instanceof String[]) {
            setToMerge.addAll(Arrays.asList((String[])objectToMerge));
        }
        return setToMerge.toArray(new String[setToMerge.size()]);
    }

    public static String extractHttpContextId(ServiceReference<?> serviceReference) {
        String httpContextSelector;
        String httpContextId = ServicePropertiesUtils.getStringProperty(serviceReference, "httpContext.id");
        if (httpContextId == null && (httpContextSelector = ServicePropertiesUtils.getStringProperty(serviceReference, "osgi.http.whiteboard.context.select")) != null) {
            httpContextSelector = httpContextSelector.substring(1, httpContextSelector.length());
            httpContextId = httpContextSelector.substring("osgi.http.whiteboard.context.name".length() + 1);
            httpContextId = httpContextId.substring(0, httpContextId.length() - 1);
        }
        return httpContextId;
    }

    public static Boolean extractSharedHttpContext(ServiceReference<?> serviceReference) {
        Boolean sharedHttpContext = Boolean.parseBoolean((String)serviceReference.getProperty("httpContext.shared"));
        if (serviceReference.getProperty("osgi.http.whiteboard.context.select") != null) {
            sharedHttpContext = true;
        }
        return sharedHttpContext;
    }
}

