/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.region;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.hibernate.RegionCache;
import com.hazelcast.hibernate.access.NonStrictReadWriteAccessDelegate;
import com.hazelcast.hibernate.access.ReadOnlyAccessDelegate;
import com.hazelcast.hibernate.access.ReadWriteAccessDelegate;
import com.hazelcast.hibernate.region.AbstractTransactionalDataRegion;
import com.hazelcast.hibernate.region.EntityRegionAccessStrategyAdapter;
import java.util.Properties;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.EntityRegion;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.EntityRegionAccessStrategy;

public final class HazelcastEntityRegion<Cache extends RegionCache>
extends AbstractTransactionalDataRegion<Cache>
implements EntityRegion {
    public HazelcastEntityRegion(HazelcastInstance instance, String regionName, Properties props, CacheDataDescription metadata, Cache cache) {
        super(instance, regionName, props, metadata, cache);
    }

    public EntityRegionAccessStrategy buildAccessStrategy(AccessType accessType) throws CacheException {
        if (AccessType.READ_ONLY.equals((Object)accessType)) {
            return new EntityRegionAccessStrategyAdapter(new ReadOnlyAccessDelegate<HazelcastEntityRegion>(this, this.props));
        }
        if (AccessType.NONSTRICT_READ_WRITE.equals((Object)accessType)) {
            return new EntityRegionAccessStrategyAdapter(new NonStrictReadWriteAccessDelegate<HazelcastEntityRegion>(this, this.props));
        }
        if (AccessType.READ_WRITE.equals((Object)accessType)) {
            return new EntityRegionAccessStrategyAdapter(new ReadWriteAccessDelegate<HazelcastEntityRegion>(this, this.props));
        }
        throw new CacheException("AccessType \"" + accessType + "\" is not currently supported by Hazelcast.");
    }
}

