/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.healthcheck.provider;

import java.util.concurrent.TimeUnit;
import org.apache.unomi.api.PropertyType;
import org.apache.unomi.healthcheck.HealthCheckProvider;
import org.apache.unomi.healthcheck.HealthCheckResponse;
import org.apache.unomi.healthcheck.util.CachedValue;
import org.apache.unomi.persistence.spi.PersistenceService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={HealthCheckProvider.class}, immediate=true)
public class PersistenceHealthCheckProvider
implements HealthCheckProvider {
    public static final String NAME = "persistence";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)PersistenceHealthCheckProvider.class.getName());
    private final CachedValue<HealthCheckResponse> cache = new CachedValue(5L, TimeUnit.MINUTES);
    @Reference(service=PersistenceService.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, bind="bind", unbind="unbind")
    private volatile PersistenceService service;

    public PersistenceHealthCheckProvider() {
        LOGGER.info("Building persistence health provider service...");
    }

    public void bind(PersistenceService service) {
        this.service = service;
    }

    public void unbind(PersistenceService service) {
        this.service = null;
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public HealthCheckResponse execute() {
        LOGGER.debug("Health check persistence");
        if (this.cache.isStaled() || this.cache.getValue().isDown() || this.cache.getValue().isError()) {
            this.cache.setValue(this.refresh());
        }
        return this.cache.getValue();
    }

    private HealthCheckResponse refresh() {
        LOGGER.debug("Refresh value");
        HealthCheckResponse.Builder builder = new HealthCheckResponse.Builder();
        builder.name(NAME).down();
        try {
            if (this.service != null) {
                builder.up();
                if (!this.service.query("target", "profiles", null, PropertyType.class).isEmpty()) {
                    builder.live();
                }
            }
        }
        catch (Exception e) {
            builder.error().withData("error", e.getMessage());
            LOGGER.error("Error while checking persistence health", (Throwable)e);
        }
        return builder.build();
    }
}

