/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.storage.handler.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.uniffle.common.BufferSegment;
import org.apache.uniffle.common.ShuffleDataResult;
import org.apache.uniffle.common.ShuffleServerInfo;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.exception.RssFetchFailedException;
import org.apache.uniffle.storage.handler.ClientReadHandlerMetric;
import org.apache.uniffle.storage.handler.api.ClientReadHandler;
import org.apache.uniffle.storage.handler.impl.AbstractClientReadHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComposedClientReadHandler
extends AbstractClientReadHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ComposedClientReadHandler.class);
    private final ShuffleServerInfo serverInfo;
    private final Map<Tier, Supplier<ClientReadHandler>> supplierMap = new EnumMap<Tier, Supplier<ClientReadHandler>>(Tier.class);
    private final Map<Tier, ClientReadHandler> handlerMap = new EnumMap<Tier, ClientReadHandler>(Tier.class);
    private final Map<Tier, ClientReadHandlerMetric> metricsMap = new EnumMap<Tier, ClientReadHandlerMetric>(Tier.class);
    private Tier currentTier = Tier.VALUES[0];
    private final int numTiers;

    public ComposedClientReadHandler(ShuffleServerInfo serverInfo, ClientReadHandler ... handlers) {
        for (Tier tier : Tier.VALUES) {
            this.metricsMap.put(tier, new ClientReadHandlerMetric());
        }
        Preconditions.checkArgument((handlers.length <= Tier.VALUES.length ? 1 : 0) != 0, (String)"Too many handlers, got %d, max %d", (int)handlers.length, (int)Tier.VALUES.length);
        this.serverInfo = serverInfo;
        this.numTiers = handlers.length;
        for (int i = 0; i < this.numTiers; ++i) {
            this.handlerMap.put(Tier.VALUES[i], handlers[i]);
        }
    }

    public ComposedClientReadHandler(ShuffleServerInfo serverInfo, List<Supplier<ClientReadHandler>> suppliers) {
        for (Tier tier : Tier.VALUES) {
            this.metricsMap.put(tier, new ClientReadHandlerMetric());
        }
        Preconditions.checkArgument((suppliers.size() <= Tier.VALUES.length ? 1 : 0) != 0, (String)"Too many suppliers, got %d, max %d", (int)suppliers.size(), (int)Tier.VALUES.length);
        this.serverInfo = serverInfo;
        this.numTiers = suppliers.size();
        for (int i = 0; i < this.numTiers; ++i) {
            this.supplierMap.put(Tier.VALUES[i], suppliers.get(i));
        }
    }

    @Override
    public ShuffleDataResult readShuffleData() {
        ShuffleDataResult shuffleDataResult;
        ClientReadHandler handler = this.handlerMap.computeIfAbsent(this.currentTier, key -> this.supplierMap.getOrDefault(key, () -> null).get());
        if (handler == null) {
            throw new RssException("Unexpected null when getting " + this.currentTier.name() + " handler");
        }
        try {
            shuffleDataResult = handler.readShuffleData();
        }
        catch (RssFetchFailedException e) {
            Throwable cause = e.getCause();
            String message = "Failed to read shuffle data from " + this.currentTier.name() + "handler, error: " + e.getMessage();
            throw new RssFetchFailedException(message, cause);
        }
        catch (Exception e) {
            throw new RssFetchFailedException("Failed to read shuffle data from " + this.currentTier.name() + " handler", (Throwable)e);
        }
        if (shuffleDataResult == null || shuffleDataResult.isEmpty()) {
            if (this.currentTier.ordinal() + 1 >= this.numTiers) {
                return null;
            }
            this.currentTier = this.currentTier.next();
            return this.readShuffleData();
        }
        return shuffleDataResult;
    }

    @Override
    public void close() {
        this.handlerMap.values().stream().filter(Objects::nonNull).forEach(ClientReadHandler::close);
    }

    @Override
    public void updateConsumedBlockInfo(BufferSegment bs, boolean isSkippedMetrics) {
        if (bs == null) {
            return;
        }
        super.updateConsumedBlockInfo(bs, isSkippedMetrics);
        this.updateBlockMetric(this.metricsMap.get((Object)this.currentTier), bs, isSkippedMetrics);
    }

    @Override
    public void logConsumedBlockInfo() {
        LOG.info(this.getReadBlockNumInfo());
        LOG.info(this.getReadLengthInfo());
        LOG.info(this.getReadUncompressLengthInfo());
    }

    @VisibleForTesting
    public String getReadBlockNumInfo() {
        return this.getMetricsInfo("blocks", ClientReadHandlerMetric::getReadBlockNum, ClientReadHandlerMetric::getSkippedReadBlockNum);
    }

    @VisibleForTesting
    public String getReadLengthInfo() {
        return this.getMetricsInfo("bytes", ClientReadHandlerMetric::getReadLength, ClientReadHandlerMetric::getSkippedReadLength);
    }

    @VisibleForTesting
    public String getReadUncompressLengthInfo() {
        return this.getMetricsInfo("uncompressed bytes", ClientReadHandlerMetric::getReadUncompressLength, ClientReadHandlerMetric::getSkippedReadUncompressLength);
    }

    private String getMetricsInfo(String name, Function<ClientReadHandlerMetric, Long> consumed, Function<ClientReadHandlerMetric, Long> skipped) {
        StringBuilder sb = new StringBuilder("Client read ").append(consumed.apply(this.readHandlerMetric)).append(" ").append(name).append(" from [").append(this.serverInfo).append("], Consumed[");
        for (Tier tier : Tier.VALUES) {
            sb.append(" ").append(tier.name().toLowerCase()).append(":").append(consumed.apply(this.metricsMap.get((Object)tier)));
        }
        sb.append(" ], Skipped[");
        for (Tier tier : Tier.VALUES) {
            sb.append(" ").append(tier.name().toLowerCase()).append(":").append(skipped.apply(this.metricsMap.get((Object)tier)));
        }
        sb.append(" ]");
        return sb.toString();
    }

    private static enum Tier {
        HOT,
        WARM,
        COLD,
        FROZEN;

        static final Tier[] VALUES;

        Tier next() {
            return VALUES[this.ordinal() + 1];
        }

        static {
            VALUES = Tier.values();
        }
    }
}

