/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.server;

import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.uniffle.common.util.ThreadUtils;
import org.apache.uniffle.server.ShuffleServerConf;
import org.apache.uniffle.server.ShuffleServerMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyDirectMemoryTracker {
    private static final Logger LOG = LoggerFactory.getLogger(NettyDirectMemoryTracker.class);
    private final long reportInitialDelay;
    private final long reportInterval;
    private final ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor(ThreadUtils.getThreadFactory((String)"NettyDirectMemoryTracker"));

    public NettyDirectMemoryTracker(ShuffleServerConf conf) {
        this.reportInitialDelay = conf.getLong(ShuffleServerConf.SERVER_NETTY_DIRECT_MEMORY_USAGE_TRACKER_DELAY);
        this.reportInterval = conf.getLong(ShuffleServerConf.SERVER_NETTY_DIRECT_MEMORY_USAGE_TRACKER_INTERVAL);
    }

    public void start() {
        LOG.info("Start report direct memory usage to MetricSystem after {}ms and interval is {}ms", (Object)this.reportInitialDelay, (Object)this.reportInterval);
        this.service.scheduleAtFixedRate(() -> {
            try {
                long usedDirectMemoryByNetty = io.netty.util.internal.PlatformDependent.usedDirectMemory();
                long usedDirectMemoryByGrpcNetty = PlatformDependent.usedDirectMemory();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Current usedDirectMemoryByNetty:{}, usedDirectMemoryByGrpcNetty:{}", (Object)usedDirectMemoryByNetty, (Object)usedDirectMemoryByGrpcNetty);
                }
                ShuffleServerMetrics.gaugeUsedDirectMemorySizeByNetty.set((double)usedDirectMemoryByNetty);
                ShuffleServerMetrics.gaugeUsedDirectMemorySizeByGrpcNetty.set((double)usedDirectMemoryByGrpcNetty);
                ShuffleServerMetrics.gaugeUsedDirectMemorySize.set((double)(usedDirectMemoryByNetty + usedDirectMemoryByGrpcNetty));
            }
            catch (Throwable t) {
                LOG.error("Failed to report direct memory.", t);
            }
        }, this.reportInitialDelay, this.reportInterval, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        this.service.shutdownNow();
    }
}

