/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.om.security;

import jakarta.servlet.http.HttpSessionBindingEvent;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.fulcrum.security.model.turbine.entity.TurbineUser;
import org.apache.fulcrum.security.model.turbine.entity.TurbineUserGroupRole;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.turbine.om.security.User;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.security.SecurityService;
import org.apache.turbine.util.ObjectUtils;

public class DefaultUserImpl
implements User {
    private static final long serialVersionUID = -1866504873085624111L;
    private Date lastAccessDate = null;
    private Map<String, Object> permStorage = null;
    private Map<String, Object> tempStorage = null;
    private TurbineUser userDelegate = null;

    public DefaultUserImpl(TurbineUser user) {
        this.setUserDelegate(user);
        this.setCreateDate(new Date());
        this.tempStorage = new HashMap<String, Object>(10);
        this.setHasLoggedIn(Boolean.FALSE);
    }

    public void valueBound(HttpSessionBindingEvent hsbe) {
    }

    public void valueUnbound(HttpSessionBindingEvent hsbe) {
        try {
            if (this.hasLoggedIn()) {
                SecurityService securityService = (SecurityService)TurbineServices.getInstance().getService("SecurityService");
                securityService.saveOnSessionUnbind(this);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public String getName() {
        return this.userDelegate.getName();
    }

    public void setName(String name) {
        this.userDelegate.setName(name);
    }

    public Object getId() {
        return this.userDelegate.getId();
    }

    public void setId(Object id) {
        this.userDelegate.setId(id);
    }

    public String getPassword() {
        return this.userDelegate.getPassword();
    }

    public void setPassword(String password) {
        this.userDelegate.setPassword(password);
    }

    public String getFirstName() {
        return this.userDelegate.getFirstName();
    }

    public void setFirstName(String firstName) {
        this.userDelegate.setFirstName(firstName);
    }

    public String getLastName() {
        return this.userDelegate.getLastName();
    }

    public void setLastName(String lastName) {
        this.userDelegate.setLastName(lastName);
    }

    public String getEmail() {
        return this.userDelegate.getEmail();
    }

    public void setEmail(String address) {
        this.userDelegate.setEmail(address);
    }

    public byte[] getObjectdata() {
        return this.userDelegate.getObjectdata();
    }

    public void setObjectdata(byte[] objectdata) {
        this.userDelegate.setObjectdata(objectdata);
    }

    public <T extends TurbineUserGroupRole> Set<T> getUserGroupRoleSet() throws DataBackendException {
        return this.userDelegate.getUserGroupRoleSet();
    }

    public <T extends TurbineUserGroupRole> void setUserGroupRoleSet(Set<T> userGroupRoleSet) {
        this.userDelegate.setUserGroupRoleSet(userGroupRoleSet);
    }

    public void addUserGroupRole(TurbineUserGroupRole userGroupRole) throws DataBackendException {
        this.userDelegate.addUserGroupRole(userGroupRole);
    }

    public void removeUserGroupRole(TurbineUserGroupRole userGroupRole) throws DataBackendException {
        this.userDelegate.removeUserGroupRole(userGroupRole);
    }

    @Override
    public int getAccessCounter() {
        try {
            return (Integer)this.getPerm("_access_counter");
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public int getAccessCounterForSession() {
        try {
            return (Integer)this.getTemp("_session_access_counter");
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public void incrementAccessCounter() {
        this.setAccessCounter(this.getAccessCounter() + 1);
    }

    @Override
    public void incrementAccessCounterForSession() {
        this.setAccessCounterForSession(this.getAccessCounterForSession() + 1);
    }

    @Override
    public void setAccessCounter(int cnt) {
        this.setPerm("_access_counter", cnt);
    }

    @Override
    public void setAccessCounterForSession(int cnt) {
        this.setTemp("_session_access_counter", cnt);
    }

    @Override
    public Date getLastAccessDate() {
        if (this.lastAccessDate == null) {
            this.setLastAccessDate();
        }
        return Date.from(this.lastAccessDate.toInstant());
    }

    @Override
    public void setLastAccessDate() {
        this.lastAccessDate = new Date();
    }

    @Override
    public synchronized Map<String, Object> getPermStorage() {
        if (this.permStorage == null) {
            byte[] objectdata = this.getObjectdata();
            if (objectdata != null) {
                this.permStorage = (Map)ObjectUtils.deserialize(objectdata);
            }
            if (this.permStorage == null) {
                this.permStorage = new HashMap<String, Object>();
            }
        }
        return this.permStorage;
    }

    @Override
    public void setPermStorage(Map<String, Object> permStorage) {
        if (permStorage != null) {
            this.permStorage = permStorage;
        }
    }

    @Override
    public Map<String, Object> getTempStorage() {
        if (this.tempStorage == null) {
            this.tempStorage = new HashMap<String, Object>();
        }
        return this.tempStorage;
    }

    @Override
    public void setTempStorage(Map<String, Object> tempStorage) {
        if (tempStorage != null) {
            this.tempStorage = tempStorage;
        }
    }

    @Override
    public Object getPerm(String name) {
        return this.getPermStorage().get(name);
    }

    @Override
    public Object getPerm(String name, Object def) {
        try {
            Object val = this.getPermStorage().get(name);
            return val == null ? def : val;
        }
        catch (Exception e) {
            return def;
        }
    }

    @Override
    public void setPerm(String name, Object value) {
        this.getPermStorage().put(name, value);
    }

    @Override
    public Object getTemp(String name) {
        return this.getTempStorage().get(name);
    }

    @Override
    public Object getTemp(String name, Object def) {
        Object val;
        try {
            val = this.getTempStorage().get(name);
            if (val == null) {
                val = def;
            }
        }
        catch (Exception e) {
            val = def;
        }
        return val;
    }

    @Override
    public void setTemp(String name, Object value) {
        this.getTempStorage().put(name, value);
    }

    @Override
    public Object removeTemp(String name) {
        return this.getTempStorage().remove(name);
    }

    @Override
    public String getConfirmed() {
        return (String)this.getPerm("CONFIRM_VALUE");
    }

    @Override
    public void setConfirmed(String confirm) {
        this.setPerm("CONFIRM_VALUE", confirm);
    }

    @Override
    public Date getCreateDate() {
        return (Date)this.getPerm("CREATE_DATE", new Date());
    }

    @Override
    public void setCreateDate(Date createDate) {
        this.setPerm("CREATE_DATE", createDate);
    }

    @Override
    public Date getLastLogin() {
        return (Date)this.getPerm("LAST_LOGIN");
    }

    @Override
    public void setLastLogin(Date lastLogin) {
        this.setPerm("LAST_LOGIN", lastLogin);
    }

    @Override
    public boolean hasLoggedIn() {
        Boolean loggedIn = (Boolean)this.getTemp("_has_logged_in");
        return loggedIn != null && loggedIn != false;
    }

    @Override
    public void setHasLoggedIn(Boolean value) {
        this.setTemp("_has_logged_in", value);
    }

    @Override
    public boolean isConfirmed() {
        String value = this.getConfirmed();
        return value != null && value.equals("CONFIRMED");
    }

    @Override
    public void updateLastLogin() throws Exception {
        this.setLastLogin(new Date());
    }

    @Override
    public TurbineUser getUserDelegate() {
        return this.userDelegate;
    }

    @Override
    public final void setUserDelegate(TurbineUser userDelegate) {
        this.userDelegate = userDelegate;
    }
}

