/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.map;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.torque.Database;
import org.apache.torque.TorqueException;
import org.apache.torque.map.OptionSupport;
import org.apache.torque.map.TableMap;

public class DatabaseMap
extends OptionSupport
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final char STD_SEPARATOR_CHAR = '_';
    public static final char SCHEMA_SEPARATOR_CHAR = '.';
    public static final String INIT_CLASS_NAME_FORMAT = "org.apache.torque.linkage.{0}DatabaseMapInit";
    private static final String ERROR_MESSAGES_CLASS_NOT_FOUND = "Invalid Torque OM setup for Database \"{0}\".\nDatabase Map initialization class, \"{1}\", could not be found in your classpath.";
    private static final String ERROR_MESSAGES_DEPENDENT_CLASS_NOT_FOUND = "Invalid Torque OM setup for Database \"{0}\".\nA class that the Database Map initialization class, \"{1}\", depends on could not be found.";
    private static final String ERROR_MESSAGES_CLASS_FOR_NAME = "Invalid Torque OM setup for Database \"{0}\".\nSomething unexpected happened doing Class.forName(\"{1}\").  See the nested exception for details.";
    private static final String ERROR_MESSAGES_INIT = "Invalid Torque OM setup for Database \"{0}\".\nAn error occured invoking the init() method in class, \"{1}\"";
    private final String name;
    private final Map<String, TableMap> tables = Collections.synchronizedMap(new LinkedHashMap());
    private TableMap idTable = null;
    private boolean isInitialized = false;

    public DatabaseMap(Database database) {
        if (database == null) {
            throw new NullPointerException("database must not be null");
        }
        this.name = database.getName();
    }

    public String getName() {
        return this.name;
    }

    public boolean containsTable(TableMap table) {
        return this.containsTable(table.getName());
    }

    public boolean containsTable(String name) {
        boolean found;
        if (name.indexOf(46) > 0) {
            name = name.substring(0, name.indexOf(46));
        }
        if (!(found = this.tables.containsKey(name)) && this.idTable != null) {
            return this.idTable.getName().equals(name);
        }
        return found;
    }

    public TableMap getTable(String name) {
        TableMap result = this.tables.get(name);
        if (result != null) {
            return result;
        }
        if (this.idTable != null && this.idTable.getName().equals(name)) {
            return this.idTable;
        }
        return null;
    }

    public TableMap[] getTables() {
        int size = this.tables.size();
        if (this.idTable != null) {
            ++size;
        }
        TableMap[] dbTables = this.tables.values().toArray(new TableMap[size]);
        if (this.idTable != null) {
            dbTables[size - 1] = this.idTable;
        }
        return dbTables;
    }

    public TableMap addTable(String tableName) {
        TableMap tmap = new TableMap(tableName, this);
        this.tables.put(tableName, tmap);
        return tmap;
    }

    public void setIdTable(TableMap idTableMap) {
        this.idTable = idTableMap;
    }

    public synchronized void initialize() throws TorqueException {
        if (this.isInitialized) {
            return;
        }
        String initClassName = MessageFormat.format(INIT_CLASS_NAME_FORMAT, this.javanameMethod(this.name));
        Class<?> initClass = null;
        try {
            initClass = Class.forName(initClassName);
        }
        catch (ClassNotFoundException e) {
            throw new TorqueException(MessageFormat.format(ERROR_MESSAGES_CLASS_NOT_FOUND, this.name, initClassName), e);
        }
        catch (LinkageError e) {
            throw new TorqueException(MessageFormat.format(ERROR_MESSAGES_DEPENDENT_CLASS_NOT_FOUND, this.name, initClassName), e);
        }
        catch (Throwable e) {
            throw new TorqueException(MessageFormat.format(ERROR_MESSAGES_CLASS_FOR_NAME, this.name, initClassName), e);
        }
        try {
            Method initMethod = initClass.getMethod("init", null);
            initMethod.invoke(null, (Object[])null);
        }
        catch (Exception e) {
            throw new TorqueException(MessageFormat.format(ERROR_MESSAGES_INIT, this.name, initClassName), e);
        }
        this.isInitialized = true;
    }

    protected String javanameMethod(String schemaName) {
        String namePart;
        StringBuilder result = new StringBuilder();
        StringTokenizer tok = new StringTokenizer(schemaName, String.valueOf('_'));
        while (tok.hasMoreTokens()) {
            namePart = (String)tok.nextElement();
            result.append(StringUtils.capitalize((String)namePart));
        }
        schemaName = result.toString();
        result = new StringBuilder();
        tok = new StringTokenizer(schemaName, String.valueOf('.'));
        while (tok.hasMoreTokens()) {
            namePart = (String)tok.nextElement();
            result.append(StringUtils.capitalize((String)namePart));
        }
        return result.toString();
    }

    public void copyFrom(DatabaseMap databaseMap) {
        this.isInitialized = databaseMap.isInitialized;
        this.clearOptions();
        databaseMap.getOptions().forEach(this::setOption);
        this.tables.clear();
        this.tables.putAll(databaseMap.tables);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("DatabaseMap[name=").append(this.name).append(", tables=(").append(this.tables.values().stream().map(TableMap::getName).collect(Collectors.joining(","))).append(")]");
        return result.toString();
    }
}

