
/*
  Licensed to the Apache Software Foundation (ASF) under one
  or more contributor license agreements.  See the NOTICE file
  distributed with this work for additional information
  regarding copyright ownership.  The ASF licenses this file
  to you under the Apache License, Version 2.0 (the
  "License"); you may not use this file except in compliance
  with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

/*
  THIS FILE IS AUTOGENERATED, DO NOT EDIT

  Regenerate this file with the 'generate-cripts-config' target. Remember
  to run the format target on the generated file as well.
*/
#pragma once

#include "cripts/ConfigsBase.hpp"

namespace cripts
{

class Proxy
{
private:
  friend class cripts::Context; // Needed to set the state

  class Config
  {
  private:
    class Body_Factory
    {
    public:
      cripts::IntConfig    response_suppression_mode{"proxy.config.body_factory.response_suppression_mode"};
      cripts::StringConfig template_base{"proxy.config.body_factory.template_base"};
    }; // End class Body_Factory

  public:
    Body_Factory body_factory;

  private:
    class Hostdb
    {
    public:
      cripts::StringConfig ip_resolve{"proxy.config.hostdb.ip_resolve"};
    }; // End class Hostdb

  public:
    Hostdb hostdb;

  private:
    class Http
    {
    public:
      cripts::IntConfig   allow_half_open{"proxy.config.http.allow_half_open"};
      cripts::IntConfig   allow_multi_range{"proxy.config.http.allow_multi_range"};
      cripts::IntConfig   anonymize_remove_client_ip{"proxy.config.http.anonymize_remove_client_ip"};
      cripts::IntConfig   anonymize_remove_cookie{"proxy.config.http.anonymize_remove_cookie"};
      cripts::IntConfig   anonymize_remove_from{"proxy.config.http.anonymize_remove_from"};
      cripts::IntConfig   anonymize_remove_referer{"proxy.config.http.anonymize_remove_referer"};
      cripts::IntConfig   anonymize_remove_user_agent{"proxy.config.http.anonymize_remove_user_agent"};
      cripts::IntConfig   attach_server_session_to_client{"proxy.config.http.attach_server_session_to_client"};
      cripts::IntConfig   auth_server_session_private{"proxy.config.http.auth_server_session_private"};
      cripts::IntConfig   background_fill_active_timeout{"proxy.config.http.background_fill_active_timeout"};
      cripts::FloatConfig background_fill_completed_threshold{"proxy.config.http.background_fill_completed_threshold"};

    private:
      class Cache
      {
      public:
        cripts::IntConfig   cache_responses_to_cookies{"proxy.config.http.cache.cache_responses_to_cookies"};
        cripts::IntConfig   cache_urls_that_look_dynamic{"proxy.config.http.cache.cache_urls_that_look_dynamic"};
        cripts::IntConfig   generation{"proxy.config.http.cache.generation"};
        cripts::IntConfig   guaranteed_max_lifetime{"proxy.config.http.cache.guaranteed_max_lifetime"};
        cripts::IntConfig   guaranteed_min_lifetime{"proxy.config.http.cache.guaranteed_min_lifetime"};
        cripts::FloatConfig heuristic_lm_factor{"proxy.config.http.cache.heuristic_lm_factor"};
        cripts::IntConfig   heuristic_max_lifetime{"proxy.config.http.cache.heuristic_max_lifetime"};
        cripts::IntConfig   heuristic_min_lifetime{"proxy.config.http.cache.heuristic_min_lifetime"};
        cripts::IntConfig   http{"proxy.config.http.cache.http"};
        cripts::IntConfig   ignore_accept_charset_mismatch{"proxy.config.http.cache.ignore_accept_charset_mismatch"};
        cripts::IntConfig   ignore_accept_encoding_mismatch{"proxy.config.http.cache.ignore_accept_encoding_mismatch"};
        cripts::IntConfig   ignore_accept_language_mismatch{"proxy.config.http.cache.ignore_accept_language_mismatch"};
        cripts::IntConfig   ignore_accept_mismatch{"proxy.config.http.cache.ignore_accept_mismatch"};
        cripts::IntConfig   ignore_authentication{"proxy.config.http.cache.ignore_authentication"};
        cripts::IntConfig   ignore_client_cc_max_age{"proxy.config.http.cache.ignore_client_cc_max_age"};
        cripts::IntConfig   ignore_client_no_cache{"proxy.config.http.cache.ignore_client_no_cache"};
        cripts::IntConfig   ignore_query{"proxy.config.http.cache.ignore_query"};
        cripts::IntConfig   ignore_server_no_cache{"proxy.config.http.cache.ignore_server_no_cache"};
        cripts::IntConfig   ims_on_client_no_cache{"proxy.config.http.cache.ims_on_client_no_cache"};
        cripts::IntConfig   max_open_read_retries{"proxy.config.http.cache.max_open_read_retries"};
        cripts::IntConfig   max_open_write_retries{"proxy.config.http.cache.max_open_write_retries"};
        cripts::IntConfig   max_open_write_retry_timeout{"proxy.config.http.cache.max_open_write_retry_timeout"};
        cripts::IntConfig   max_stale_age{"proxy.config.http.cache.max_stale_age"};
        cripts::IntConfig   open_read_retry_time{"proxy.config.http.cache.open_read_retry_time"};
        cripts::IntConfig   open_write_fail_action{"proxy.config.http.cache.open_write_fail_action"};

      private:
        class Range
        {
        public:
          cripts::IntConfig lookup{"proxy.config.http.cache.range.lookup"};
          cripts::IntConfig write{"proxy.config.http.cache.range.write"};
        }; // End class Range

      public:
        Range range;

        cripts::IntConfig required_headers{"proxy.config.http.cache.required_headers"};
        cripts::IntConfig when_to_revalidate{"proxy.config.http.cache.when_to_revalidate"};
      }; // End class Cache

    public:
      Cache cache;

    private:
      class Chunking
      {
      public:
        cripts::IntConfig size{"proxy.config.http.chunking.size"};
      }; // End class Chunking

    public:
      Chunking chunking;

      cripts::IntConfig chunking_enabled{"proxy.config.http.chunking_enabled"};

    private:
      class Connect
      {
      private:
        class Down
        {
        public:
          cripts::IntConfig policy{"proxy.config.http.connect.down.policy"};
        }; // End class Down

      public:
        Down down;

      }; // End class Connect

    public:
      Connect connect;

      cripts::IntConfig connect_attempts_max_retries{"proxy.config.http.connect_attempts_max_retries"};
      cripts::IntConfig connect_attempts_max_retries_down_server{"proxy.config.http.connect_attempts_max_retries_down_server"};
      cripts::IntConfig connect_attempts_rr_retries{"proxy.config.http.connect_attempts_rr_retries"};
      cripts::IntConfig connect_attempts_timeout{"proxy.config.http.connect_attempts_timeout"};
      cripts::IntConfig default_buffer_size{"proxy.config.http.default_buffer_size"};
      cripts::IntConfig default_buffer_water_mark{"proxy.config.http.default_buffer_water_mark"};
      cripts::IntConfig doc_in_cache_skip_dns{"proxy.config.http.doc_in_cache_skip_dns"};

    private:
      class Down_Server
      {
      public:
        cripts::IntConfig cache_time{"proxy.config.http.down_server.cache_time"};
      }; // End class Down_Server

    public:
      Down_Server down_server;

      cripts::IntConfig drop_chunked_trailers{"proxy.config.http.drop_chunked_trailers"};

    private:
      class Flow_Control
      {
      public:
        cripts::IntConfig enabled{"proxy.config.http.flow_control.enabled"};
        cripts::IntConfig high_water{"proxy.config.http.flow_control.high_water"};
        cripts::IntConfig low_water{"proxy.config.http.flow_control.low_water"};
      }; // End class Flow_Control

    public:
      Flow_Control flow_control;

    private:
      class Forward
      {
      public:
        cripts::IntConfig proxy_auth_to_parent{"proxy.config.http.forward.proxy_auth_to_parent"};
      }; // End class Forward

    public:
      Forward forward;

      cripts::IntConfig    forward_connect_method{"proxy.config.http.forward_connect_method"};
      cripts::StringConfig global_user_agent_header{"proxy.config.http.global_user_agent_header"};
      cripts::IntConfig    insert_age_in_response{"proxy.config.http.insert_age_in_response"};
      cripts::IntConfig    insert_client_ip{"proxy.config.http.insert_client_ip"};
      cripts::StringConfig insert_forwarded{"proxy.config.http.insert_forwarded"};
      cripts::IntConfig    insert_request_via_str{"proxy.config.http.insert_request_via_str"};
      cripts::IntConfig    insert_response_via_str{"proxy.config.http.insert_response_via_str"};
      cripts::IntConfig    insert_squid_x_forwarded_for{"proxy.config.http.insert_squid_x_forwarded_for"};
      cripts::IntConfig    keep_alive_enabled_in{"proxy.config.http.keep_alive_enabled_in"};
      cripts::IntConfig    keep_alive_enabled_out{"proxy.config.http.keep_alive_enabled_out"};
      cripts::IntConfig    keep_alive_no_activity_timeout_in{"proxy.config.http.keep_alive_no_activity_timeout_in"};
      cripts::IntConfig    keep_alive_no_activity_timeout_out{"proxy.config.http.keep_alive_no_activity_timeout_out"};
      cripts::IntConfig    keep_alive_post_out{"proxy.config.http.keep_alive_post_out"};
      cripts::IntConfig    max_proxy_cycles{"proxy.config.http.max_proxy_cycles"};
      cripts::IntConfig    negative_caching_enabled{"proxy.config.http.negative_caching_enabled"};
      cripts::IntConfig    negative_caching_lifetime{"proxy.config.http.negative_caching_lifetime"};
      cripts::IntConfig    negative_revalidating_enabled{"proxy.config.http.negative_revalidating_enabled"};
      cripts::IntConfig    negative_revalidating_lifetime{"proxy.config.http.negative_revalidating_lifetime"};
      cripts::IntConfig    no_dns_just_forward_to_parent{"proxy.config.http.no_dns_just_forward_to_parent"};
      cripts::IntConfig    normalize_ae{"proxy.config.http.normalize_ae"};
      cripts::IntConfig    number_of_redirections{"proxy.config.http.number_of_redirections"};

    private:
      class Parent_Proxy
      {
      public:
        cripts::IntConfig disable_parent_markdowns{"proxy.config.http.parent_proxy.disable_parent_markdowns"};
        cripts::IntConfig enable_parent_timeout_markdowns{"proxy.config.http.parent_proxy.enable_parent_timeout_markdowns"};
        cripts::IntConfig fail_threshold{"proxy.config.http.parent_proxy.fail_threshold"};
        cripts::IntConfig mark_down_hostdb{"proxy.config.http.parent_proxy.mark_down_hostdb"};
        cripts::IntConfig per_parent_connect_attempts{"proxy.config.http.parent_proxy.per_parent_connect_attempts"};
        cripts::IntConfig retry_time{"proxy.config.http.parent_proxy.retry_time"};
        cripts::IntConfig total_connect_attempts{"proxy.config.http.parent_proxy.total_connect_attempts"};
      }; // End class Parent_Proxy

    public:
      Parent_Proxy parent_proxy;

    private:
      class Post
      {
      private:
        class Check
        {
        private:
          class Content_Length
          {
          public:
            cripts::IntConfig enabled{"proxy.config.http.post.check.content_length.enabled"};
          }; // End class Content_Length

        public:
          Content_Length content_length;

        }; // End class Check

      public:
        Check check;

      }; // End class Post

    public:
      Post post;

      cripts::IntConfig    proxy_protocol_out{"proxy.config.http.proxy_protocol_out"};
      cripts::IntConfig    redirect_use_orig_cache_key{"proxy.config.http.redirect_use_orig_cache_key"};
      cripts::IntConfig    request_buffer_enabled{"proxy.config.http.request_buffer_enabled"};
      cripts::IntConfig    request_header_max_size{"proxy.config.http.request_header_max_size"};
      cripts::IntConfig    response_header_max_size{"proxy.config.http.response_header_max_size"};
      cripts::IntConfig    response_server_enabled{"proxy.config.http.response_server_enabled"};
      cripts::StringConfig response_server_str{"proxy.config.http.response_server_str"};
      cripts::IntConfig    send_http11_requests{"proxy.config.http.send_http11_requests"};

    private:
      class Server_Session_Sharing
      {
      public:
        cripts::StringConfig match{"proxy.config.http.server_session_sharing.match"};
      }; // End class Server_Session_Sharing

    public:
      Server_Session_Sharing server_session_sharing;

    private:
      class Slow
      {
      private:
        class Log
        {
        public:
          cripts::IntConfig threshold{"proxy.config.http.slow.log.threshold"};
        }; // End class Log

      public:
        Log log;

      }; // End class Slow

    public:
      Slow slow;

      cripts::IntConfig transaction_active_timeout_in{"proxy.config.http.transaction_active_timeout_in"};
      cripts::IntConfig transaction_active_timeout_out{"proxy.config.http.transaction_active_timeout_out"};
      cripts::IntConfig transaction_no_activity_timeout_in{"proxy.config.http.transaction_no_activity_timeout_in"};
      cripts::IntConfig transaction_no_activity_timeout_out{"proxy.config.http.transaction_no_activity_timeout_out"};
      cripts::IntConfig uncacheable_requests_bypass_parent{"proxy.config.http.uncacheable_requests_bypass_parent"};
    }; // End class Http

  public:
    Http http;

  private:
    class Net
    {
    public:
      cripts::IntConfig default_inactivity_timeout{"proxy.config.net.default_inactivity_timeout"};
      cripts::IntConfig sock_notsent_lowat{"proxy.config.net.sock_notsent_lowat"};
      cripts::IntConfig sock_option_flag_out{"proxy.config.net.sock_option_flag_out"};
      cripts::IntConfig sock_packet_mark_out{"proxy.config.net.sock_packet_mark_out"};
      cripts::IntConfig sock_packet_tos_out{"proxy.config.net.sock_packet_tos_out"};
      cripts::IntConfig sock_recv_buffer_size_out{"proxy.config.net.sock_recv_buffer_size_out"};
      cripts::IntConfig sock_send_buffer_size_out{"proxy.config.net.sock_send_buffer_size_out"};
    }; // End class Net

  public:
    Net net;

  private:
    class Plugin
    {
    private:
      class Vc
      {
      public:
        cripts::IntConfig default_buffer_index{"proxy.config.plugin.vc.default_buffer_index"};
        cripts::IntConfig default_buffer_water_mark{"proxy.config.plugin.vc.default_buffer_water_mark"};
      }; // End class Vc

    public:
      Vc vc;

    }; // End class Plugin

  public:
    Plugin plugin;

  public:
    cripts::IntConfig srv_enabled{"proxy.config.srv_enabled"};

  private:
    class Ssl
    {
    private:
      class Client
      {
      private:
        class Ca
        {
        private:
          class Cert
          {
          public:
            cripts::StringConfig filename{"proxy.config.ssl.client.CA.cert.filename"};
          }; // End class Cert

        public:
          Cert cert;

        }; // End class Ca

      public:
        Ca CA;

      public:
        cripts::StringConfig alpn_protocols{"proxy.config.ssl.client.alpn_protocols"};

      private:
        class Cert
        {
        public:
          cripts::StringConfig filename{"proxy.config.ssl.client.cert.filename"};
          cripts::StringConfig path{"proxy.config.ssl.client.cert.path"};
        }; // End class Cert

      public:
        Cert cert;

      private:
        class Private_Key
        {
        public:
          cripts::StringConfig filename{"proxy.config.ssl.client.private_key.filename"};
        }; // End class Private_Key

      public:
        Private_Key private_key;

        cripts::StringConfig sni_policy{"proxy.config.ssl.client.sni_policy"};

      private:
        class Verify
        {
        private:
          class Server
          {
          public:
            cripts::StringConfig policy{"proxy.config.ssl.client.verify.server.policy"};
            cripts::StringConfig properties{"proxy.config.ssl.client.verify.server.properties"};
          }; // End class Server

        public:
          Server server;

        }; // End class Verify

      public:
        Verify verify;

      }; // End class Client

    public:
      Client client;

    public:
      cripts::IntConfig hsts_include_subdomains{"proxy.config.ssl.hsts_include_subdomains"};
      cripts::IntConfig hsts_max_age{"proxy.config.ssl.hsts_max_age"};
    }; // End class Ssl

  public:
    Ssl ssl;

  private:
    class Url_Remap
    {
    public:
      cripts::IntConfig pristine_host_hdr{"proxy.config.url_remap.pristine_host_hdr"};
    }; // End class Url_Remap

  public:
    Url_Remap url_remap;

  private:
    class Websocket
    {
    public:
      cripts::IntConfig active_timeout{"proxy.config.websocket.active_timeout"};
      cripts::IntConfig no_activity_timeout{"proxy.config.websocket.no_activity_timeout"};
    }; // End class Websocket

  public:
    Websocket websocket;

  }; // End class Config

public:
  Config config;

}; // End class Proxy

} // namespace cripts
