/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.security.http.openid;

import jakarta.json.JsonObject;
import jakarta.security.enterprise.authentication.mechanism.http.OpenIdAuthenticationMechanismDefinition;
import jakarta.security.enterprise.authentication.mechanism.http.openid.ClaimsDefinition;
import jakarta.security.enterprise.authentication.mechanism.http.openid.DisplayType;
import jakarta.security.enterprise.authentication.mechanism.http.openid.LogoutDefinition;
import jakarta.security.enterprise.authentication.mechanism.http.openid.OpenIdProviderMetadata;
import jakarta.security.enterprise.authentication.mechanism.http.openid.PromptType;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import java.lang.annotation.Annotation;
import org.apache.commons.lang3.StringUtils;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.tomee.security.http.openid.CompositeOpenIdProviderMetadata;

public class OpenIdAuthenticationMechanismDefinitionDelegate
implements OpenIdAuthenticationMechanismDefinition {
    private final OpenIdAuthenticationMechanismDefinition delegate;

    public OpenIdAuthenticationMechanismDefinitionDelegate(OpenIdAuthenticationMechanismDefinition delegate) {
        this.delegate = delegate;
    }

    public String providerURI() {
        return this.delegate.providerURI();
    }

    public OpenIdProviderMetadata providerMetadata() {
        return this.delegate.providerMetadata();
    }

    public String clientId() {
        return this.delegate.clientId();
    }

    public String clientSecret() {
        return this.delegate.clientSecret();
    }

    public ClaimsDefinition claimsDefinition() {
        return this.delegate.claimsDefinition();
    }

    public LogoutDefinition logout() {
        return this.delegate.logout();
    }

    public String redirectURI() {
        return this.delegate.redirectURI();
    }

    public boolean redirectToOriginalResource() {
        return this.delegate.redirectToOriginalResource();
    }

    public String redirectToOriginalResourceExpression() {
        return this.delegate.redirectToOriginalResourceExpression();
    }

    public String[] scope() {
        return this.delegate.scope();
    }

    public String scopeExpression() {
        return this.delegate.scopeExpression();
    }

    public String responseType() {
        return this.delegate.responseType();
    }

    public String responseMode() {
        return this.delegate.responseMode();
    }

    public PromptType[] prompt() {
        return this.delegate.prompt();
    }

    public String promptExpression() {
        return this.delegate.promptExpression();
    }

    public DisplayType display() {
        return this.delegate.display();
    }

    public String displayExpression() {
        return this.delegate.displayExpression();
    }

    public boolean useNonce() {
        return this.delegate.useNonce();
    }

    public String useNonceExpression() {
        return this.delegate.useNonceExpression();
    }

    public boolean useSession() {
        return this.delegate.useSession();
    }

    public String useSessionExpression() {
        return this.delegate.useSessionExpression();
    }

    public String[] extraParameters() {
        return this.delegate.extraParameters();
    }

    public String extraParametersExpression() {
        return this.delegate.extraParametersExpression();
    }

    public int jwksConnectTimeout() {
        return this.delegate.jwksConnectTimeout();
    }

    public String jwksConnectTimeoutExpression() {
        return this.delegate.jwksConnectTimeoutExpression();
    }

    public int jwksReadTimeout() {
        return this.delegate.jwksReadTimeout();
    }

    public String jwksReadTimeoutExpression() {
        return this.delegate.jwksReadTimeoutExpression();
    }

    public boolean tokenAutoRefresh() {
        return this.delegate.tokenAutoRefresh();
    }

    public String tokenAutoRefreshExpression() {
        return this.delegate.tokenAutoRefreshExpression();
    }

    public int tokenMinValidity() {
        return this.delegate.tokenMinValidity();
    }

    public String tokenMinValidityExpression() {
        return this.delegate.tokenMinValidityExpression();
    }

    public Class<? extends Annotation> annotationType() {
        return this.delegate.annotationType();
    }

    public static class AutoResolvingProviderMetadata
    extends OpenIdAuthenticationMechanismDefinitionDelegate {
        private static final Logger LOGGER = Logger.getInstance((LogCategory)LogCategory.TOMEE_SECURITY, AutoResolvingProviderMetadata.class);
        private OpenIdProviderMetadata cached = null;

        public AutoResolvingProviderMetadata(OpenIdAuthenticationMechanismDefinition delegate) {
            super(delegate);
        }

        @Override
        public OpenIdProviderMetadata providerMetadata() {
            if (this.cached != null) {
                return this.cached;
            }
            if (this.providerURI().isEmpty()) {
                this.cached = super.providerMetadata();
                return this.cached;
            }
            try (Client client = ClientBuilder.newClient();){
                Object providerUri = StringUtils.removeEnd((String)this.providerURI(), (String)"/");
                if (!((String)providerUri).endsWith("/.well-known/openid-configuration")) {
                    providerUri = (String)providerUri + "/.well-known/openid-configuration";
                }
                LOGGER.debug("Fetching provider metadata from " + (String)providerUri);
                JsonObject response = (JsonObject)client.target((String)providerUri).request(new String[]{"application/json"}).get(JsonObject.class);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Fetched provider metadata from " + (String)providerUri + ": " + response.toString());
                }
                this.cached = new CompositeOpenIdProviderMetadata(response, super.providerMetadata());
            }
            return this.cached;
        }
    }
}

