/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.index.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.collection.LazySet;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.opensaml.saml.metadata.resolver.index.MetadataIndex;
import org.opensaml.saml.metadata.resolver.index.MetadataIndexKey;
import org.opensaml.saml.metadata.resolver.index.impl.MetadataIndexStore;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.slf4j.Logger;

public class MetadataIndexManager<T> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(MetadataIndexManager.class);
    @Nonnull
    private final Map<MetadataIndex, MetadataIndexStore<T>> indexes;
    @Nonnull
    private final Function<EntityDescriptor, T> entityDescriptorFunction;

    public MetadataIndexManager(@Nullable Set<MetadataIndex> initIndexes, @Nonnull Function<EntityDescriptor, T> extractionFunction) {
        this.entityDescriptorFunction = (Function)Constraint.isNotNull(extractionFunction, (String)"EntityDescriptor extraction function was null");
        this.indexes = new ConcurrentHashMap<MetadataIndex, MetadataIndexStore<T>>();
        if (initIndexes != null) {
            for (MetadataIndex index : initIndexes) {
                this.log.trace("Initializing manager for index: {}", (Object)index);
                this.indexes.put(index, new MetadataIndexStore());
            }
        }
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public Set<MetadataIndex> getIndexes() {
        return CollectionSupport.copyToSet(this.indexes.keySet());
    }

    @Nullable
    protected MetadataIndexStore<T> getStore(@Nonnull MetadataIndex index) {
        Constraint.isNotNull((Object)index, (String)"MetadataIndex was null");
        return this.indexes.get(index);
    }

    @Nonnull
    public Optional<Set<T>> lookupIndexedItems(@Nullable CriteriaSet criteria) {
        HashSet items = new HashSet();
        for (MetadataIndex index : this.indexes.keySet()) {
            Set keys = index.generateKeys(criteria);
            if (keys == null || keys.isEmpty()) continue;
            LazySet indexResult = new LazySet();
            MetadataIndexStore<T> indexStore = this.getStore(index);
            if (indexStore != null) {
                for (MetadataIndexKey key : keys) {
                    indexResult.addAll(indexStore.lookup(key));
                }
            }
            this.log.trace("MetadataIndex '{}' produced results: {}", (Object)index, (Object)indexResult);
            if (items.isEmpty()) {
                items.addAll(indexResult);
            } else {
                items.retainAll((Collection<?>)indexResult);
            }
            if (!items.isEmpty()) continue;
            this.log.trace("Accumulator intersected with MetadataIndex '{}' result produced empty result, terminating early and returning empty result set", (Object)index);
            return Optional.of(CollectionSupport.emptySet());
        }
        if (items.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(items);
    }

    public void indexEntityDescriptor(@Nonnull EntityDescriptor descriptor) {
        T item = this.entityDescriptorFunction.apply(descriptor);
        if (item != null) {
            for (MetadataIndex index : this.indexes.keySet()) {
                MetadataIndexStore<T> store;
                Set keys = index.generateKeys(descriptor);
                if (keys == null || keys.isEmpty() || (store = this.getStore(index)) == null) continue;
                for (MetadataIndexKey key : keys) {
                    this.log.trace("Indexing metadata: index '{}', key '{}', data item '{}'", new Object[]{index, key, item});
                    store.add(key, item);
                }
            }
        } else {
            this.log.trace("Unable to extract indexed data item from EntityDescriptor");
        }
    }

    public void deindexEntityDescriptor(@Nonnull EntityDescriptor descriptor) {
        T item = this.entityDescriptorFunction.apply(descriptor);
        if (item != null) {
            for (MetadataIndex index : this.indexes.keySet()) {
                MetadataIndexStore<T> store;
                Set keys = index.generateKeys(descriptor);
                if (keys == null || keys.isEmpty() || (store = this.getStore(index)) == null) continue;
                for (MetadataIndexKey key : keys) {
                    this.log.trace("De-indexing metadata: index '{}', key '{}', data item '{}'", new Object[]{index, key, item});
                    store.remove(key, item);
                }
            }
        } else {
            this.log.trace("Unable to extract indexed data item from EntityDescriptor");
        }
    }

    public static class EntityIDExtractionFunction
    implements Function<EntityDescriptor, String> {
        @Override
        public String apply(EntityDescriptor input) {
            if (input == null) {
                return null;
            }
            return StringSupport.trimOrNull((String)input.getEntityID());
        }
    }

    public static class IdentityExtractionFunction
    implements Function<EntityDescriptor, EntityDescriptor> {
        @Override
        public EntityDescriptor apply(EntityDescriptor input) {
            return input;
        }
    }
}

