/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina;

import jakarta.ejb.spi.HandleDelegate;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.TransactionSynchronizationRegistry;
import jakarta.transaction.UserTransaction;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.LinkRef;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import org.apache.catalina.core.NamingContextListener;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.deploy.NamingResourcesImpl;
import org.apache.naming.ContextAccessController;
import org.apache.naming.ContextBindings;
import org.apache.openejb.Injection;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.assembler.classic.EjbLocalReferenceInfo;
import org.apache.openejb.assembler.classic.EjbReferenceInfo;
import org.apache.openejb.assembler.classic.EnvEntryInfo;
import org.apache.openejb.assembler.classic.InjectableInfo;
import org.apache.openejb.assembler.classic.PersistenceContextReferenceInfo;
import org.apache.openejb.assembler.classic.PersistenceUnitReferenceInfo;
import org.apache.openejb.assembler.classic.PortRefInfo;
import org.apache.openejb.assembler.classic.ResourceEnvReferenceInfo;
import org.apache.openejb.assembler.classic.ResourceInfo;
import org.apache.openejb.assembler.classic.ResourceReferenceInfo;
import org.apache.openejb.assembler.classic.ServiceReferenceInfo;
import org.apache.openejb.assembler.classic.WebAppBuilder;
import org.apache.openejb.assembler.classic.WebAppInfo;
import org.apache.openejb.assembler.classic.WsBuilder;
import org.apache.openejb.core.WebContext;
import org.apache.openejb.core.ivm.naming.SystemComponentReference;
import org.apache.openejb.core.webservices.PortRefData;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.persistence.JtaEntityManager;
import org.apache.openejb.persistence.JtaEntityManagerRegistry;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.URLs;
import org.apache.tomcat.util.descriptor.web.ContextEjb;
import org.apache.tomcat.util.descriptor.web.ContextEnvironment;
import org.apache.tomcat.util.descriptor.web.ContextResource;
import org.apache.tomcat.util.descriptor.web.ContextResourceEnvRef;
import org.apache.tomcat.util.descriptor.web.ContextService;
import org.apache.tomcat.util.descriptor.web.ContextTransaction;
import org.apache.tomee.catalina.Contexts;
import org.apache.tomee.catalina.TomcatWebAppBuilder;
import org.apache.tomee.common.EjbFactory;
import org.apache.tomee.common.EnumFactory;
import org.apache.tomee.common.LookupFactory;
import org.apache.tomee.common.NamingUtil;
import org.apache.tomee.common.PersistenceContextFactory;
import org.apache.tomee.common.PersistenceUnitFactory;
import org.apache.tomee.common.ResourceFactory;
import org.apache.tomee.common.SystemComponentFactory;
import org.apache.tomee.common.UserTransactionFactory;
import org.apache.tomee.common.WsFactory;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.InjectableBeanManager;

public class TomcatJndiBuilder {
    private final StandardContext standardContext;
    private final WebAppInfo webAppInfo;
    private final Collection<Injection> injections;
    private final boolean replaceEntry;
    private boolean useCrossClassLoaderRef = true;
    private final NamingContextListener namingContextListener;

    public TomcatJndiBuilder(StandardContext standardContext, WebAppInfo webAppInfo, Collection<Injection> injections) {
        this.injections = injections;
        this.standardContext = standardContext;
        this.namingContextListener = standardContext.getNamingContextListener();
        this.webAppInfo = webAppInfo;
        String parameter = standardContext.findParameter("openejb.start.late");
        this.replaceEntry = Boolean.parseBoolean(parameter);
    }

    public boolean isUseCrossClassLoaderRef() {
        return this.useCrossClassLoaderRef;
    }

    public void setUseCrossClassLoaderRef(boolean useCrossClassLoaderRef) {
        this.useCrossClassLoaderRef = useCrossClassLoaderRef;
    }

    public void mergeJndi() throws OpenEJBException {
        NamingResourcesImpl naming = this.standardContext.getNamingResources();
        URI moduleUri = URLs.uri((String)this.webAppInfo.moduleId);
        for (EnvEntryInfo ref : this.webAppInfo.jndiEnc.envEntries) {
            this.mergeRef(naming, ref);
        }
        for (EnvEntryInfo ref : this.webAppInfo.jndiEnc.ejbReferences) {
            this.mergeRef(naming, (EjbReferenceInfo)ref);
        }
        for (EnvEntryInfo ref : this.webAppInfo.jndiEnc.ejbLocalReferences) {
            this.mergeRef(naming, (EjbLocalReferenceInfo)ref);
        }
        for (EnvEntryInfo ref : this.webAppInfo.jndiEnc.persistenceContextRefs) {
            this.mergeRef(naming, (PersistenceContextReferenceInfo)ref, moduleUri);
        }
        for (EnvEntryInfo ref : this.webAppInfo.jndiEnc.persistenceUnitRefs) {
            this.mergeRef(naming, (PersistenceUnitReferenceInfo)ref, moduleUri);
        }
        for (EnvEntryInfo ref : this.webAppInfo.jndiEnc.resourceRefs) {
            this.mergeRef(naming, (ResourceReferenceInfo)ref);
        }
        for (EnvEntryInfo ref : this.webAppInfo.jndiEnc.resourceEnvRefs) {
            this.mergeRef(naming, (ResourceEnvReferenceInfo)ref);
        }
        for (EnvEntryInfo ref : this.webAppInfo.jndiEnc.serviceRefs) {
            this.mergeRef(naming, (ServiceReferenceInfo)ref);
        }
        ContextTransaction contextTransaction = new ContextTransaction();
        contextTransaction.setProperty("factory", (Object)UserTransactionFactory.class.getName());
        naming.setTransaction(contextTransaction);
    }

    public static void mergeJava(StandardContext standardContext) {
        TomcatWebAppBuilder.ContextInfo contextInfo;
        WebContext webContext;
        String name;
        ContainerSystem cs;
        block31: {
            cs = (ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
            name = standardContext.getNamingContextListener().getName();
            Object namingToken = standardContext.getNamingToken();
            ContextAccessController.setWritable((Object)name, (Object)namingToken);
            Context root = null;
            try {
                root = ContextBindings.getClassLoader();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            String hostname = Contexts.getHostname(standardContext);
            Object path = standardContext.findParameter("openejb.webapp.moduleId");
            if (path == null) {
                path = hostname;
                path = standardContext.getPath().startsWith("/") ? (String)path + standardContext.getPath() : (String)path + "/" + standardContext.getPath();
            }
            if ((webContext = cs.getWebContextByHost((String)path, hostname)) == null && (webContext = cs.getWebContextByHost(standardContext.getPath().replaceFirst("/", ""), hostname)) == null) {
                webContext = cs.getWebContextByHost(standardContext.getPath(), hostname);
            }
            TomcatWebAppBuilder builder = (TomcatWebAppBuilder)SystemInstance.get().getComponent(WebAppBuilder.class);
            contextInfo = null;
            if (builder != null) {
                contextInfo = builder.getContextInfo(standardContext);
                if (webContext == null && contextInfo != null && contextInfo.appInfo != null) {
                    for (WebAppInfo webAppInfo : contextInfo.appInfo.webApps) {
                        if (webAppInfo.path == null || !webAppInfo.path.replace(File.separatorChar, '/').equals(standardContext.getDocBase()) || (webContext = cs.getWebContextByHost(webAppInfo.moduleId, hostname)) == null) continue;
                        break;
                    }
                }
            }
            Collection<String> ignoreNames = null;
            if (contextInfo != null) {
                ignoreNames = contextInfo.resourceNames;
            }
            if (webContext != null && webContext.getBindings() != null && root != null) {
                for (Map.Entry entry : webContext.getBindings().entrySet()) {
                    try {
                        String string = (String)entry.getKey();
                        if (string.startsWith("global/")) continue;
                        Object value = TomcatJndiBuilder.normalize(entry.getValue());
                        if (ignoreNames.contains(TomcatJndiBuilder.removeCompEnv(string))) {
                            try {
                                root.lookup(string);
                                continue;
                            }
                            catch (NameNotFoundException nameNotFoundException) {
                                // empty catch block
                            }
                        }
                        org.apache.openejb.util.Contexts.createSubcontexts((Context)root, (String)string);
                        root.rebind(string, value);
                    }
                    catch (NamingException namingException) {
                        namingException.printStackTrace();
                    }
                }
            }
            if (root != null) {
                try {
                    root.bind("global", ((ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class)).getJNDIContext().lookup("global"));
                }
                catch (NamingException e) {
                    if (webContext == null || webContext.getBindings() == null) break block31;
                    for (Map.Entry entry : webContext.getBindings().entrySet()) {
                        try {
                            String key = (String)entry.getKey();
                            if (!key.startsWith("global/")) continue;
                            Object value = TomcatJndiBuilder.normalize(entry.getValue());
                            org.apache.openejb.util.Contexts.createSubcontexts((Context)root, (String)key);
                            root.rebind(key, value);
                        }
                        catch (NamingException ignored) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        try {
            WebBeansContext webBeansContext;
            Context comp = (Context)ContextBindings.getClassLoader().lookup("comp");
            TransactionManager transactionManager = (TransactionManager)SystemInstance.get().getComponent(TransactionManager.class);
            comp.rebind("TransactionManager", (Object)transactionManager);
            TransactionSynchronizationRegistry transactionSynchronizationRegistry = (TransactionSynchronizationRegistry)SystemInstance.get().getComponent(TransactionSynchronizationRegistry.class);
            comp.rebind("TransactionSynchronizationRegistry", (Object)transactionSynchronizationRegistry);
            comp.rebind("HandleDelegate", (Object)new SystemComponentReference(HandleDelegate.class));
            if (webContext != null && webContext.getWebbeansContext() != null) {
                comp.rebind("BeanManager", (Object)new InjectableBeanManager(webContext.getWebbeansContext().getBeanManagerImpl()));
            } else if (contextInfo != null && (webBeansContext = cs.getAppContext((Object)contextInfo.appInfo.appId).getWebBeansContext()) != null) {
                comp.rebind("BeanManager", (Object)new InjectableBeanManager(webBeansContext.getBeanManagerImpl()));
            }
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
        }
        try {
            Context app = (Context)ContextBindings.getClassLoader().lookup("app");
            Context context = (Context)ContextBindings.getClassLoader().lookup("comp/env");
            ArrayList<Binding> arrayList = Collections.list(context.listBindings("app"));
            for (Binding binding : arrayList) {
                try {
                    app.bind(binding.getName(), binding.getObject());
                }
                catch (NamingException namingException) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ContextAccessController.setReadOnly((Object)name);
    }

    private static String removeCompEnv(String key) {
        if (key.startsWith("comp/env/")) {
            return key.substring("comp/env/".length());
        }
        return key;
    }

    private static Object normalize(Object value) {
        try {
            if (!(value instanceof LinkRef)) {
                return value;
            }
            LinkRef ref = (LinkRef)value;
            RefAddr refAddr = ref.getAll().nextElement();
            String address = refAddr.getContent().toString();
            if (address.startsWith("openejb:")) {
                return value;
            }
            if (!address.startsWith("java:")) {
                return new LinkRef("java:" + address);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public void mergeRef(NamingResourcesImpl naming, EnvEntryInfo ref) {
        if ("java.lang.Class".equals(ref.type)) {
            ContextResourceEnvRef resourceEnv = new ContextResourceEnvRef();
            resourceEnv.setName(ref.referenceName.replaceAll("^comp/env/", ""));
            resourceEnv.setProperty("factory", (Object)ResourceFactory.class.getName());
            resourceEnv.setType(ref.type);
            resourceEnv.setProperty("resourceid", (Object)ref.value);
            resourceEnv.setOverride(false);
            naming.addResourceEnvRef(resourceEnv);
            return;
        }
        try {
            ClassLoader loader = this.standardContext.getLoader().getClassLoader();
            Class<?> type = loader.loadClass(ref.type);
            if (Enum.class.isAssignableFrom(type)) {
                ContextResourceEnvRef enumRef = new ContextResourceEnvRef();
                enumRef.setName(ref.referenceName.replaceAll("^comp/env/", ""));
                enumRef.setProperty("factory", (Object)EnumFactory.class.getName());
                enumRef.setProperty("enumValue", (Object)ref.value);
                enumRef.setType(ref.type);
                enumRef.setOverride(false);
                naming.addResourceEnvRef(enumRef);
                return;
            }
        }
        catch (Throwable loader) {
            // empty catch block
        }
        if (this.isLookupRef(naming, (InjectableInfo)ref)) {
            return;
        }
        ContextEnvironment environment = naming.findEnvironment(ref.referenceName.replaceAll("^comp/env/", ""));
        boolean addEntry = false;
        if (environment == null) {
            environment = new ContextEnvironment();
            environment.setName(ref.referenceName.replaceAll("^comp/env/", ""));
            addEntry = true;
        }
        environment.setType(ref.type);
        environment.setValue(ref.value);
        environment.setOverride(false);
        if (addEntry) {
            naming.addEnvironment(environment);
        }
        if (this.replaceEntry) {
            ContextAccessController.setWritable((Object)this.namingContextListener.getName(), (Object)this.standardContext.getNamingToken());
            if (!addEntry) {
                this.namingContextListener.removeEnvironment(environment.getName());
            }
            this.namingContextListener.addEnvironment(environment);
            ContextAccessController.setReadOnly((Object)this.namingContextListener.getName());
        }
    }

    private boolean isLookupRef(NamingResourcesImpl naming, InjectableInfo ref) {
        if (ref.location == null) {
            return false;
        }
        if (ref.location.jndiName == null) {
            return false;
        }
        if (!ref.location.jndiName.startsWith("java:")) {
            return false;
        }
        ContextResourceEnvRef lookup = new ContextResourceEnvRef();
        lookup.setName(ref.referenceName.replaceAll("^comp/env/", ""));
        lookup.setProperty("factory", (Object)LookupFactory.class.getName());
        lookup.setProperty("jndiname", (Object)ref.location.jndiName);
        lookup.setType(Object.class.getName());
        lookup.setOverride(false);
        naming.addResourceEnvRef(lookup);
        return true;
    }

    public void mergeRef(NamingResourcesImpl naming, EjbReferenceInfo ref) {
        if (this.isLookupRef(naming, (InjectableInfo)ref)) {
            return;
        }
        ContextEjb ejb = naming.findEjb(ref.referenceName.replaceAll("^comp/env/", ""));
        boolean addEntry = false;
        if (ejb == null) {
            ejb = new ContextEjb();
            ejb.setName(ref.referenceName.replaceAll("^comp/env/", ""));
            addEntry = true;
        }
        ejb.setProperty("factory", (Object)EjbFactory.class.getName());
        ejb.setProperty("name", (Object)ref.referenceName.replaceAll("^comp/env/", ""));
        ejb.setHome(ref.homeClassName);
        ejb.setRemote(ref.interfaceClassName);
        ejb.setLink(null);
        ejb.setType(ref.interfaceClassName);
        if (this.useCrossClassLoaderRef) {
            ejb.setProperty("external", (Object)Boolean.toString(ref.externalReference));
        }
        if (ref.ejbDeploymentId != null) {
            ejb.setProperty("deploymentid", (Object)ref.ejbDeploymentId);
        }
        if (ref.location != null) {
            ejb.setProperty("jndiname", (Object)ref.location.jndiName);
            ejb.setProperty("jndiproviderid", (Object)ref.location.jndiProviderId);
        }
        if (addEntry) {
            naming.addEjb(ejb);
        }
        if (this.replaceEntry) {
            ContextAccessController.setWritable((Object)this.namingContextListener.getName(), (Object)this.standardContext.getNamingToken());
            if (!addEntry) {
                this.namingContextListener.removeEjb(ejb.getName());
            }
            this.namingContextListener.addEjb(ejb);
            ContextAccessController.setReadOnly((Object)this.namingContextListener.getName());
        }
    }

    public void mergeRef(NamingResourcesImpl naming, EjbLocalReferenceInfo ref) {
        if (this.isLookupRef(naming, (InjectableInfo)ref)) {
            return;
        }
        ContextEjb ejb = naming.findEjb(ref.referenceName.replaceAll("^comp/env/", ""));
        boolean addEntry = false;
        if (ejb == null) {
            ejb = new ContextEjb();
            ejb.setName(ref.referenceName.replaceAll("^comp/env/", ""));
            addEntry = true;
        }
        ejb.setProperty("factory", (Object)EjbFactory.class.getName());
        ejb.setProperty("name", (Object)ref.referenceName.replaceAll("^comp/env/", ""));
        ejb.setHome(ref.homeClassName);
        ejb.setRemote(null);
        ejb.setProperty(ref.localbean ? "localbean" : "local", (Object)ref.interfaceClassName);
        ejb.setLink(null);
        ejb.setType(ref.interfaceClassName);
        if (ref.ejbDeploymentId != null) {
            ejb.setProperty("deploymentid", (Object)ref.ejbDeploymentId);
        }
        if (ref.location != null) {
            ejb.setProperty("jndiname", (Object)ref.location.jndiName);
            ejb.setProperty("jndiproviderid", (Object)ref.location.jndiProviderId);
        }
        if (addEntry) {
            naming.addEjb(ejb);
        }
        if (this.replaceEntry) {
            ContextAccessController.setWritable((Object)this.namingContextListener.getName(), (Object)this.standardContext.getNamingToken());
            if (!addEntry) {
                this.namingContextListener.removeEjb(ejb.getName());
            }
            this.namingContextListener.addEjb(ejb);
            ContextAccessController.setReadOnly((Object)this.namingContextListener.getName());
        }
    }

    public void mergeRef(NamingResourcesImpl naming, PersistenceContextReferenceInfo ref, URI moduleUri) {
        if (this.isLookupRef(naming, (InjectableInfo)ref)) {
            return;
        }
        ContextResource resource = naming.findResource(ref.referenceName.replaceAll("^comp/env/", ""));
        boolean addEntry = false;
        if (resource == null) {
            resource = new ContextResource();
            resource.setName(ref.referenceName.replaceAll("^comp/env/", ""));
            addEntry = true;
        }
        resource.setProperty("factory", (Object)PersistenceContextFactory.class.getName());
        resource.setProperty("name", (Object)ref.referenceName.replaceAll("^comp/env/", ""));
        resource.setType(EntityManager.class.getName());
        if (ref.persistenceUnitName != null) {
            resource.setProperty("unit", (Object)ref.persistenceUnitName);
        }
        resource.setProperty("extended", (Object)Boolean.toString(ref.extended));
        if (ref.location != null) {
            resource.setProperty("jndiname", (Object)ref.location.jndiName);
            resource.setProperty("jndiproviderid", (Object)ref.location.jndiProviderId);
        } else {
            EntityManagerFactory factory;
            Context context = ((ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class)).getJNDIContext();
            try {
                factory = (EntityManagerFactory)context.lookup("openejb/PersistenceUnit/" + ref.unitId);
            }
            catch (NamingException e) {
                throw new IllegalStateException("PersistenceUnit '" + ref.unitId + "' not found for EXTENDED ref '" + ref.referenceName.replaceAll("^comp/env/", "") + "'");
            }
            JtaEntityManagerRegistry jtaEntityManagerRegistry = (JtaEntityManagerRegistry)SystemInstance.get().getComponent(JtaEntityManagerRegistry.class);
            this.setResource(resource, new JtaEntityManager(ref.persistenceUnitName, jtaEntityManagerRegistry, factory, (Map)ref.properties, ref.extended, ref.synchronizationType));
        }
        if (addEntry) {
            naming.addResource(resource);
        }
        if (this.replaceEntry) {
            ContextAccessController.setWritable((Object)this.namingContextListener.getName(), (Object)this.standardContext.getNamingToken());
            if (!addEntry) {
                this.namingContextListener.removeResource(resource.getName());
            }
            this.namingContextListener.addResource(resource);
            ContextAccessController.setReadOnly((Object)this.namingContextListener.getName());
        }
    }

    public void mergeRef(NamingResourcesImpl naming, PersistenceUnitReferenceInfo ref, URI moduleUri) {
        if (this.isLookupRef(naming, (InjectableInfo)ref)) {
            return;
        }
        ContextResource resource = naming.findResource(ref.referenceName.replaceAll("^comp/env/", ""));
        boolean addEntry = false;
        if (resource == null) {
            resource = new ContextResource();
            resource.setName(ref.referenceName.replaceAll("^comp/env/", ""));
            addEntry = true;
        }
        resource.setProperty("factory", (Object)PersistenceUnitFactory.class.getName());
        resource.setProperty("name", (Object)ref.referenceName.replaceAll("^comp/env/", ""));
        resource.setType(EntityManagerFactory.class.getName());
        if (ref.persistenceUnitName != null) {
            resource.setProperty("unit", (Object)ref.persistenceUnitName);
        }
        if (ref.location != null) {
            resource.setProperty("jndiname", (Object)ref.location.jndiName);
            resource.setProperty("jndiproviderid", (Object)ref.location.jndiProviderId);
        } else {
            EntityManagerFactory factory;
            Context context = ((ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class)).getJNDIContext();
            try {
                factory = (EntityManagerFactory)context.lookup("openejb/PersistenceUnit/" + ref.unitId);
            }
            catch (NamingException e) {
                throw new IllegalStateException("PersistenceUnit '" + ref.unitId + "' not found for EXTENDED ref '" + ref.referenceName.replaceAll("^comp/env/", "") + "'");
            }
            this.setResource(resource, factory);
        }
        if (addEntry) {
            naming.addResource(resource);
        }
        if (this.replaceEntry) {
            ContextAccessController.setWritable((Object)this.namingContextListener.getName(), (Object)this.standardContext.getNamingToken());
            if (!addEntry) {
                this.namingContextListener.removeResource(resource.getName());
            }
            this.namingContextListener.addResource(resource);
            ContextAccessController.setReadOnly((Object)this.namingContextListener.getName());
        }
    }

    public void mergeRef(NamingResourcesImpl naming, ResourceReferenceInfo ref) {
        if (this.isLookupRef(naming, (InjectableInfo)ref)) {
            return;
        }
        String name = ref.referenceName.replaceAll("^comp/env/", "");
        if (this.isOpenEjb(naming, name)) {
            return;
        }
        ContextResource resource = naming.findResource(name);
        boolean addEntry = false;
        if (resource == null) {
            resource = new ContextResource();
            resource.setName(name);
            addEntry = true;
        }
        resource.setProperty("factory", (Object)ResourceFactory.class.getName());
        resource.setProperty("name", (Object)name);
        resource.setType(ref.referenceType);
        resource.setAuth(ref.referenceAuth);
        if (ref.resourceID != null) {
            resource.setProperty("resourceid", (Object)ref.resourceID);
        }
        if (ref.location != null) {
            resource.setProperty("jndiname", (Object)ref.location.jndiName);
            resource.setProperty("jndiproviderid", (Object)ref.location.jndiProviderId);
        }
        if (addEntry) {
            naming.addResource(resource);
        }
        if (this.replaceEntry) {
            ContextAccessController.setWritable((Object)this.namingContextListener.getName(), (Object)this.standardContext.getNamingToken());
            if (!addEntry) {
                this.namingContextListener.removeResource(resource.getName());
            }
            this.namingContextListener.addResource(resource);
            ContextAccessController.setReadOnly((Object)this.namingContextListener.getName());
        }
    }

    public void mergeRef(NamingResourcesImpl naming, ResourceEnvReferenceInfo ref) {
        if (this.isLookupRef(naming, (InjectableInfo)ref)) {
            return;
        }
        ContextResourceEnvRef resourceEnv = naming.findResourceEnvRef(ref.referenceName.replaceAll("^comp/env/", ""));
        boolean addEntry = false;
        if (resourceEnv == null) {
            resourceEnv = new ContextResourceEnvRef();
            resourceEnv.setName(ref.referenceName.replaceAll("^comp/env/", ""));
            addEntry = true;
        }
        resourceEnv.setType(ref.resourceEnvRefType);
        if (UserTransaction.class.getName().equals(ref.resourceEnvRefType)) {
            resourceEnv.setProperty("factory", (Object)UserTransactionFactory.class.getName());
        } else if (TransactionManager.class.getName().equals(ref.resourceEnvRefType)) {
            resourceEnv.setProperty("factory", (Object)SystemComponentFactory.class.getName());
            resourceEnv.setProperty("componenttype", (Object)TransactionManager.class.getName());
        } else if (TransactionSynchronizationRegistry.class.getName().equals(ref.resourceEnvRefType)) {
            resourceEnv.setProperty("factory", (Object)SystemComponentFactory.class.getName());
            resourceEnv.setProperty("componenttype", (Object)TransactionSynchronizationRegistry.class.getName());
        } else if (HandleDelegate.class.getName().equals(ref.resourceEnvRefType)) {
            resourceEnv.setProperty("factory", (Object)SystemComponentFactory.class.getName());
            resourceEnv.setProperty("componenttype", (Object)HandleDelegate.class.getName());
        } else {
            resourceEnv.setProperty("factory", (Object)ResourceFactory.class.getName());
            resourceEnv.setProperty("name", (Object)ref.referenceName.replaceAll("^comp/env/", ""));
            if (ref.resourceID != null) {
                resourceEnv.setProperty("resourceid", (Object)ref.resourceID);
            }
            if (ref.location != null) {
                resourceEnv.setProperty("jndiname", (Object)ref.location.jndiName);
                resourceEnv.setProperty("jndiproviderid", (Object)ref.location.jndiProviderId);
            }
        }
        if (addEntry) {
            naming.addResourceEnvRef(resourceEnv);
        }
        if (this.replaceEntry) {
            ContextAccessController.setWritable((Object)this.namingContextListener.getName(), (Object)this.standardContext.getNamingToken());
            if (!addEntry) {
                this.namingContextListener.removeResourceEnvRef(resourceEnv.getName());
            }
            this.namingContextListener.addResourceEnvRef(resourceEnv);
            ContextAccessController.setReadOnly((Object)this.namingContextListener.getName());
        }
    }

    public void mergeRef(NamingResourcesImpl naming, ServiceReferenceInfo ref) {
        String serviceName;
        if (this.isLookupRef(naming, (InjectableInfo)ref)) {
            return;
        }
        ContextResource resource = naming.findResource(ref.referenceName.replaceAll("^comp/env/", ""));
        boolean addEntry = false;
        if (resource == null) {
            resource = new ContextResource();
            resource.setName(ref.referenceName.replaceAll("^comp/env/", ""));
            addEntry = true;
        }
        resource.setProperty("factory", (Object)WsFactory.class.getName());
        resource.setProperty("name", (Object)ref.referenceName.replaceAll("^comp/env/", ""));
        if (ref.referenceType != null) {
            resource.setType(ref.referenceType);
        } else {
            resource.setType(ref.serviceType);
        }
        if (ref.location != null) {
            resource.setProperty("jndiname", (Object)ref.location.jndiName);
            resource.setProperty("jndiproviderid", (Object)ref.location.jndiProviderId);
        } else {
            URL wsdlURL;
            if (ref.id != null) {
                resource.setProperty("wsid", (Object)ref.id);
            }
            if (ref.serviceQName != null) {
                resource.setProperty("wsqname", (Object)ref.serviceQName.toString());
            }
            resource.setProperty("wsclass", (Object)ref.serviceType);
            if (ref.portQName != null) {
                resource.setProperty("wsportqname", (Object)ref.portQName.toString());
            }
            if ((wsdlURL = this.getWsdlUrl(ref)) != null) {
                resource.setProperty("wsdlurl", (Object)wsdlURL.toString());
            }
            if (!ref.portRefs.isEmpty()) {
                ArrayList<PortRefData> portRefs = new ArrayList<PortRefData>(ref.portRefs.size());
                for (PortRefInfo portRefInfo : ref.portRefs) {
                    PortRefData portRef = new PortRefData();
                    portRef.setQName(portRefInfo.qname);
                    portRef.setServiceEndpointInterface(portRefInfo.serviceEndpointInterface);
                    portRef.setEnableMtom(portRefInfo.enableMtom);
                    portRef.getProperties().putAll((Map<?, ?>)portRefInfo.properties);
                    portRefs.add(portRef);
                }
                this.setResource(resource, "port-refs", portRefs);
            }
            if (!ref.handlerChains.isEmpty()) {
                try {
                    List handlerChains = WsBuilder.toHandlerChainData((List)ref.handlerChains, (ClassLoader)this.standardContext.getLoader().getClassLoader());
                    this.setResource(resource, "handler-chains", handlerChains);
                    this.setResource(resource, "injections", this.injections);
                }
                catch (OpenEJBException e) {
                    throw new IllegalArgumentException("Error creating handler chain for web service-ref " + ref.referenceName.replaceAll("^comp/env/", ""));
                }
            }
        }
        ContextService service = naming.findService(ref.referenceName.replaceAll("^comp/env/", ""));
        String string = serviceName = service != null ? service.getName() : null;
        if (serviceName != null) {
            ContextAccessController.setWritable((Object)this.namingContextListener.getName(), (Object)this.standardContext.getNamingToken());
            if (!addEntry) {
                this.namingContextListener.removeService(serviceName);
            }
            ContextAccessController.setReadOnly((Object)this.namingContextListener.getName());
        }
        if (addEntry) {
            naming.addResource(resource);
        }
        if (this.replaceEntry) {
            ContextAccessController.setWritable((Object)this.namingContextListener.getName(), (Object)this.standardContext.getNamingToken());
            if (!addEntry) {
                this.namingContextListener.removeResource(resource.getName());
            }
            this.namingContextListener.addResource(resource);
            ContextAccessController.setReadOnly((Object)this.namingContextListener.getName());
        }
    }

    private URL getWsdlUrl(ServiceReferenceInfo ref) {
        if (ref.wsdlFile == null) {
            return null;
        }
        URL wsdlUrl = null;
        try {
            wsdlUrl = new URL(ref.wsdlFile);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (wsdlUrl == null) {
            wsdlUrl = this.standardContext.getLoader().getClassLoader().getResource(ref.wsdlFile);
        }
        if (wsdlUrl == null) {
            try {
                wsdlUrl = this.standardContext.getServletContext().getResource("/" + ref.wsdlFile);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (wsdlUrl == null) {
            throw new IllegalArgumentException("WSDL file " + ref.wsdlFile + " for web service-ref " + ref.referenceName.replaceAll("^comp/env/", "") + " not found");
        }
        return wsdlUrl;
    }

    private boolean isOpenEjb(NamingResourcesImpl naming, String name) {
        ContextResource resource = naming.findResource(name);
        return resource != null && ResourceFactory.class.getName().equals(resource.getProperty("factory"));
    }

    private void setResource(ContextResource resource, String name, Object object) {
        NamingUtil.setStaticValue((NamingUtil.Resource)new Resource(resource), (String)name, (Object)object);
    }

    private void setResource(ContextResource resource, Object object) {
        NamingUtil.setStaticValue((NamingUtil.Resource)new Resource(resource), (Object)object);
    }

    public static void importOpenEJBResourcesInTomcat(Collection<ResourceInfo> resources, StandardServer server) {
        NamingResourcesImpl naming = server.getGlobalNamingResources();
        for (ResourceInfo info : resources) {
            String name = info.id;
            if (name == null || naming.findResource(name) != null || info.properties.containsKey("UseAppClassLoader")) continue;
            ContextResource resource = new ContextResource();
            resource.setName(name);
            resource.setProperty("factory", (Object)ResourceFactory.class.getName());
            resource.setProperty("name", (Object)name);
            resource.setType(info.className);
            resource.setAuth("Container");
            naming.addResource(resource);
        }
    }

    private static class Resource
    implements NamingUtil.Resource {
        private final ContextResource contextResource;

        public Resource(ContextResource contextResource) {
            this.contextResource = contextResource;
        }

        public void setProperty(String name, Object value) {
            this.contextResource.setProperty(name, value);
        }
    }
}

