/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.lib.LongLookup;
import org.hsqldb.map.BitMap;
import org.hsqldb.persist.CachedObjectBase;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public class BitMapCachedObject
extends CachedObjectBase {
    public static final int fileSizeFactor = 4;
    BitMap bitMap;

    public BitMapCachedObject(int n) {
        this.bitMap = new BitMap(new int[n]);
        this.hasChanged = true;
    }

    @Override
    public void read(RowInputInterface rowInputInterface) {
        this.position = rowInputInterface.getFilePosition();
        int[] nArray = this.bitMap.getIntArray();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            nArray[i] = rowInputInterface.readInt();
        }
        this.hasChanged = false;
    }

    @Override
    public int getDefaultCapacity() {
        return this.bitMap.getIntArray().length;
    }

    @Override
    public int getRealSize(RowOutputInterface rowOutputInterface) {
        return this.bitMap.getIntArray().length * 4;
    }

    @Override
    public void write(RowOutputInterface rowOutputInterface) {
        this.write(rowOutputInterface, null);
    }

    @Override
    public void write(RowOutputInterface rowOutputInterface, LongLookup longLookup) {
        int[] nArray = this.bitMap.getIntArray();
        int n = nArray.length;
        rowOutputInterface.setStorageSize(this.storageSize);
        for (int i = 0; i < n; ++i) {
            rowOutputInterface.writeInt(nArray[i]);
        }
        rowOutputInterface.writeEnd();
    }

    public BitMap getBitMap() {
        return this.bitMap;
    }
}

