"codecbench of meshoptimizer" sample introduction
==============

This sample demonstrates how to build [codecbench of messoptimizer](https://github.com/zeux/meshoptimizer) into
WebAssembly with simd support and run it with iwasm.

## Preparation

please refer to [installation instructions](../README.md).

## Build with wasi-sdk

``` shell
$ mkdir build && cd build
$ cmake ..
$ make
# to verify
$ ls codecbench.wasm
```

## Or build with EMSDK

EMSDK is another toolchain to compile C/C++ code to WASM. In this case, the output wasm file
might have a higher performance than the file generated by wasi-sdk.

``` shell
$ git clone https://github.com/zeux/meshoptimizer.git
$ cd messoptimizer
$ em++ tools/codecbench.cpp src/vertexcodec.cpp src/vertexfilter.cpp \
       src/overdrawanalyzer.cpp src/indexgenerator.cpp src/vcacheoptimizer.cpp \
       src/clusterizer.cpp src/indexcodec.cpp src/vfetchanalyzer.cpp \
       src/spatialorder.cpp src/allocator.cpp src/vcacheanalyzer.cpp \
       src/vfetchoptimizer.cpp src/overdrawoptimizer.cpp src/simplifier.cpp \
       src/stripifier.cpp -O3 -msimd128 \
       -s TOTAL_MEMORY=268435456 \
       -o codecbench.wasm
$ ls -l codecbench.wasm
```

## Run workload

Firstly please build iwasm with simd support:

``` shell
$ cd <wamr dir>/product-mini/platforms/linux/
$ mkdir build && cd build
$ cmake .. -DWAMR_BUILD_SIMD=1
$ make
```

Then compile wasm file to aot file and run:

``` shell
$ <wamr dir>/wamr-compiler/build/wamrc --enable-simd -o codecbench.aot codecbench.wasm
$ <wamr dir>/product-mini/platforms/linux/build/iwasm codecbench.aot
```

