/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.rest.handler;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.xml.XmlDocSerializer;
import org.apache.juneau.xml.XmlParser;
import org.apache.juneau.xml.XmlSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.ActionInvocation;
import org.apache.struts2.rest.handler.ContentTypeHandler;

public class JuneauXmlHandler
implements ContentTypeHandler {
    private static final Logger LOG = LogManager.getLogger(JuneauXmlHandler.class);
    private static final String DEFAULT_CONTENT_TYPE = "application/xml";
    private final XmlParser parser = XmlParser.DEFAULT;
    private final XmlSerializer serializer = XmlDocSerializer.DEFAULT;

    @Override
    public void toObject(ActionInvocation invocation, Reader in, Object target) throws IOException {
        LOG.debug("Converting input into an object of: {}", (Object)target.getClass().getName());
        try {
            Object result = this.parser.parse((Object)in, target.getClass());
            BeanUtils.copyProperties((Object)target, (Object)result);
        }
        catch (IllegalAccessException | InvocationTargetException | ParseException e) {
            throw new IOException(e);
        }
    }

    @Override
    public String fromObject(ActionInvocation invocation, Object obj, String resultCode, Writer stream) throws IOException {
        LOG.debug("Converting an object of {} into string", (Object)obj.getClass().getName());
        try {
            this.serializer.builder().locale(invocation.getInvocationContext().getLocale()).build().serialize(obj, (Object)stream);
            return null;
        }
        catch (SerializeException e) {
            throw new IOException(e);
        }
    }

    @Override
    public String getContentType() {
        return DEFAULT_CONTENT_TYPE;
    }

    @Override
    public String getExtension() {
        return "xml";
    }
}

