/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.List;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.fill.DelayedFillActions;
import net.sf.jasperreports.engine.fill.ElementRange;
import net.sf.jasperreports.engine.fill.ElementRangeContents;
import net.sf.jasperreports.engine.fill.GroupFooterElementRange;
import net.sf.jasperreports.engine.type.FooterPositionEnum;

public final class ElementRangeUtil {
    private ElementRangeUtil() {
    }

    public static void expandOrIgnore(ElementRange elementRange, ElementRange newElementRange) {
        if (elementRange != null && elementRange.getPage() == newElementRange.getPage() && elementRange.getColumnIndex() == newElementRange.getColumnIndex()) {
            elementRange.expand(newElementRange.getBottomY());
        }
    }

    public static GroupFooterElementRange expandOrMove(GroupFooterElementRange groupFooterElementRange, GroupFooterElementRange newGroupFooterElementRange, int columnFooterOffsetY) {
        if (groupFooterElementRange == null) {
            groupFooterElementRange = newGroupFooterElementRange;
        } else if (groupFooterElementRange.getElementRange().getPage() == newGroupFooterElementRange.getElementRange().getPage() && groupFooterElementRange.getElementRange().getColumnIndex() == newGroupFooterElementRange.getElementRange().getColumnIndex()) {
            groupFooterElementRange.getElementRange().expand(newGroupFooterElementRange.getElementRange().getBottomY());
        } else {
            ElementRangeUtil.moveContent(groupFooterElementRange, columnFooterOffsetY);
            groupFooterElementRange = newGroupFooterElementRange;
        }
        return groupFooterElementRange;
    }

    public static void moveContent(GroupFooterElementRange groupFooterElementRange, int columnFooterOffsetY) {
        if (groupFooterElementRange.getMasterFooterPosition() != FooterPositionEnum.NORMAL) {
            ElementRange elementRange = groupFooterElementRange.getElementRange();
            int distanceToColumnFooter = columnFooterOffsetY - elementRange.getBottomY();
            for (int i = elementRange.getFirstElementIndex(); i <= elementRange.getLastElementIndex(); ++i) {
                JRPrintElement printElement = elementRange.getPage().getElements().get(i);
                printElement.setY(printElement.getY() + distanceToColumnFooter);
            }
        }
    }

    public static void moveContent(ElementRange elementRange, int topY) {
        int distanceToNewTopY = topY - elementRange.getTopY();
        for (int i = elementRange.getFirstElementIndex(); i <= elementRange.getLastElementIndex(); ++i) {
            JRPrintElement printElement = elementRange.getPage().getElements().get(i);
            printElement.setY(printElement.getY() + distanceToNewTopY);
        }
    }

    public static ElementRangeContents removeContent(ElementRange elementRange, DelayedFillActions delayedActions) {
        ElementRangeContents contents = new ElementRangeContents();
        if (elementRange.getFirstElementIndex() <= elementRange.getLastElementIndex()) {
            for (int i = elementRange.getLastElementIndex(); i >= elementRange.getFirstElementIndex(); --i) {
                contents.addElement(elementRange.getPage().getElements().remove(i));
            }
        }
        if (delayedActions != null) {
            delayedActions.collectElementEvaluations(elementRange.getPage(), contents.getElements(), contents);
        }
        return contents;
    }

    public static void addContent(JRPrintPage printPage, int pageIndex, ElementRangeContents elementsToMove, int xdelta, int ydelta, DelayedFillActions delayedActions) {
        if (elementsToMove != null && !elementsToMove.getElements().isEmpty()) {
            List<JRPrintElement> elements = elementsToMove.getElements();
            for (int i = elements.size() - 1; i >= 0; --i) {
                JRPrintElement printElement = elements.get(i);
                printElement.setX(printElement.getX() + xdelta);
                printElement.setY(printElement.getY() + ydelta);
                printPage.addElement(printElement);
            }
            if (delayedActions != null && elementsToMove.hasEvaluations()) {
                delayedActions.addElementEvaluations(printPage, pageIndex, elementsToMove);
            }
        }
    }
}

