/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.io.Writer;
import java.util.Map;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.ooxml.BaseHelper;
import net.sf.jasperreports.engine.util.JRStringUtil;

public class XlsxWorkbookHelper
extends BaseHelper {
    StringBuilder definedNames;

    public XlsxWorkbookHelper(JasperReportsContext jasperReportsContext, Writer writer) {
        super(jasperReportsContext, writer);
    }

    public XlsxWorkbookHelper(JasperReportsContext jasperReportsContext, Writer writer, StringBuilder definedNames) {
        super(jasperReportsContext, writer);
        this.definedNames = definedNames;
    }

    public void exportHeader() {
        this.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.write("<workbook\n");
        this.write(" xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\"\n");
        this.write(" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\">\n");
        this.write("<workbookPr filterPrivacy=\"1\" codeName=\"ThisWorkbook\"/>\n");
        this.write("<sheets>\n");
    }

    public void exportSheet(int index, String name, Map<String, Integer> sheetMapping) {
        String sheetName = JRStringUtil.xmlEncode(name);
        sheetMapping.put(sheetName, index - 1);
        this.write("  <sheet name=\"" + sheetName + "\" sheetId=\"" + index + "\" r:id=\"rId" + index + "\"/>\n");
    }

    public void exportFooter() {
        this.write("</sheets>\n");
        if (this.definedNames != null && this.definedNames.length() > 0) {
            this.write("<definedNames>\n");
            this.write(this.definedNames.toString());
            this.write("</definedNames>\n");
        }
        this.write("</workbook>\n");
    }
}

