/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.request;

import jakarta.servlet.DispatcherType;
import java.net.URI;
import org.springframework.http.HttpMethod;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMultipartHttpServletRequestBuilder;

public abstract class MockMvcRequestBuilders {
    public static MockHttpServletRequestBuilder get(String uriTemplate, Object ... uriVariables) {
        return new MockHttpServletRequestBuilder(HttpMethod.GET).uri(uriTemplate, uriVariables);
    }

    public static MockHttpServletRequestBuilder get(URI uri) {
        return new MockHttpServletRequestBuilder(HttpMethod.GET).uri(uri);
    }

    public static MockHttpServletRequestBuilder post(String uriTemplate, Object ... uriVariables) {
        return new MockHttpServletRequestBuilder(HttpMethod.POST).uri(uriTemplate, uriVariables);
    }

    public static MockHttpServletRequestBuilder post(URI uri) {
        return new MockHttpServletRequestBuilder(HttpMethod.POST).uri(uri);
    }

    public static MockHttpServletRequestBuilder put(String uriTemplate, Object ... uriVariables) {
        return new MockHttpServletRequestBuilder(HttpMethod.PUT).uri(uriTemplate, uriVariables);
    }

    public static MockHttpServletRequestBuilder put(URI uri) {
        return new MockHttpServletRequestBuilder(HttpMethod.PUT).uri(uri);
    }

    public static MockHttpServletRequestBuilder patch(String uriTemplate, Object ... uriVariables) {
        return new MockHttpServletRequestBuilder(HttpMethod.PATCH).uri(uriTemplate, uriVariables);
    }

    public static MockHttpServletRequestBuilder patch(URI uri) {
        return new MockHttpServletRequestBuilder(HttpMethod.PATCH).uri(uri);
    }

    public static MockHttpServletRequestBuilder delete(String uriTemplate, Object ... uriVariables) {
        return new MockHttpServletRequestBuilder(HttpMethod.DELETE).uri(uriTemplate, uriVariables);
    }

    public static MockHttpServletRequestBuilder delete(URI uri) {
        return new MockHttpServletRequestBuilder(HttpMethod.DELETE).uri(uri);
    }

    public static MockHttpServletRequestBuilder options(String uriTemplate, Object ... uriVariables) {
        return new MockHttpServletRequestBuilder(HttpMethod.OPTIONS).uri(uriTemplate, uriVariables);
    }

    public static MockHttpServletRequestBuilder options(URI uri) {
        return new MockHttpServletRequestBuilder(HttpMethod.OPTIONS).uri(uri);
    }

    public static MockHttpServletRequestBuilder head(String uriTemplate, Object ... uriVariables) {
        return new MockHttpServletRequestBuilder(HttpMethod.HEAD).uri(uriTemplate, uriVariables);
    }

    public static MockHttpServletRequestBuilder head(URI uri) {
        return new MockHttpServletRequestBuilder(HttpMethod.HEAD).uri(uri);
    }

    public static MockHttpServletRequestBuilder request(HttpMethod method, String uriTemplate, Object ... uriVariables) {
        return new MockHttpServletRequestBuilder(method).uri(uriTemplate, uriVariables);
    }

    public static MockHttpServletRequestBuilder request(HttpMethod httpMethod, URI uri) {
        return new MockHttpServletRequestBuilder(httpMethod).uri(uri);
    }

    @Deprecated(since="6.2")
    public static MockHttpServletRequestBuilder request(String httpMethod, URI uri) {
        return MockMvcRequestBuilders.request(HttpMethod.valueOf((String)httpMethod), uri);
    }

    public static MockMultipartHttpServletRequestBuilder multipart(String uriTemplate, Object ... uriVariables) {
        MockMultipartHttpServletRequestBuilder builder = new MockMultipartHttpServletRequestBuilder();
        builder.uri(uriTemplate, uriVariables);
        return builder;
    }

    public static MockMultipartHttpServletRequestBuilder multipart(HttpMethod httpMethod, String uriTemplate, Object ... uriVariables) {
        MockMultipartHttpServletRequestBuilder builder = new MockMultipartHttpServletRequestBuilder(httpMethod);
        builder.uri(uriTemplate, uriVariables);
        return builder;
    }

    public static MockMultipartHttpServletRequestBuilder multipart(URI uri) {
        MockMultipartHttpServletRequestBuilder builder = new MockMultipartHttpServletRequestBuilder();
        builder.uri(uri);
        return builder;
    }

    public static MockMultipartHttpServletRequestBuilder multipart(HttpMethod httpMethod, URI uri) {
        MockMultipartHttpServletRequestBuilder builder = new MockMultipartHttpServletRequestBuilder(httpMethod);
        builder.uri(uri);
        return builder;
    }

    public static RequestBuilder asyncDispatch(MvcResult mvcResult) {
        mvcResult.getAsyncResult();
        return servletContext -> {
            MockHttpServletRequest request2 = mvcResult.getRequest();
            request2.setDispatcherType(DispatcherType.ASYNC);
            request2.setAsyncStarted(false);
            return request2;
        };
    }
}

