/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.util;

import java.lang.reflect.Constructor;
import org.directwebremoting.util.CommonsLoggingOutput;
import org.directwebremoting.util.LoggingOutput;
import org.directwebremoting.util.ServletLoggingOutput;

public final class Logger {
    private static Class<? extends LoggingOutput> defaultImplementation = CommonsLoggingOutput.class;
    private static Constructor<? extends LoggingOutput> constructor = null;
    private static boolean defaultTried = false;
    private static boolean defaultAvailable = false;
    private LoggingOutput output;

    public static Logger getLogger(Class<?> base) {
        return new Logger(base);
    }

    public static void setDefaultImplementation(Class<? extends LoggingOutput> defaultImplementation) {
        Logger.defaultImplementation = defaultImplementation;
    }

    private Logger(Class<?> base) {
        if (!defaultTried) {
            try {
                constructor = defaultImplementation.getConstructor(Class.class);
                LoggingOutput internal = constructor.newInstance(Logger.class);
                internal.debug("Logging using " + defaultImplementation.getSimpleName());
                defaultAvailable = true;
            }
            catch (Throwable ex) {
                ServletLoggingOutput internal = new ServletLoggingOutput(base);
                internal.debug("Logging using servlet.log.");
                defaultAvailable = false;
            }
            defaultTried = true;
        }
        if (defaultAvailable) {
            try {
                this.output = constructor.newInstance(base);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.output = new ServletLoggingOutput(base);
            }
        } else {
            this.output = new ServletLoggingOutput(base);
        }
    }

    public void debug(String message) {
        this.output.debug(message);
    }

    public void info(String message) {
        this.output.info(message);
    }

    public void warn(String message) {
        this.output.warn(message);
    }

    public void warn(String message, Throwable th) {
        this.output.warn(message, th);
    }

    public void error(String message) {
        this.output.error(message);
    }

    public void error(String message, Throwable th) {
        this.output.error(message, th);
    }

    public void fatal(String message) {
        this.output.fatal(message);
    }

    public void fatal(String message, Throwable th) {
        this.output.fatal(message, th);
    }

    public boolean isDebugEnabled() {
        return this.output.isDebugEnabled();
    }
}

