/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.filter.Predicate;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCPartition;
import org.apache.spark.sql.execution.datasources.v2.TableSampleInfo;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JoinPushdownAliasGenerator$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005mf\u0001B\u0015+\u0001UB\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I!\u0010\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\")1\n\u0001C\u0001\u0019\"9\u0001\u000b\u0001a\u0001\n#\t\u0006bB/\u0001\u0001\u0004%\tB\u0018\u0005\u0007I\u0002\u0001\u000b\u0015\u0002*\t\u000f\u0015\u0004\u0001\u0019!C\t#\"9a\r\u0001a\u0001\n#9\u0007BB5\u0001A\u0003&!\u000bC\u0004k\u0001\u0001\u0007I\u0011C)\t\u000f-\u0004\u0001\u0019!C\tY\"1a\u000e\u0001Q!\nICqa\u001c\u0001A\u0002\u0013E\u0011\u000bC\u0004q\u0001\u0001\u0007I\u0011C9\t\rM\u0004\u0001\u0015)\u0003S\u0011\u001d!\b\u00011A\u0005\u0012UDq!\u001f\u0001A\u0002\u0013E!\u0010\u0003\u0004}\u0001\u0001\u0006KA\u001e\u0005\b{\u0002\u0001\r\u0011\"\u0005v\u0011\u001dq\b\u00011A\u0005\u0012}Dq!a\u0001\u0001A\u0003&a\u000f\u0003\u0005\u0002\u0006\u0001\u0001\r\u0011\"\u0005R\u0011%\t9\u0001\u0001a\u0001\n#\tI\u0001C\u0004\u0002\u000e\u0001\u0001\u000b\u0015\u0002*\t\u0011\u0005=\u0001A1A\u0005\u0012ECq!!\u0005\u0001A\u0003%!\u000bC\u0004\u0002\u0014\u0001!\t!!\u0006\t\u000f\u0005\u0005\u0002\u0001\"\u0001\u0002$!9\u00111\u0007\u0001\u0005\u0002\u0005U\u0002bBA.\u0001\u0011\u0005\u0011Q\f\u0005\b\u0003G\u0002A\u0011AA3\u0011\u001d\tY\u0007\u0001C\u0001\u0003[Bq!!\u001d\u0001\t\u0003\t\u0019\bC\u0004\u0002x\u0001!\t!!\u001f\t\u0013\u0005-\u0005\u00011A\u0005\n\u00055\u0005\"CAH\u0001\u0001\u0007I\u0011BAI\u0011!\t)\n\u0001Q!\n\u00055\u0002bBAL\u0001\u0011\u0005\u0011\u0011\u0014\u0005\u0007\u0003k\u0003AQC)\t\u000f\u0005]\u0006\u0001\"\u0001\u0002:\n\u0019\"\n\u001a2d'Fc\u0015+^3ss\n+\u0018\u000e\u001c3fe*\u00111\u0006L\u0001\u0005U\u0012\u00147M\u0003\u0002.]\u0005\u00191/\u001d7\u000b\u0005=\u0002\u0014!B:qCJ\\'BA\u00193\u0003\u0019\t\u0007/Y2iK*\t1'A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001mA\u0011qGO\u0007\u0002q)\t\u0011(A\u0003tG\u0006d\u0017-\u0003\u0002<q\t1\u0011I\\=SK\u001a\fq\u0001Z5bY\u0016\u001cG\u000f\u0005\u0002?\u007f5\t!&\u0003\u0002AU\tY!\n\u001a2d\t&\fG.Z2u\u0003\u001dy\u0007\u000f^5p]N\u0004\"aQ%\u000e\u0003\u0011S!aK#\u000b\u0005\u0019;\u0015a\u00033bi\u0006\u001cx.\u001e:dKNT!\u0001\u0013\u0017\u0002\u0013\u0015DXmY;uS>t\u0017B\u0001&E\u0005-QEIQ\"PaRLwN\\:\u0002\rqJg.\u001b;?)\riej\u0014\t\u0003}\u0001AQ\u0001P\u0002A\u0002uBQ!Q\u0002A\u0002\t\u000b!bY8mk6tG*[:u+\u0005\u0011\u0006CA*[\u001d\t!\u0006\f\u0005\u0002Vq5\taK\u0003\u0002Xi\u00051AH]8pizJ!!\u0017\u001d\u0002\rA\u0013X\rZ3g\u0013\tYFL\u0001\u0004TiJLgn\u001a\u0006\u00033b\nabY8mk6tG*[:u?\u0012*\u0017\u000f\u0006\u0002`EB\u0011q\u0007Y\u0005\u0003Cb\u0012A!\u00168ji\"91-BA\u0001\u0002\u0004\u0011\u0016a\u0001=%c\u0005Y1m\u001c7v[:d\u0015n\u001d;!\u0003-9\b.\u001a:f\u00072\fWo]3\u0002\u001f]DWM]3DY\u0006,8/Z0%KF$\"a\u00185\t\u000f\rD\u0011\u0011!a\u0001%\u0006aq\u000f[3sK\u000ec\u0017-^:fA\u0005iqM]8va\nK8\t\\1vg\u0016\f\u0011c\u001a:pkB\u0014\u0015p\u00117bkN,w\fJ3r)\tyV\u000eC\u0004d\u0017\u0005\u0005\t\u0019\u0001*\u0002\u001d\u001d\u0014x.\u001e9Cs\u000ec\u0017-^:fA\u0005iqN\u001d3fe\nK8\t\\1vg\u0016\f\u0011c\u001c:eKJ\u0014\u0015p\u00117bkN,w\fJ3r)\ty&\u000fC\u0004d\u001d\u0005\u0005\t\u0019\u0001*\u0002\u001d=\u0014H-\u001a:Cs\u000ec\u0017-^:fA\u0005)A.[7jiV\ta\u000f\u0005\u00028o&\u0011\u0001\u0010\u000f\u0002\u0004\u0013:$\u0018!\u00037j[&$x\fJ3r)\ty6\u0010C\u0004d#\u0005\u0005\t\u0019\u0001<\u0002\r1LW.\u001b;!\u0003\u0019ygMZ:fi\u0006QqN\u001a4tKR|F%Z9\u0015\u0007}\u000b\t\u0001C\u0004d)\u0005\u0005\t\u0019\u0001<\u0002\u000f=4gm]3uA\u0005\tB/\u00192mKN\u000bW\u000e\u001d7f\u00072\fWo]3\u0002+Q\f'\r\\3TC6\u0004H.Z\"mCV\u001cXm\u0018\u0013fcR\u0019q,a\u0003\t\u000f\r<\u0012\u0011!a\u0001%\u0006\u0011B/\u00192mKN\u000bW\u000e\u001d7f\u00072\fWo]3!\u0003)A\u0017N\u001c;DY\u0006,8/Z\u0001\fQ&tGo\u00117bkN,\u0007%A\u0006xSRD7i\u001c7v[:\u001cHcA'\u0002\u0018!9\u0011\u0011D\u000eA\u0002\u0005m\u0011aB2pYVlgn\u001d\t\u0005o\u0005u!+C\u0002\u0002 a\u0012Q!\u0011:sCf\f!c^5uQ\u0006c\u0017.Y:fI\u000e{G.^7ogR)Q*!\n\u0002(!9\u0011\u0011\u0004\u000fA\u0002\u0005m\u0001bBA\u00159\u0001\u0007\u00111F\u0001\bC2L\u0017m]3t!\u00159\u0014QDA\u0017!\u00119\u0014q\u0006*\n\u0007\u0005E\u0002H\u0001\u0004PaRLwN\\\u0001\u000fo&$\b\u000e\u0015:fI&\u001c\u0017\r^3t)\u0015i\u0015qGA)\u0011\u001d\tI$\ba\u0001\u0003w\t!\u0002\u001d:fI&\u001c\u0017\r^3t!\u00159\u0014QDA\u001f!\u0011\ty$!\u0014\u000e\u0005\u0005\u0005#\u0002BA\"\u0003\u000b\naAZ5mi\u0016\u0014(\u0002BA$\u0003\u0013\n1\"\u001a=qe\u0016\u001c8/[8og*\u0019\u00111\n\u0017\u0002\u0013\r|gN\\3di>\u0014\u0018\u0002BA(\u0003\u0003\u0012\u0011\u0002\u0015:fI&\u001c\u0017\r^3\t\u000f\u0005MS\u00041\u0001\u0002V\u0005!\u0001/\u0019:u!\r\u0019\u0015qK\u0005\u0004\u00033\"%!\u0004&E\u0005\u000e\u0003\u0016M\u001d;ji&|g.\u0001\nxSRDwI]8va\nK8i\u001c7v[:\u001cHcA'\u0002`!9\u0011\u0011\r\u0010A\u0002\u0005m\u0011AD4s_V\u0004()_\"pYVlgn]\u0001\u000fo&$\bnU8si>\u0013H-\u001a:t)\ri\u0015q\r\u0005\b\u0003Sz\u0002\u0019AA\u000e\u0003)\u0019xN\u001d;Pe\u0012,'o]\u0001\no&$\b\u000eT5nSR$2!TA8\u0011\u0015!\b\u00051\u0001w\u0003)9\u0018\u000e\u001e5PM\u001a\u001cX\r\u001e\u000b\u0004\u001b\u0006U\u0004\"B?\"\u0001\u00041\u0018aD<ji\"$\u0016M\u00197f'\u0006l\u0007\u000f\\3\u0015\u00075\u000bY\bC\u0004\u0002~\t\u0002\r!a \u0002\rM\fW\u000e\u001d7f!\u0011\t\t)a\"\u000e\u0005\u0005\r%bAAC\u000b\u0006\u0011aOM\u0005\u0005\u0003\u0013\u000b\u0019IA\bUC\ndWmU1na2,\u0017J\u001c4p\u0003%Qw.\u001b8Rk\u0016\u0014\u00180\u0006\u0002\u0002.\u0005i!n\\5o#V,'/_0%KF$2aXAJ\u0011!\u0019G%!AA\u0002\u00055\u0012A\u00036pS:\fV/\u001a:zA\u0005Aq/\u001b;i\u0015>Lg\u000eF\bN\u00037\u000by*a)\u0002(\u0006-\u0016QVAY\u0011\u0019\tiJ\na\u0001\u001b\u0006!A.\u001a4u\u0011\u0019\t\tK\na\u0001\u001b\u0006)!/[4ii\"1\u0011Q\u0015\u0014A\u0002I\u000b\u0011\u0003\\3giNKG-Z)vC2Lg-[3s\u0011\u0019\tIK\na\u0001%\u0006\u0011\"/[4iiNKG-Z)vC2Lg-[3s\u0011\u001d\tIB\na\u0001\u00037Aa!a,'\u0001\u0004\u0011\u0016\u0001\u00036pS:$\u0016\u0010]3\t\r\u0005Mf\u00051\u0001S\u00035Qw.\u001b8D_:$\u0017\u000e^5p]\u0006aA/\u00192mK>\u0013\u0018+^3ss\u0006)!-^5mIR\t!\u000b")
public class JdbcSQLQueryBuilder {
    private final JdbcDialect dialect;
    private final JDBCOptions options;
    private String columnList;
    private String whereClause;
    private String groupByClause;
    private String orderByClause;
    private int limit;
    private int offset;
    private String tableSampleClause;
    private final String hintClause;
    private Option<String> joinQuery;

    public String columnList() {
        return this.columnList;
    }

    public void columnList_$eq(String x$1) {
        this.columnList = x$1;
    }

    public String whereClause() {
        return this.whereClause;
    }

    public void whereClause_$eq(String x$1) {
        this.whereClause = x$1;
    }

    public String groupByClause() {
        return this.groupByClause;
    }

    public void groupByClause_$eq(String x$1) {
        this.groupByClause = x$1;
    }

    public String orderByClause() {
        return this.orderByClause;
    }

    public void orderByClause_$eq(String x$1) {
        this.orderByClause = x$1;
    }

    public int limit() {
        return this.limit;
    }

    public void limit_$eq(int x$1) {
        this.limit = x$1;
    }

    public int offset() {
        return this.offset;
    }

    public void offset_$eq(int x$1) {
        this.offset = x$1;
    }

    public String tableSampleClause() {
        return this.tableSampleClause;
    }

    public void tableSampleClause_$eq(String x$1) {
        this.tableSampleClause = x$1;
    }

    public String hintClause() {
        return this.hintClause;
    }

    public JdbcSQLQueryBuilder withColumns(String[] columns) {
        block0: {
            if (!ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])columns))) break block0;
            this.columnList_$eq(Predef$.MODULE$.wrapRefArray((Object[])columns).mkString(","));
        }
        return this;
    }

    public JdbcSQLQueryBuilder withAliasedColumns(String[] columns, Option<String>[] aliases) {
        block0: {
            if (!ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])columns))) break block0;
            Predef$.MODULE$.assert(columns.length == aliases.length, (Function0 & Serializable)() -> "Number of columns does not match the number of provided aliases");
            this.columnList_$eq(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])columns), (IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])aliases))), (Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String column = (String)tuple2._1();
                    Option alias = (Option)tuple2._2();
                    if (alias.isDefined()) {
                        return column + " AS " + alias.get();
                    }
                    return column;
                }
                throw new MatchError((Object)tuple2);
            }, ClassTag$.MODULE$.apply(String.class))).mkString(","));
        }
        return this;
    }

    public JdbcSQLQueryBuilder withPredicates(Predicate[] predicates, JDBCPartition part) {
        String filterWhereClause = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])predicates), (Function1 & Serializable)x$1 -> $this.dialect.compileExpression((Expression)x$1), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)p -> "(" + p + ")", ClassTag$.MODULE$.apply(String.class))).mkString(" AND ");
        this.whereClause_$eq((String)(part.whereClause() != null && filterWhereClause.length() > 0 ? "WHERE (" + filterWhereClause + ") AND (" + part.whereClause() + ")" : (part.whereClause() != null ? "WHERE " + part.whereClause() : (filterWhereClause.length() > 0 ? "WHERE " + filterWhereClause : ""))));
        return this;
    }

    public JdbcSQLQueryBuilder withGroupByColumns(String[] groupByColumns) {
        block0: {
            if (!ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])groupByColumns))) break block0;
            this.groupByClause_$eq("GROUP BY " + Predef$.MODULE$.wrapRefArray((Object[])groupByColumns).mkString(", "));
        }
        return this;
    }

    public JdbcSQLQueryBuilder withSortOrders(String[] sortOrders) {
        block0: {
            if (!ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])sortOrders))) break block0;
            this.orderByClause_$eq(" ORDER BY " + Predef$.MODULE$.wrapRefArray((Object[])sortOrders).mkString(", "));
        }
        return this;
    }

    public JdbcSQLQueryBuilder withLimit(int limit) {
        this.limit_$eq(limit);
        return this;
    }

    public JdbcSQLQueryBuilder withOffset(int offset) {
        this.offset_$eq(offset);
        return this;
    }

    public JdbcSQLQueryBuilder withTableSample(TableSampleInfo sample) {
        this.tableSampleClause_$eq(this.dialect.getTableSample(sample));
        return this;
    }

    private Option<String> joinQuery() {
        return this.joinQuery;
    }

    private void joinQuery_$eq(Option<String> x$1) {
        this.joinQuery = x$1;
    }

    public JdbcSQLQueryBuilder withJoin(JdbcSQLQueryBuilder left, JdbcSQLQueryBuilder right, String leftSideQualifier, String rightSideQualifier, String[] columns, String joinType, String joinCondition) {
        this.columnList_$eq(Predef$.MODULE$.wrapRefArray((Object[])columns).mkString(","));
        this.joinQuery_$eq((Option<String>)new Some((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("(\n       |SELECT " + Predef$.MODULE$.wrapRefArray((Object[])columns).mkString(",") + " FROM\n       |(" + left.build() + ") " + leftSideQualifier + "\n       |" + joinType + "\n       |(" + right.build() + ") " + rightSideQualifier + "\n       |ON " + joinCondition + "\n       |) " + JoinPushdownAliasGenerator$.MODULE$.getSubqueryQualifier()))));
        return this;
    }

    public final String tableOrQuery() {
        return (String)this.joinQuery().getOrElse((Function0 & Serializable)() -> $this.options.tableOrQuery());
    }

    public String build() {
        String limitClause = this.dialect.getLimitClause(Predef$.MODULE$.int2Integer(this.limit()));
        String offsetClause = this.dialect.getOffsetClause(Predef$.MODULE$.int2Integer(this.offset()));
        return this.options.prepareQuery() + "SELECT " + this.hintClause() + this.columnList() + " FROM " + this.tableOrQuery() + " " + this.tableSampleClause() + " " + this.whereClause() + " " + this.groupByClause() + " " + this.orderByClause() + " " + limitClause + " " + offsetClause;
    }

    public JdbcSQLQueryBuilder(JdbcDialect dialect, JDBCOptions options) {
        this.dialect = dialect;
        this.options = options;
        this.columnList = "1";
        this.whereClause = "";
        this.groupByClause = "";
        this.orderByClause = "";
        this.limit = -1;
        this.offset = -1;
        this.tableSampleClause = "";
        String string = options.hint();
        String string2 = "";
        if ((string == null ? string2 != null : !string.equals(string2)) && !dialect.supportsHint()) {
            throw QueryExecutionErrors$.MODULE$.hintUnsupportedForJdbcDialectError(dialect.getClass().getSimpleName());
        }
        this.hintClause = options.hint();
        this.joinQuery = None$.MODULE$;
    }
}

