/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2.state;

import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.DataSourceOptions;
import org.apache.spark.sql.execution.datasources.v2.state.FromSnapshotOptions;
import org.apache.spark.sql.execution.datasources.v2.state.ReadChangeFeedOptions;
import org.apache.spark.sql.execution.datasources.v2.state.StateDataSourceErrors$;
import org.apache.spark.sql.execution.datasources.v2.state.StateSourceOptions;
import org.apache.spark.sql.execution.datasources.v2.state.StateSourceOptions$JoinSideValues$;
import org.apache.spark.sql.execution.datasources.v2.state.StreamStreamJoinStateHelper$;
import org.apache.spark.sql.execution.streaming.checkpointing.CommitLog;
import org.apache.spark.sql.execution.streaming.checkpointing.CommitMetadata;
import org.apache.spark.sql.execution.streaming.runtime.StreamingQueryCheckpointMetadata;
import org.apache.spark.sql.execution.streaming.state.StateStoreId$;
import org.apache.spark.sql.execution.streaming.utils.StreamingUtils$;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple14;
import scala.Tuple2;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class StateSourceOptions$
implements DataSourceOptions,
Logging,
Serializable {
    public static final StateSourceOptions$ MODULE$ = new StateSourceOptions$();
    private static final String PATH;
    private static final String BATCH_ID;
    private static final String OPERATOR_ID;
    private static final String STORE_NAME;
    private static final String JOIN_SIDE;
    private static final String SNAPSHOT_START_BATCH_ID;
    private static final String SNAPSHOT_PARTITION_ID;
    private static final String READ_CHANGE_FEED;
    private static final String CHANGE_START_BATCH_ID;
    private static final String CHANGE_END_BATCH_ID;
    private static final String STATE_VAR_NAME;
    private static final String READ_REGISTERED_TIMERS;
    private static final String FLATTEN_COLLECTION_TYPES;
    private static final String INTERNAL_ONLY_READ_ALL_COLUMN_FAMILIES;
    private static transient Logger org$apache$spark$internal$Logging$$log_;
    private static scala.collection.mutable.Map<String, Option<String>> org$apache$spark$sql$catalyst$DataSourceOptions$$validOptions;

    static {
        DataSourceOptions.$init$((DataSourceOptions)MODULE$);
        Logging.$init$((Logging)MODULE$);
        PATH = MODULE$.newOption("path");
        BATCH_ID = MODULE$.newOption("batchId");
        OPERATOR_ID = MODULE$.newOption("operatorId");
        STORE_NAME = MODULE$.newOption("storeName");
        JOIN_SIDE = MODULE$.newOption("joinSide");
        SNAPSHOT_START_BATCH_ID = MODULE$.newOption("snapshotStartBatchId");
        SNAPSHOT_PARTITION_ID = MODULE$.newOption("snapshotPartitionId");
        READ_CHANGE_FEED = MODULE$.newOption("readChangeFeed");
        CHANGE_START_BATCH_ID = MODULE$.newOption("changeStartBatchId");
        CHANGE_END_BATCH_ID = MODULE$.newOption("changeEndBatchId");
        STATE_VAR_NAME = MODULE$.newOption("stateVarName");
        READ_REGISTERED_TIMERS = MODULE$.newOption("readRegisteredTimers");
        FLATTEN_COLLECTION_TYPES = MODULE$.newOption("flattenCollectionTypes");
        INTERNAL_ONLY_READ_ALL_COLUMN_FAMILIES = MODULE$.newOption("_readAllColumnFamilies");
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public String newOption(String name) {
        return DataSourceOptions.newOption$((DataSourceOptions)this, (String)name);
    }

    public void newOption(String name, String alternative) {
        DataSourceOptions.newOption$((DataSourceOptions)this, (String)name, (String)alternative);
    }

    public Set<String> getAllOptions() {
        return DataSourceOptions.getAllOptions$((DataSourceOptions)this);
    }

    public boolean isValidOption(String name) {
        return DataSourceOptions.isValidOption$((DataSourceOptions)this, (String)name);
    }

    public Option<String> getAlternativeOption(String name) {
        return DataSourceOptions.getAlternativeOption$((DataSourceOptions)this, (String)name);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public scala.collection.mutable.Map<String, Option<String>> org$apache$spark$sql$catalyst$DataSourceOptions$$validOptions() {
        return org$apache$spark$sql$catalyst$DataSourceOptions$$validOptions;
    }

    public final void org$apache$spark$sql$catalyst$DataSourceOptions$_setter_$org$apache$spark$sql$catalyst$DataSourceOptions$$validOptions_$eq(scala.collection.mutable.Map<String, Option<String>> x$1) {
        org$apache$spark$sql$catalyst$DataSourceOptions$$validOptions = x$1;
    }

    public boolean $lessinit$greater$default$12() {
        return false;
    }

    public Option<String[][]> $lessinit$greater$default$13() {
        return None$.MODULE$;
    }

    public Option<String[][]> $lessinit$greater$default$14() {
        return None$.MODULE$;
    }

    public String PATH() {
        return PATH;
    }

    public String BATCH_ID() {
        return BATCH_ID;
    }

    public String OPERATOR_ID() {
        return OPERATOR_ID;
    }

    public String STORE_NAME() {
        return STORE_NAME;
    }

    public String JOIN_SIDE() {
        return JOIN_SIDE;
    }

    public String SNAPSHOT_START_BATCH_ID() {
        return SNAPSHOT_START_BATCH_ID;
    }

    public String SNAPSHOT_PARTITION_ID() {
        return SNAPSHOT_PARTITION_ID;
    }

    public String READ_CHANGE_FEED() {
        return READ_CHANGE_FEED;
    }

    public String CHANGE_START_BATCH_ID() {
        return CHANGE_START_BATCH_ID;
    }

    public String CHANGE_END_BATCH_ID() {
        return CHANGE_END_BATCH_ID;
    }

    public String STATE_VAR_NAME() {
        return STATE_VAR_NAME;
    }

    public String READ_REGISTERED_TIMERS() {
        return READ_REGISTERED_TIMERS;
    }

    public String FLATTEN_COLLECTION_TYPES() {
        return FLATTEN_COLLECTION_TYPES;
    }

    public String INTERNAL_ONLY_READ_ALL_COLUMN_FAMILIES() {
        return INTERNAL_ONLY_READ_ALL_COLUMN_FAMILIES;
    }

    public StateSourceOptions apply(SparkSession sparkSession, Configuration hadoopConf, Map<String, String> properties) {
        return this.apply(sparkSession, hadoopConf, new CaseInsensitiveStringMap(properties));
    }

    public StateSourceOptions apply(SparkSession sparkSession, Configuration hadoopConf, CaseInsensitiveStringMap options) {
        Option<String[][]> endOperatorStateUniqueIds;
        boolean bl;
        Enumeration.Value joinSide;
        Enumeration.Value value;
        boolean bl2;
        boolean bl3;
        String checkpointLocation = (String)Option$.MODULE$.apply((Object)options.get((Object)this.PATH())).orElse((Function0 & Serializable)() -> {
            throw StateDataSourceErrors$.MODULE$.requiredOptionUnspecified(MODULE$.PATH());
        }).get();
        int operatorId = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)options.get((Object)this.OPERATOR_ID())).map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$4)))).orElse((Function0 & Serializable)() -> new Some((Object)BoxesRunTime.boxToInteger((int)0))).get());
        if (operatorId < 0) {
            throw StateDataSourceErrors$.MODULE$.invalidOptionValueIsNegative(this.OPERATOR_ID());
        }
        String storeName = (String)Option$.MODULE$.apply((Object)options.get((Object)this.STORE_NAME())).map((Function1 & Serializable)x$5 -> x$5.trim()).getOrElse((Function0 & Serializable)() -> StateStoreId$.MODULE$.DEFAULT_STORE_NAME());
        if (storeName.isEmpty()) {
            throw StateDataSourceErrors$.MODULE$.invalidOptionValueIsEmpty(this.STORE_NAME());
        }
        Option stateVarName = Option$.MODULE$.apply((Object)options.get((Object)this.STATE_VAR_NAME())).map((Function1 & Serializable)x$6 -> x$6.trim());
        try {
            bl3 = BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply((Object)options.get((Object)this.READ_REGISTERED_TIMERS())).map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$7)))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw StateDataSourceErrors$.MODULE$.invalidOptionValue(this.READ_REGISTERED_TIMERS(), "Boolean value is expected");
        }
        boolean readRegisteredTimers = bl3;
        if (readRegisteredTimers && stateVarName.isDefined()) {
            throw StateDataSourceErrors$.MODULE$.conflictOptions((Seq<String>)new .colon.colon((Object)this.READ_REGISTERED_TIMERS(), (List)new .colon.colon((Object)this.STATE_VAR_NAME(), (List)Nil$.MODULE$)));
        }
        try {
            bl2 = BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply((Object)options.get((Object)this.FLATTEN_COLLECTION_TYPES())).map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$8)))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> true));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw StateDataSourceErrors$.MODULE$.invalidOptionValue(this.FLATTEN_COLLECTION_TYPES(), "Boolean value is expected");
        }
        boolean flattenCollectionTypes = bl2;
        try {
            value = (Enumeration.Value)Option$.MODULE$.apply((Object)options.get((Object)this.JOIN_SIDE())).map((Function1 & Serializable)s -> StateSourceOptions$JoinSideValues$.MODULE$.withName((String)s)).getOrElse((Function0 & Serializable)() -> StateSourceOptions$JoinSideValues$.MODULE$.none());
        }
        catch (NoSuchElementException noSuchElementException) {
            throw StateDataSourceErrors$.MODULE$.invalidOptionValue(this.JOIN_SIDE(), "Valid values are " + StateSourceOptions$JoinSideValues$.MODULE$.values().mkString(","));
        }
        Enumeration.Value value2 = joinSide = value;
        Enumeration.Value value3 = StateSourceOptions$JoinSideValues$.MODULE$.none();
        if (value2 == null ? value3 != null : !value2.equals(value3)) {
            String string = storeName;
            String string2 = StateStoreId$.MODULE$.DEFAULT_STORE_NAME();
            if (string == null ? string2 != null : !string.equals(string2)) {
                throw StateDataSourceErrors$.MODULE$.conflictOptions((Seq<String>)new .colon.colon((Object)this.JOIN_SIDE(), (List)new .colon.colon((Object)this.STORE_NAME(), (List)Nil$.MODULE$)));
            }
        }
        String resolvedCpLocation = StreamingUtils$.MODULE$.resolvedCheckpointLocation(hadoopConf, checkpointLocation);
        ObjectRef batchId = ObjectRef.create((Object)Option$.MODULE$.apply((Object)options.get((Object)this.BATCH_ID())).map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$9)))));
        Option snapshotStartBatchId = Option$.MODULE$.apply((Object)options.get((Object)this.SNAPSHOT_START_BATCH_ID())).map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$10))));
        Option snapshotPartitionId = Option$.MODULE$.apply((Object)options.get((Object)this.SNAPSHOT_PARTITION_ID())).map((Function1 & Serializable)x$11 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$11))));
        boolean readChangeFeed = Option$.MODULE$.apply((Object)options.get((Object)this.READ_CHANGE_FEED())).exists((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$12))));
        try {
            bl = Option$.MODULE$.apply((Object)options.get((Object)this.INTERNAL_ONLY_READ_ALL_COLUMN_FAMILIES())).exists((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$13))));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw StateDataSourceErrors$.MODULE$.invalidOptionValue(this.INTERNAL_ONLY_READ_ALL_COLUMN_FAMILIES(), "Boolean value is expected");
        }
        boolean internalOnlyReadAllColumnFamilies = bl;
        if (internalOnlyReadAllColumnFamilies) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "StateSourceOptions option INTERNAL_ONLY_READ_ALL_COLUMN_FAMILIES is enabled. This config should only be used for internal callers e.g. repartitioning");
            if (stateVarName.isDefined()) {
                throw StateDataSourceErrors$.MODULE$.conflictOptions((Seq<String>)new .colon.colon((Object)this.INTERNAL_ONLY_READ_ALL_COLUMN_FAMILIES(), (List)new .colon.colon((Object)this.STATE_VAR_NAME(), (List)Nil$.MODULE$)));
            }
            Enumeration.Value value4 = joinSide;
            Enumeration.Value value5 = StateSourceOptions$JoinSideValues$.MODULE$.none();
            if (value4 == null ? value5 != null : !value4.equals(value5)) {
                throw StateDataSourceErrors$.MODULE$.conflictOptions((Seq<String>)new .colon.colon((Object)this.INTERNAL_ONLY_READ_ALL_COLUMN_FAMILIES(), (List)new .colon.colon((Object)this.JOIN_SIDE(), (List)Nil$.MODULE$)));
            }
            if (readChangeFeed) {
                throw StateDataSourceErrors$.MODULE$.conflictOptions((Seq<String>)new .colon.colon((Object)this.INTERNAL_ONLY_READ_ALL_COLUMN_FAMILIES(), (List)new .colon.colon((Object)this.READ_CHANGE_FEED(), (List)Nil$.MODULE$)));
            }
        }
        Option changeStartBatchId = Option$.MODULE$.apply((Object)options.get((Object)this.CHANGE_START_BATCH_ID())).map((Function1 & Serializable)x$14 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$14))));
        Option changeEndBatchId = Option$.MODULE$.apply((Object)options.get((Object)this.CHANGE_END_BATCH_ID())).map((Function1 & Serializable)x$15 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$15))));
        None$ fromSnapshotOptions = None$.MODULE$;
        None$ readChangeFeedOptions = None$.MODULE$;
        if (readChangeFeed) {
            Enumeration.Value value6 = joinSide;
            Enumeration.Value value7 = StateSourceOptions$JoinSideValues$.MODULE$.none();
            if (value6 == null ? value7 != null : !value6.equals(value7)) {
                throw StateDataSourceErrors$.MODULE$.conflictOptions((Seq<String>)new .colon.colon((Object)this.JOIN_SIDE(), (List)new .colon.colon((Object)this.READ_CHANGE_FEED(), (List)Nil$.MODULE$)));
            }
            if (((Option)batchId.elem).isDefined()) {
                throw StateDataSourceErrors$.MODULE$.conflictOptions((Seq<String>)new .colon.colon((Object)this.BATCH_ID(), (List)new .colon.colon((Object)this.READ_CHANGE_FEED(), (List)Nil$.MODULE$)));
            }
            if (snapshotStartBatchId.isDefined()) {
                throw StateDataSourceErrors$.MODULE$.conflictOptions((Seq<String>)new .colon.colon((Object)this.SNAPSHOT_START_BATCH_ID(), (List)new .colon.colon((Object)this.READ_CHANGE_FEED(), (List)Nil$.MODULE$)));
            }
            if (snapshotPartitionId.isDefined()) {
                throw StateDataSourceErrors$.MODULE$.conflictOptions((Seq<String>)new .colon.colon((Object)this.SNAPSHOT_PARTITION_ID(), (List)new .colon.colon((Object)this.READ_CHANGE_FEED(), (List)Nil$.MODULE$)));
            }
            if (changeStartBatchId.isEmpty()) {
                throw StateDataSourceErrors$.MODULE$.requiredOptionUnspecified(this.CHANGE_START_BATCH_ID());
            }
            changeEndBatchId = new Some(changeEndBatchId.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> MODULE$.getLastCommittedBatch(sparkSession, resolvedCpLocation)));
            if (BoxesRunTime.unboxToLong((Object)changeStartBatchId.get()) < 0L) {
                throw StateDataSourceErrors$.MODULE$.invalidOptionValueIsNegative(this.CHANGE_START_BATCH_ID());
            }
            if (BoxesRunTime.unboxToLong((Object)changeEndBatchId.get()) < BoxesRunTime.unboxToLong((Object)changeStartBatchId.get())) {
                throw StateDataSourceErrors$.MODULE$.invalidOptionValue(this.CHANGE_END_BATCH_ID(), this.CHANGE_END_BATCH_ID() + " cannot be smaller than " + this.CHANGE_START_BATCH_ID() + ". Please check the input to " + this.CHANGE_END_BATCH_ID() + ", or if you are using its default value, make sure that " + this.CHANGE_START_BATCH_ID() + " is less than " + changeEndBatchId.get() + ".");
            }
            batchId.elem = new Some(changeEndBatchId.get());
            readChangeFeedOptions = Option$.MODULE$.apply((Object)new ReadChangeFeedOptions(BoxesRunTime.unboxToLong((Object)changeStartBatchId.get()), BoxesRunTime.unboxToLong((Object)changeEndBatchId.get())));
        } else {
            if (changeStartBatchId.isDefined()) {
                throw StateDataSourceErrors$.MODULE$.invalidOptionValue(this.CHANGE_START_BATCH_ID(), "Only specify this option when " + this.READ_CHANGE_FEED() + " is set to true.");
            }
            if (changeEndBatchId.isDefined()) {
                throw StateDataSourceErrors$.MODULE$.invalidOptionValue(this.CHANGE_END_BATCH_ID(), "Only specify this option when " + this.READ_CHANGE_FEED() + " is set to true.");
            }
            batchId.elem = new Some(((Option)batchId.elem).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> MODULE$.getLastCommittedBatch(sparkSession, resolvedCpLocation)));
            if (BoxesRunTime.unboxToLong((Object)((Option)batchId.elem).get()) < 0L) {
                throw StateDataSourceErrors$.MODULE$.invalidOptionValueIsNegative(this.BATCH_ID());
            }
            if (snapshotStartBatchId.exists((Function1)(JFunction1.mcZJ.sp & Serializable)x$16 -> x$16 < 0L)) {
                throw StateDataSourceErrors$.MODULE$.invalidOptionValueIsNegative(this.SNAPSHOT_START_BATCH_ID());
            }
            if (snapshotStartBatchId.exists((Function1)(JFunction1.mcZJ.sp & Serializable)x$17 -> x$17 > BoxesRunTime.unboxToLong((Object)((Option)batchId$2.elem).get()))) {
                throw StateDataSourceErrors$.MODULE$.invalidOptionValue(this.SNAPSHOT_START_BATCH_ID(), "value should be less than or equal to " + ((Option)batchId.elem).get());
            }
            if (snapshotPartitionId.exists((Function1)(JFunction1.mcZI.sp & Serializable)x$18 -> x$18 < 0)) {
                throw StateDataSourceErrors$.MODULE$.invalidOptionValueIsNegative(this.SNAPSHOT_PARTITION_ID());
            }
            if (snapshotPartitionId.isDefined() && snapshotStartBatchId.isEmpty()) {
                throw StateDataSourceErrors$.MODULE$.requiredOptionUnspecified(this.SNAPSHOT_START_BATCH_ID());
            }
            if (snapshotPartitionId.isEmpty() && snapshotStartBatchId.isDefined()) {
                throw StateDataSourceErrors$.MODULE$.requiredOptionUnspecified(this.SNAPSHOT_PARTITION_ID());
            }
            if (snapshotStartBatchId.isDefined() && snapshotPartitionId.isDefined()) {
                fromSnapshotOptions = new Some((Object)new FromSnapshotOptions(BoxesRunTime.unboxToLong((Object)snapshotStartBatchId.get()), BoxesRunTime.unboxToInt((Object)snapshotPartitionId.get())));
            }
        }
        long startBatchId = fromSnapshotOptions.isDefined() ? ((FromSnapshotOptions)fromSnapshotOptions.get()).snapshotStartBatchId() : (readChangeFeedOptions.isDefined() ? ((ReadChangeFeedOptions)readChangeFeedOptions.get()).changeStartBatchId() : BoxesRunTime.unboxToLong((Object)((Option)batchId.elem).get()));
        long endBatchId = readChangeFeedOptions.isDefined() ? ((ReadChangeFeedOptions)readChangeFeedOptions.get()).changeEndBatchId() : BoxesRunTime.unboxToLong((Object)((Option)batchId.elem).get());
        Option<String[][]> startOperatorStateUniqueIds = this.getOperatorStateUniqueIds(sparkSession, startBatchId, operatorId, resolvedCpLocation);
        Option<String[][]> option = endOperatorStateUniqueIds = startBatchId == endBatchId ? startOperatorStateUniqueIds : this.getOperatorStateUniqueIds(sparkSession, endBatchId, operatorId, resolvedCpLocation);
        if (startOperatorStateUniqueIds.isDefined() != endOperatorStateUniqueIds.isDefined()) {
            int startFormatVersion = startOperatorStateUniqueIds.isDefined() ? 2 : 1;
            int endFormatVersion = endOperatorStateUniqueIds.isDefined() ? 2 : 1;
            throw StateDataSourceErrors$.MODULE$.mixedCheckpointFormatVersionsNotSupported(startBatchId, endBatchId, startFormatVersion, endFormatVersion);
        }
        return new StateSourceOptions(resolvedCpLocation, BoxesRunTime.unboxToLong((Object)((Option)batchId.elem).get()), operatorId, storeName, joinSide, readChangeFeed, (Option<FromSnapshotOptions>)fromSnapshotOptions, (Option<ReadChangeFeedOptions>)readChangeFeedOptions, (Option<String>)stateVarName, readRegisteredTimers, flattenCollectionTypes, internalOnlyReadAllColumnFamilies, startOperatorStateUniqueIds, endOperatorStateUniqueIds);
    }

    public boolean apply$default$12() {
        return false;
    }

    public Option<String[][]> apply$default$13() {
        return None$.MODULE$;
    }

    public Option<String[][]> apply$default$14() {
        return None$.MODULE$;
    }

    private long getLastCommittedBatch(SparkSession session, String checkpointLocation) {
        Some some;
        Tuple2 tuple2;
        CommitLog commitLog = new StreamingQueryCheckpointMetadata(session, checkpointLocation).commitLog();
        Option option = commitLog.getLatest();
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            long lastId = tuple2._1$mcJ$sp();
            return lastId;
        }
        if (None$.MODULE$.equals(option)) {
            throw StateDataSourceErrors$.MODULE$.committedBatchUnavailable(checkpointLocation);
        }
        throw new MatchError(option);
    }

    private Option<String[][]> getOperatorStateUniqueIds(SparkSession session, long batchId, long operatorId, String checkpointLocation) {
        CommitLog commitLog = new StreamingQueryCheckpointMetadata(session, checkpointLocation).commitLog();
        Option option = commitLog.get(batchId);
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw StateDataSourceErrors$.MODULE$.committedBatchUnavailable(checkpointLocation);
            }
            throw new MatchError(option);
        }
        Some some = (Some)option;
        CommitMetadata commitMetadata = (CommitMetadata)some.value();
        CommitMetadata commitMetadata2 = commitMetadata;
        return commitMetadata2.stateUniqueIds().flatMap((Function1 & Serializable)x$19 -> x$19.get((Object)BoxesRunTime.boxToLong((long)operatorId)));
    }

    public StateSourceOptions modifySourceOptions(Configuration hadoopConf, StateSourceOptions sourceOptions) {
        String string = sourceOptions.storeName();
        String string2 = StateStoreId$.MODULE$.DEFAULT_STORE_NAME();
        if ((string == null ? string2 != null : !string.equals(string2)) && StreamStreamJoinStateHelper$.MODULE$.usesVirtualColumnFamilies(hadoopConf, sourceOptions.stateCheckpointLocation().toString(), sourceOptions.operatorId())) {
            Some x$1 = new Some((Object)sourceOptions.storeName());
            String x$2 = StateStoreId$.MODULE$.DEFAULT_STORE_NAME();
            String x$3 = sourceOptions.copy$default$1();
            long x$4 = sourceOptions.copy$default$2();
            int x$5 = sourceOptions.copy$default$3();
            Enumeration.Value x$6 = sourceOptions.copy$default$5();
            boolean x$7 = sourceOptions.copy$default$6();
            Option<FromSnapshotOptions> x$8 = sourceOptions.copy$default$7();
            Option<ReadChangeFeedOptions> x$9 = sourceOptions.copy$default$8();
            boolean x$10 = sourceOptions.copy$default$10();
            boolean x$11 = sourceOptions.copy$default$11();
            boolean x$12 = sourceOptions.copy$default$12();
            Option<String[][]> x$13 = sourceOptions.copy$default$13();
            Option<String[][]> x$14 = sourceOptions.copy$default$14();
            return sourceOptions.copy(x$3, x$4, x$5, x$2, x$6, x$7, x$8, x$9, (Option<String>)x$1, x$10, x$11, x$12, x$13, x$14);
        }
        return sourceOptions;
    }

    public StateSourceOptions apply(String resolvedCpLocation, long batchId, int operatorId, String storeName, Enumeration.Value joinSide, boolean readChangeFeed, Option<FromSnapshotOptions> fromSnapshotOptions, Option<ReadChangeFeedOptions> readChangeFeedOptions, Option<String> stateVarName, boolean readRegisteredTimers, boolean flattenCollectionTypes, boolean internalOnlyReadAllColumnFamilies, Option<String[][]> startOperatorStateUniqueIds, Option<String[][]> endOperatorStateUniqueIds) {
        return new StateSourceOptions(resolvedCpLocation, batchId, operatorId, storeName, joinSide, readChangeFeed, fromSnapshotOptions, readChangeFeedOptions, stateVarName, readRegisteredTimers, flattenCollectionTypes, internalOnlyReadAllColumnFamilies, startOperatorStateUniqueIds, endOperatorStateUniqueIds);
    }

    public Option<Tuple14<String, Object, Object, String, Enumeration.Value, Object, Option<FromSnapshotOptions>, Option<ReadChangeFeedOptions>, Option<String>, Object, Object, Object, Option<String[][]>, Option<String[][]>>> unapply(StateSourceOptions x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple14((Object)x$0.resolvedCpLocation(), (Object)BoxesRunTime.boxToLong((long)x$0.batchId()), (Object)BoxesRunTime.boxToInteger((int)x$0.operatorId()), (Object)x$0.storeName(), (Object)x$0.joinSide(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.readChangeFeed()), x$0.fromSnapshotOptions(), x$0.readChangeFeedOptions(), x$0.stateVarName(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.readRegisteredTimers()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.flattenCollectionTypes()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.internalOnlyReadAllColumnFamilies()), x$0.startOperatorStateUniqueIds(), x$0.endOperatorStateUniqueIds()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(StateSourceOptions$.class);
    }

    private StateSourceOptions$() {
    }
}

