/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.types;

import java.io.Serializable;
import org.apache.spark.SparkIllegalArgumentException;
import org.apache.spark.SparkRuntimeException;
import org.apache.spark.SparkRuntimeException$;
import org.apache.spark.annotation.Unstable;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.GeometryType$;
import org.json4s.JString;
import org.json4s.JValue;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@Unstable
@ScalaSignature(bytes="\u0006\u0005\u0005Me\u0001B\u0011#\u00015B\u0001\u0002\u0011\u0001\u0003\u0006\u0004%\t!\u0011\u0005\t\u0015\u0002\u0011\t\u0011)A\u0005\u0005\")1\n\u0001C\u0005\u0019\"9q\n\u0001b\u0001\n\u0003\u0001\u0006BB+\u0001A\u0003%\u0011\u000bC\u0003W\u0001\u0011\u0005\u0003\u000bC\u0003X\u0001\u0011\u0005\u0001\fC\u0003]\u0001\u0011\u0005\u0013\tC\u0003^\u0001\u0011\u0005c\fC\u0003`\u0001\u0011\u0005\u0003\r\u0003\u0004o\u0001\u0011\u0005ce\u001c\u0005\u0006a\u0002!\t%\u001d\u0005\u0006o\u0002!\t\u0005\u001f\u0005\u0007s\u0002!\t\u0005\n>\t\u000f\u0005\u0005\u0001\u0001\"\u0001\u0002\u0004!A\u0011\u0011\u0002\u0001\u0005\u0002\u0011\nYaB\u0004\u0002&\tB\t!a\n\u0007\r\u0005\u0012\u0003\u0012AA\u0015\u0011\u0019Y%\u0003\"\u0001\u0002F!I\u0011q\t\nC\u0002\u0013\u0015\u0011\u0011\n\u0005\t\u0003\u001f\u0012\u0002\u0015!\u0004\u0002L!I\u0011\u0011\u000b\nC\u0002\u0013\u0015\u00111\u000b\u0005\t\u00037\u0012\u0002\u0015!\u0004\u0002V!I\u0011Q\f\n\t\u0006\u0004%ia\u001c\u0005\b\u0003?\u0012B\u0011AA1\u0011\u001d\t)G\u0005C\u0001\u0003OBq!!\u001a\u0013\t\u0003\tY\u0007\u0003\u0005\u0002pI!\t\u0005JA9\u0011\u001dI(\u0003\"\u0011%\u0003gBq!a\u001e\u0013\t\u0003\"\u0013\t\u0003\u0005\u0002zI!\tAIA>\u0011%\tyHEA\u0001\n\u0013\t\tI\u0001\u0007HK>lW\r\u001e:z)f\u0004XM\u0003\u0002$I\u0005)A/\u001f9fg*\u0011QEJ\u0001\u0004gFd'BA\u0014)\u0003\u0015\u0019\b/\u0019:l\u0015\tI#&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002W\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\f\u001a\u0011\u0005=\u0002T\"\u0001\u0012\n\u0005E\u0012#AC!u_6L7\rV=qKB\u00111'\u0010\b\u0003iir!!\u000e\u001d\u000e\u0003YR!a\u000e\u0017\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0014!B:dC2\f\u0017BA\u001e=\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011!O\u0005\u0003}}\u0012AbU3sS\u0006d\u0017N_1cY\u0016T!a\u000f\u001f\u0002\u0007\r\u00148/F\u0001C!\t\u0019uI\u0004\u0002E\u000bB\u0011Q\u0007P\u0005\u0003\rr\na\u0001\u0015:fI\u00164\u0017B\u0001%J\u0005\u0019\u0019FO]5oO*\u0011a\tP\u0001\u0005GJ\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\u0003\u001b:\u0003\"a\f\u0001\t\u000b\u0001\u001b\u0001\u0019\u0001\"\u0002\tM\u0014\u0018\u000eZ\u000b\u0002#B\u0011!kU\u0007\u0002y%\u0011A\u000b\u0010\u0002\u0004\u0013:$\u0018!B:sS\u0012\u0004\u0013a\u00033fM\u0006,H\u000e^*ju\u0016\f1\"[:NSb,Gm\u0015:jIV\t\u0011\f\u0005\u0002S5&\u00111\f\u0010\u0002\b\u0005>|G.Z1o\u0003!!\u0018\u0010]3OC6,\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003\t\u000b\u0011B[:p]Z\u000bG.^3\u0016\u0003\u0005\u0004\"AY6\u000f\u0005\rDgB\u00013g\u001d\t)T-C\u0001,\u0013\t9'&\u0001\u0004kg>tGg]\u0005\u0003S*\fqAS:p]\u0006\u001bFK\u0003\u0002hU%\u0011A.\u001c\u0002\u0007\u0015Z\u000bG.^3\u000b\u0005%T\u0017AC1t\u001dVdG.\u00192mKV\tQ*\u0001\u0004fcV\fGn\u001d\u000b\u00033JDQa\u001d\u0007A\u0002Q\f1a\u001c2k!\t\u0011V/\u0003\u0002wy\t\u0019\u0011I\\=\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012!U\u0001\fC\u000e\u001cW\r\u001d;t)f\u0004X\r\u0006\u0002Zw\")AP\u0004a\u0001{\u0006)q\u000e\u001e5feB\u0011qF`\u0005\u0003\u007f\n\u0012\u0001\u0002R1uCRK\b/Z\u0001\u0014C\u000e\u001cW\r\u001d;t\u000f\u0016|W.\u001a;ssRK\b/\u001a\u000b\u00043\u0006\u0015\u0001BBA\u0004\u001f\u0001\u0007Q*\u0001\u0002hi\u0006A\u0012m]:feR\u001c&/\u001b3BY2|w/\u001a3G_J$\u0016\u0010]3\u0015\t\u00055\u00111\u0003\t\u0004%\u0006=\u0011bAA\ty\t!QK\\5u\u0011\u0019\t)\u0002\u0005a\u0001#\u0006Iq\u000e\u001e5feN\u0013\u0018\u000e\u001a\u0015\u0004\u0001\u0005e\u0001\u0003BA\u000e\u0003Ci!!!\b\u000b\u0007\u0005}a%\u0001\u0006b]:|G/\u0019;j_:LA!a\t\u0002\u001e\tAQK\\:uC\ndW-\u0001\u0007HK>lW\r\u001e:z)f\u0004X\r\u0005\u00020%M9!#a\u000b\u00022\u0005]\u0002cA\u0018\u0002.%\u0019\u0011q\u0006\u0012\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0007cA\u0018\u00024%\u0019\u0011Q\u0007\u0012\u0003\u0017M\u0003\u0018\r^5bYRK\b/\u001a\t\u0005\u0003s\t\u0019%\u0004\u0002\u0002<)!\u0011QHA \u0003\tIwN\u0003\u0002\u0002B\u0005!!.\u0019<b\u0013\rq\u00141\b\u000b\u0003\u0003O\tQcR#P\u001b\u0016#&+W0E\u000b\u001a\u000bU\u000b\u0014+`'JKE)\u0006\u0002\u0002L=\u0011\u0011QJ\u000f\u0003!\u0019\u0010acR#P\u001b\u0016#&+W0E\u000b\u001a\u000bU\u000b\u0014+`'JKE\tI\u0001\u0015\u000f\u0016{U*\u0012+S3~#UIR!V\u0019R{6IU*\u0016\u0005\u0005UsBAA,C\t\tI&A\u0005P\u000f\u000eS4IU*9i\u0005)r)R(N\u000bR\u0013\u0016l\u0018#F\r\u0006+F\nV0D%N\u0003\u0013aE$F\u001f6+EKU-`\u001b&CV\tR0U3B+\u0015aD5t'JLGmU;qa>\u0014H/\u001a3\u0015\u0007e\u000b\u0019\u0007C\u0003P3\u0001\u0007\u0011+A\u0003baBd\u0017\u0010F\u0002N\u0003SBQa\u0014\u000eA\u0002E#2!TA7\u0011\u0015\u00015\u00041\u0001C\u0003M!WMZ1vYR\u001cuN\\2sKR,G+\u001f9f+\u0005iHcA-\u0002v!)A0\ba\u0001{\u0006a1/[7qY\u0016\u001cFO]5oO\u00061Ao\\*sS\u0012$2!UA?\u0011\u0015\u0001u\u00041\u0001C\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\t\u0019\t\u0005\u0003\u0002\u0006\u0006-UBAAD\u0015\u0011\tI)a\u0010\u0002\t1\fgnZ\u0005\u0005\u0003\u001b\u000b9I\u0001\u0004PE*,7\r\u001e\u0015\u0004%\u0005e\u0001fA\t\u0002\u001a\u0001")
public class GeometryType
extends AtomicType
implements Serializable {
    private final String crs;
    private final int srid;

    public static GeometryType apply(String crs) {
        return GeometryType$.MODULE$.apply(crs);
    }

    public static GeometryType apply(int srid) {
        return GeometryType$.MODULE$.apply(srid);
    }

    public static boolean isSridSupported(int srid) {
        return GeometryType$.MODULE$.isSridSupported(srid);
    }

    public static String GEOMETRY_DEFAULT_CRS() {
        return GeometryType$.MODULE$.GEOMETRY_DEFAULT_CRS();
    }

    public static int GEOMETRY_DEFAULT_SRID() {
        return GeometryType$.MODULE$.GEOMETRY_DEFAULT_SRID();
    }

    public static String MIXED_CRS() {
        return GeometryType$.MODULE$.MIXED_CRS();
    }

    public static int MIXED_SRID() {
        return GeometryType$.MODULE$.MIXED_SRID();
    }

    public String crs() {
        return this.crs;
    }

    public int srid() {
        return this.srid;
    }

    @Override
    public int defaultSize() {
        return 2048;
    }

    public boolean isMixedSrid() {
        return this.srid() == GeometryType$.MODULE$.MIXED_SRID();
    }

    @Override
    public String typeName() {
        if (this.isMixedSrid()) {
            return "geometry(any)";
        }
        return "geometry(" + this.srid() + ")";
    }

    public String toString() {
        if (this.isMixedSrid()) {
            return "GeometryType(ANY)";
        }
        return "GeometryType(" + this.srid() + ")";
    }

    @Override
    public JValue jsonValue() {
        return new JString("geometry(" + this.crs() + ")");
    }

    @Override
    public GeometryType asNullable() {
        return this;
    }

    public boolean equals(Object obj) {
        Object object = obj;
        if (object instanceof GeometryType) {
            GeometryType geometryType = (GeometryType)object;
            return geometryType.srid() == this.srid();
        }
        return false;
    }

    public int hashCode() {
        return Integer.hashCode(this.srid());
    }

    @Override
    public boolean acceptsType(DataType other) {
        DataType dataType = other;
        if (dataType instanceof GeometryType) {
            GeometryType geometryType = (GeometryType)dataType;
            return this.acceptsGeometryType(geometryType);
        }
        return false;
    }

    public boolean acceptsGeometryType(GeometryType gt) {
        return this.isMixedSrid() || gt.srid() == this.srid();
    }

    public void assertSridAllowedForType(int otherSrid) {
        if (!this.isMixedSrid() && otherSrid != this.srid()) {
            throw new SparkRuntimeException("GEO_ENCODER_SRID_MISMATCH_ERROR", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)"GEOMETRY"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"valueSrid"), (Object)Integer.toString(otherSrid)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"typeSrid"), (Object)Integer.toString(this.srid()))})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
        }
        if (this.isMixedSrid()) {
            if (!GeometryType$.MODULE$.isSridSupported(otherSrid)) {
                throw new SparkIllegalArgumentException("ST_INVALID_SRID_VALUE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"srid"), (Object)Integer.toString(otherSrid))})));
            }
            return;
        }
    }

    public GeometryType(String crs) {
        this.crs = crs;
        this.srid = GeometryType$.MODULE$.toSrid(crs);
    }
}

