/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.pipelines.graph;

import java.io.Serializable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.pipelines.graph.DataflowGraph;
import org.apache.spark.sql.pipelines.graph.Flow;
import org.apache.spark.sql.pipelines.graph.FlowFunction;
import org.apache.spark.sql.pipelines.graph.GraphRegistrationContext$SinkType$;
import org.apache.spark.sql.pipelines.graph.GraphRegistrationContext$TableType$;
import org.apache.spark.sql.pipelines.graph.GraphRegistrationContext$ViewType$;
import org.apache.spark.sql.pipelines.graph.PersistedView;
import org.apache.spark.sql.pipelines.graph.QueryContext;
import org.apache.spark.sql.pipelines.graph.QueryOrigin;
import org.apache.spark.sql.pipelines.graph.Sink;
import org.apache.spark.sql.pipelines.graph.Table;
import org.apache.spark.sql.pipelines.graph.UnresolvedFlow;
import org.apache.spark.sql.pipelines.graph.View;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dg\u0001B\u0016-\u0001eB\u0001\u0002\u0011\u0001\u0003\u0006\u0004%\t!\u0011\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u0005\"Aa\n\u0001BC\u0002\u0013\u0005\u0011\t\u0003\u0005P\u0001\t\u0005\t\u0015!\u0003C\u0011!\u0001\u0006A!b\u0001\n\u0003\t\u0006\u0002C+\u0001\u0005\u0003\u0005\u000b\u0011\u0002*\t\u000bY\u0003A\u0011A,\t\u000fu\u0003!\u0019!C\t=\"1!\u000e\u0001Q\u0001\n}Cqa\u001b\u0001C\u0002\u0013EA\u000e\u0003\u0004r\u0001\u0001\u0006I!\u001c\u0005\be\u0002\u0011\r\u0011\"\u0005t\u0011\u0019A\b\u0001)A\u0005i\"9\u0011\u0010\u0001b\u0001\n#Q\bBB@\u0001A\u0003%1\u0010C\u0004\u0002\u0002\u0001!\t!a\u0001\t\u000f\u0005=\u0001\u0001\"\u0001\u0002\u0012!9\u0011q\u0003\u0001\u0005\u0002\u0005e\u0001bBA\u0010\u0001\u0011\u0005\u0011\u0011\u0005\u0005\b\u0003k\u0001A\u0011AA\u001c\u0011\u001d\tY\u0004\u0001C\u0001\u0003{Aq!a\u0011\u0001\t\u0013\t)\u0005C\u0004\u0002N\u0001!\t!a\u0014\t\u000f\u0005]\u0003\u0001\"\u0003\u0002Z!9\u0011q\u000e\u0001\u0005\n\u0005E\u0004bBAE\u0001\u0011%\u00111R\u0004\b\u0003'c\u0003\u0012AAK\r\u0019YC\u0006#\u0001\u0002\u0018\"1a\u000b\bC\u0001\u000333\u0011\"a'\u001d!\u0003\r\n#!(\b\u000f\u0005\u0005G\u0004#\u0003\u00028\u001a9\u0011\u0011\u0017\u000f\t\n\u0005M\u0006B\u0002,!\t\u0003\t)\fC\u0004\u0002.\u0002\"\t%a,\b\u000f\u0005\rG\u0004#\u0003\u0002@\u001a9\u0011\u0011\u0018\u000f\t\n\u0005m\u0006B\u0002,%\t\u0003\ti\fC\u0004\u0002.\u0012\"\t%a,\b\u000f\u0005\u0015G\u0004#\u0003\u0002,\u001a9\u0011\u0011\u0015\u000f\t\n\u0005\r\u0006B\u0002,)\t\u0003\tI\u000bC\u0004\u0002.\"\"\t%a,\u00031\u001d\u0013\u0018\r\u001d5SK\u001eL7\u000f\u001e:bi&|gnQ8oi\u0016DHO\u0003\u0002.]\u0005)qM]1qQ*\u0011q\u0006M\u0001\na&\u0004X\r\\5oKNT!!\r\u001a\u0002\u0007M\fHN\u0003\u00024i\u0005)1\u000f]1sW*\u0011QGN\u0001\u0007CB\f7\r[3\u000b\u0003]\n1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u001e\u0011\u0005mrT\"\u0001\u001f\u000b\u0003u\nQa]2bY\u0006L!a\u0010\u001f\u0003\r\u0005s\u0017PU3g\u00039!WMZ1vYR\u001c\u0015\r^1m_\u001e,\u0012A\u0011\t\u0003\u0007*s!\u0001\u0012%\u0011\u0005\u0015cT\"\u0001$\u000b\u0005\u001dC\u0014A\u0002\u001fs_>$h(\u0003\u0002Jy\u00051\u0001K]3eK\u001aL!a\u0013'\u0003\rM#(/\u001b8h\u0015\tIE(A\beK\u001a\fW\u000f\u001c;DCR\fGn\\4!\u0003=!WMZ1vYR$\u0015\r^1cCN,\u0017\u0001\u00053fM\u0006,H\u000e\u001e#bi\u0006\u0014\u0017m]3!\u00039!WMZ1vYR\u001c\u0016\u000f\\\"p]\u001a,\u0012A\u0015\t\u0005\u0007N\u0013%)\u0003\u0002U\u0019\n\u0019Q*\u00199\u0002\u001f\u0011,g-Y;miN\u000bHnQ8oM\u0002\na\u0001P5oSRtD\u0003\u0002-[7r\u0003\"!\u0017\u0001\u000e\u00031BQ\u0001Q\u0004A\u0002\tCQAT\u0004A\u0002\tCQ\u0001U\u0004A\u0002I\u000ba\u0001^1cY\u0016\u001cX#A0\u0011\u0007\u0001,w-D\u0001b\u0015\t\u00117-A\u0004nkR\f'\r\\3\u000b\u0005\u0011d\u0014AC2pY2,7\r^5p]&\u0011a-\u0019\u0002\u000b\u0019&\u001cHOQ;gM\u0016\u0014\bCA-i\u0013\tIGFA\u0003UC\ndW-A\u0004uC\ndWm\u001d\u0011\u0002\u000bYLWm^:\u0016\u00035\u00042\u0001Y3o!\tIv.\u0003\u0002qY\t!a+[3x\u0003\u00191\u0018.Z<tA\u0005)1/\u001b8lgV\tA\u000fE\u0002aKV\u0004\"!\u0017<\n\u0005]d#\u0001B*j].\faa]5oWN\u0004\u0013!\u00024m_^\u001cX#A>\u0011\u0007\u0001,G\u0010\u0005\u0002Z{&\u0011a\u0010\f\u0002\u000f+:\u0014Xm]8mm\u0016$g\t\\8x\u0003\u00191Gn\\<tA\u0005i!/Z4jgR,'\u000fV1cY\u0016$B!!\u0002\u0002\fA\u00191(a\u0002\n\u0007\u0005%AH\u0001\u0003V]&$\bBBA\u0007!\u0001\u0007q-\u0001\u0005uC\ndW\rR3g\u00031\u0011XmZ5ti\u0016\u0014h+[3x)\u0011\t)!a\u0005\t\r\u0005U\u0011\u00031\u0001o\u0003\u001d1\u0018.Z<EK\u001a\fAB]3hSN$XM]*j].$B!!\u0002\u0002\u001c!1\u0011Q\u0004\nA\u0002U\fqa]5oW\u0012+g-\u0001\u0005hKR4\u0016.Z<t+\t\t\u0019\u0003E\u0003\u0002&\u0005=bN\u0004\u0003\u0002(\u0005-bbA#\u0002*%\tQ(C\u0002\u0002.q\nq\u0001]1dW\u0006<W-\u0003\u0003\u00022\u0005M\"aA*fc*\u0019\u0011Q\u0006\u001f\u0002\u0011\u001d,GoU5oWN,\"!!\u000f\u0011\u000b\u0005\u0015\u0012qF;\u0002\u0019I,w-[:uKJ4En\\<\u0015\t\u0005\u0015\u0011q\b\u0005\u0007\u0003\u0003*\u0002\u0019\u0001?\u0002\u000f\u0019dwn\u001e#fM\u00069\u0011n]#naRLXCAA$!\rY\u0014\u0011J\u0005\u0004\u0003\u0017b$a\u0002\"p_2,\u0017M\\\u0001\u0010i>$\u0015\r^1gY><xI]1qQV\u0011\u0011\u0011\u000b\t\u00043\u0006M\u0013bAA+Y\tiA)\u0019;bM2|wo\u0012:ba\"\f!#Y:tKJ$hj\u001c#va2L7-\u0019;fgRQ\u0011QAA.\u0003C\n)'!\u001b\t\u000f\u0005u\u0003\u00041\u0001\u0002`\u0005y\u0011/^1mS\u001aLW\r\u001a+bE2,7\u000fE\u0003\u0002&\u0005=r\rC\u0004\u0002da\u0001\r!a\t\u0002\u001dY\fG.\u001b3bi\u0016$g+[3xg\"9\u0011q\r\rA\u0002\u0005e\u0012A\u0004<bY&$\u0017\r^3e'&t7n\u001d\u0005\b\u0003WB\u0002\u0019AA7\u00039\tX/\u00197jM&,GM\u00127poN\u0004R!!\n\u00020q\fa$Y:tKJ$x*\u001e;qkRLE-\u001a8uS\u001aLWM]%t+:L\u0017/^3\u0015\u0015\u0005\u0015\u00111OAB\u0003\u000b\u000b9\tC\u0004\u0002ve\u0001\r!a\u001e\u0002\u0015%$WM\u001c;jM&,'\u000f\u0005\u0003\u0002z\u0005}TBAA>\u0015\r\ti\bM\u0001\tG\u0006$\u0018\r\\=ti&!\u0011\u0011QA>\u0005=!\u0016M\u00197f\u0013\u0012,g\u000e^5gS\u0016\u0014\bBB/\u001a\u0001\u0004\ty\u0006\u0003\u0004s3\u0001\u0007\u0011\u0011\b\u0005\u0007Wf\u0001\r!a\t\u00029\u0005\u001c8/\u001a:u\r2|w/\u00133f]RLg-[3s\u0013N,f.[9vKR1\u0011QAAG\u0003#Ca!a$\u001b\u0001\u0004a\u0018\u0001\u00024m_^Da!\u001f\u000eA\u0002\u00055\u0014\u0001G$sCBD'+Z4jgR\u0014\u0018\r^5p]\u000e{g\u000e^3yiB\u0011\u0011\fH\n\u00039i\"\"!!&\u0003\u0015=+H\u000f];u)f\u0004Xm\u0005\u0002\u001fu%\"a\u0004\u000b\u0011%\u0005!\u0019\u0016N\\6UsB,7\u0003\u0002\u0015;\u0003K\u00032!a*\u001f\u001b\u0005aBCAAV!\r\t9\u000bK\u0001\ti>\u001cFO]5oOR\t!IA\u0005UC\ndW\rV=qKN!\u0001EOAS)\t\t9\fE\u0002\u0002(\u0002\u0012\u0001BV5foRK\b/Z\n\u0005Ii\n)\u000b\u0006\u0002\u0002@B\u0019\u0011q\u0015\u0013\u0002\u0013Q\u000b'\r\\3UsB,\u0017\u0001\u0003,jK^$\u0016\u0010]3\u0002\u0011MKgn\u001b+za\u0016\u0004")
public class GraphRegistrationContext {
    private final String defaultCatalog;
    private final String defaultDatabase;
    private final Map<String, String> defaultSqlConf;
    private final ListBuffer<Table> tables;
    private final ListBuffer<View> views;
    private final ListBuffer<Sink> sinks;
    private final ListBuffer<UnresolvedFlow> flows;

    public String defaultCatalog() {
        return this.defaultCatalog;
    }

    public String defaultDatabase() {
        return this.defaultDatabase;
    }

    public Map<String, String> defaultSqlConf() {
        return this.defaultSqlConf;
    }

    public ListBuffer<Table> tables() {
        return this.tables;
    }

    public ListBuffer<View> views() {
        return this.views;
    }

    public ListBuffer<Sink> sinks() {
        return this.sinks;
    }

    public ListBuffer<UnresolvedFlow> flows() {
        return this.flows;
    }

    public void registerTable(Table tableDef) {
        this.tables().$plus$eq((Object)tableDef);
    }

    public void registerView(View viewDef) {
        this.views().$plus$eq((Object)viewDef);
    }

    public void registerSink(Sink sinkDef) {
        this.sinks().$plus$eq((Object)sinkDef);
    }

    public Seq<View> getViews() {
        return this.views().toSeq();
    }

    public Seq<Sink> getSinks() {
        return this.sinks().toSeq();
    }

    public void registerFlow(UnresolvedFlow flowDef) {
        Map x$1 = (Map)this.defaultSqlConf().$plus$plus(flowDef.sqlConf());
        TableIdentifier x$2 = flowDef.copy$default$1();
        TableIdentifier x$3 = flowDef.copy$default$2();
        FlowFunction x$4 = flowDef.copy$default$3();
        QueryContext x$5 = flowDef.copy$default$4();
        boolean x$6 = flowDef.copy$default$6();
        QueryOrigin x$7 = flowDef.copy$default$7();
        this.flows().$plus$eq((Object)flowDef.copy(x$2, x$3, x$4, x$5, (Map<String, String>)x$1, x$6, x$7));
    }

    private boolean isEmpty() {
        return this.tables().isEmpty() && ((ListBuffer)this.views().collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends View, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof PersistedView) {
                    PersistedView persistedView = (PersistedView)A1;
                    return (B1)persistedView;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(View x1) {
                View view = x1;
                return view instanceof PersistedView;
            }
        })).isEmpty() && this.sinks().isEmpty();
    }

    public DataflowGraph toDataflowGraph() {
        if (this.isEmpty()) {
            throw new AnalysisException("RUN_EMPTY_PIPELINE", Predef$.MODULE$.Map().empty());
        }
        Seq x$1 = this.tables().toSeq();
        Seq x$2 = this.views().toSeq();
        Seq x$3 = this.flows().toSeq();
        Seq x$4 = this.sinks().toSeq();
        this.assertNoDuplicates((Seq<Table>)x$1, (Seq<View>)x$2, (Seq<Sink>)x$4, (Seq<UnresolvedFlow>)x$3);
        Seq x$5 = this.tables().toSeq();
        Seq x$6 = this.views().toSeq();
        Seq x$7 = this.sinks().toSeq();
        Seq x$8 = this.flows().toSeq();
        return new DataflowGraph((Seq<Flow>)x$8, (Seq<Table>)x$5, (Seq<Sink>)x$7, (Seq<View>)x$6);
    }

    private void assertNoDuplicates(Seq<Table> qualifiedTables, Seq<View> validatedViews, Seq<Sink> validatedSinks, Seq<UnresolvedFlow> qualifiedFlows) {
        ((IterableOnceOps)((IterableOps)qualifiedTables.map((Function1 & Serializable)x$1 -> x$1.identifier())).$plus$plus((IterableOnce)validatedViews.map((Function1 & Serializable)x$2 -> x$2.identifier()))).foreach((Function1 & Serializable)identifier -> {
            this.assertOutputIdentifierIsUnique(identifier, (Seq<Table>)qualifiedTables, (Seq<Sink>)validatedSinks, (Seq<View>)validatedViews);
            return BoxedUnit.UNIT;
        });
        qualifiedFlows.foreach((Function1 & Serializable)flow -> {
            this.assertFlowIdentifierIsUnique(flow, (Seq<UnresolvedFlow>)qualifiedFlows);
            return BoxedUnit.UNIT;
        });
    }

    private void assertOutputIdentifierIsUnique(TableIdentifier identifier, Seq<Table> tables, Seq<Sink> sinks, Seq<View> views) {
        Seq allOutputs = (Seq)((IterableOps)((IterableOps)tables.map((Function1 & Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t.identifier()), (Object)GraphRegistrationContext$TableType$.MODULE$))).$plus$plus((IterableOnce)views.map((Function1 & Serializable)v -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)v.identifier()), (Object)GraphRegistrationContext$ViewType$.MODULE$)))).$plus$plus((IterableOnce)sinks.map((Function1 & Serializable)s -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)s.identifier()), (Object)GraphRegistrationContext$SinkType$.MODULE$)));
        Map grouped = allOutputs.groupBy((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                TableIdentifier id = (TableIdentifier)tuple2._1();
                return id;
            }
            throw new MatchError((Object)tuple2);
        });
        List list = ((IterableOnceOps)grouped.apply((Object)identifier)).toList();
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            Tuple2 tuple2 = (Tuple2)colon2.head();
            List list2 = colon2.next$access$1();
            if (tuple2 != null) {
                .colon.colon colon3;
                Tuple2 tuple22;
                OutputType firstType = (OutputType)tuple2._2();
                if (list2 instanceof .colon.colon && (tuple22 = (Tuple2)(colon3 = (.colon.colon)list2).head()) != null) {
                    OutputType secondType = (OutputType)tuple22._2();
                    Seq sortedTypes = (Seq)new .colon.colon((Object)firstType.toString(), (List)new .colon.colon((Object)secondType.toString(), (List)Nil$.MODULE$)).sorted((Ordering)Ordering.String$.MODULE$);
                    throw new AnalysisException("PIPELINE_DUPLICATE_IDENTIFIERS.OUTPUT", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"outputName"), (Object)identifier.quotedString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"outputType1"), sortedTypes.head()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"outputType2"), sortedTypes.last())})));
                }
            }
        }
    }

    private void assertFlowIdentifierIsUnique(UnresolvedFlow flow, Seq<UnresolvedFlow> flows) {
        flows.groupBy((Function1 & Serializable)i -> i.identifier()).get((Object)flow.identifier()).filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)GraphRegistrationContext.$anonfun$assertFlowIdentifierIsUnique$2(x$3))).foreach((Function1 & Serializable)duplicateFlows -> {
            UnresolvedFlow duplicateFlow = (UnresolvedFlow)((IterableOps)duplicateFlows.filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)GraphRegistrationContext.$anonfun$assertFlowIdentifierIsUnique$4(flow, x$4)))).head();
            throw new AnalysisException("PIPELINE_DUPLICATE_IDENTIFIERS.FLOW", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"flowName"), (Object)flow.identifier().unquotedString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"datasetNames"), (Object)((IterableOnceOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{flow.destinationIdentifier().quotedString(), duplicateFlow.destinationIdentifier().quotedString()}))).mkString(","))})));
        });
    }

    public static final /* synthetic */ boolean $anonfun$assertFlowIdentifierIsUnique$2(Seq x$3) {
        return x$3.size() > 1;
    }

    public static final /* synthetic */ boolean $anonfun$assertFlowIdentifierIsUnique$4(UnresolvedFlow flow$1, UnresolvedFlow x$4) {
        UnresolvedFlow unresolvedFlow = x$4;
        UnresolvedFlow unresolvedFlow2 = flow$1;
        return unresolvedFlow == null ? unresolvedFlow2 != null : !((Object)unresolvedFlow).equals(unresolvedFlow2);
    }

    public GraphRegistrationContext(String defaultCatalog, String defaultDatabase, Map<String, String> defaultSqlConf) {
        this.defaultCatalog = defaultCatalog;
        this.defaultDatabase = defaultDatabase;
        this.defaultSqlConf = defaultSqlConf;
        this.tables = new ListBuffer();
        this.views = new ListBuffer();
        this.sinks = new ListBuffer();
        this.flows = new ListBuffer();
    }

    public static interface OutputType {
    }
}

