/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.parquet.InferVariantShreddingSchema;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOutputWriter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport$;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005-d\u0001B\u000f\u001f\u00015B\u0001B\r\u0001\u0003\u0006\u0004%\ta\r\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005i!A!\t\u0001B\u0001B\u0003%1\t\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003M\u0011!\u0001\u0006A!b\u0001\n\u0003\t\u0006\u0002\u0003,\u0001\u0005\u0003\u0005\u000b\u0011\u0002*\t\u000b]\u0003A\u0011\u0001-\t\u000fy\u0003\u0001\u0019!C\u0005?\"9a\r\u0001a\u0001\n\u00139\u0007BB7\u0001A\u0003&\u0001\rC\u0004o\u0001\u0001\u0007I\u0011B8\t\u000fe\u0004\u0001\u0019!C\u0005u\"1A\u0010\u0001Q!\nADq! \u0001C\u0002\u0013%a\u0010C\u0004\u0002\u001c\u0001\u0001\u000b\u0011B@\t\u0013\u0005u\u0001\u00011A\u0005\n\u0005}\u0001\"CA\u0014\u0001\u0001\u0007I\u0011BA\u0015\u0011!\ti\u0003\u0001Q!\n\u0005\u0005\u0002BCA\u0018\u0001!\u0015\r\u0011\"\u0003\u00022!I\u0011q\b\u0001C\u0002\u0013%\u0011q\u0004\u0005\t\u0003\u0003\u0002\u0001\u0015!\u0003\u0002\"!I\u00111\t\u0001C\u0002\u0013%\u0011Q\t\u0005\t\u0003\u001b\u0002\u0001\u0015!\u0003\u0002H!9\u0011q\n\u0001\u0005\n\u0005E\u0003BBA*\u0001\u0011\u0005q\u000eC\u0004\u0002V\u0001!I!a\u0016\t\u000f\u0005\r\u0004\u0001\"\u0011\u0002f!9\u0011\u0011\u000e\u0001\u0005B\u0005E#a\n)beF,X\r^(viB,Ho\u0016:ji\u0016\u0014x+\u001b;i-\u0006\u0014\u0018.\u00198u'\"\u0014X\r\u001a3j]\u001eT!a\b\u0011\u0002\u000fA\f'/];fi*\u0011\u0011EI\u0001\fI\u0006$\u0018m]8ve\u000e,7O\u0003\u0002$I\u0005IQ\r_3dkRLwN\u001c\u0006\u0003K\u0019\n1a]9m\u0015\t9\u0003&A\u0003ta\u0006\u00148N\u0003\u0002*U\u00051\u0011\r]1dQ\u0016T\u0011aK\u0001\u0004_J<7\u0001A\n\u0003\u00019\u0002\"a\f\u0019\u000e\u0003\u0001J!!\r\u0011\u0003\u0019=+H\u000f];u/JLG/\u001a:\u0002\tA\fG\u000f[\u000b\u0002iA\u0011QG\u0010\b\u0003mq\u0002\"a\u000e\u001e\u000e\u0003aR!!\u000f\u0017\u0002\rq\u0012xn\u001c;?\u0015\u0005Y\u0014!B:dC2\f\u0017BA\u001f;\u0003\u0019\u0001&/\u001a3fM&\u0011q\b\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005uR\u0014!\u00029bi\"\u0004\u0013aB2p]R,\u0007\u0010\u001e\t\u0003\t&k\u0011!\u0012\u0006\u0003\r\u001e\u000b\u0011\"\\1qe\u0016$WoY3\u000b\u0005!C\u0013A\u00025bI>|\u0007/\u0003\u0002K\u000b\n\u0011B+Y:l\u0003R$X-\u001c9u\u0007>tG/\u001a=u\u0003=IgNZ3sK:\u001cW\rS3ma\u0016\u0014\bCA'O\u001b\u0005q\u0012BA(\u001f\u0005mIeNZ3s-\u0006\u0014\u0018.\u00198u'\"\u0014X\r\u001a3j]\u001e\u001c6\r[3nC\u00069\u0012n]*ie\u0016$G-\u001b8h'\u000eDW-\\1G_J\u001cW\rZ\u000b\u0002%B\u00111\u000bV\u0007\u0002u%\u0011QK\u000f\u0002\b\u0005>|G.Z1o\u0003aI7o\u00155sK\u0012$\u0017N\\4TG\",W.\u0019$pe\u000e,G\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000beS6\fX/\u0011\u00055\u0003\u0001\"\u0002\u001a\b\u0001\u0004!\u0004\"\u0002\"\b\u0001\u0004\u0019\u0005\"B&\b\u0001\u0004a\u0005\"\u0002)\b\u0001\u0004\u0011\u0016a\u00059beF,X\r^(viB,Ho\u0016:ji\u0016\u0014X#\u00011\u0011\u0007M\u000b7-\u0003\u0002cu\t1q\n\u001d;j_:\u0004\"!\u00143\n\u0005\u0015t\"a\u0005)beF,X\r^(viB,Ho\u0016:ji\u0016\u0014\u0018a\u00069beF,X\r^(viB,Ho\u0016:ji\u0016\u0014x\fJ3r)\tA7\u000e\u0005\u0002TS&\u0011!N\u000f\u0002\u0005+:LG\u000fC\u0004m\u0013\u0005\u0005\t\u0019\u00011\u0002\u0007a$\u0013'\u0001\u000bqCJ\fX/\u001a;PkR\u0004X\u000f^,sSR,'\u000fI\u0001\rY\u0006$Xm\u001d;G_>$XM]\u000b\u0002aB\u00191+Y9\u0011\u0005I<X\"A:\u000b\u0005Q,\u0018\u0001C7fi\u0006$\u0017\r^1\u000b\u0005!3(BA\u0010)\u0013\tA8OA\bQCJ\fX/\u001a;NKR\fG-\u0019;b\u0003Aa\u0017\r^3ti\u001a{w\u000e^3s?\u0012*\u0017\u000f\u0006\u0002iw\"9A\u000eDA\u0001\u0002\u0004\u0001\u0018!\u00047bi\u0016\u001cHOR8pi\u0016\u0014\b%\u0001\u0003s_^\u001cX#A@\u0011\r\u0005\u0005\u00111BA\b\u001b\t\t\u0019A\u0003\u0003\u0002\u0006\u0005\u001d\u0011aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003\u0013Q\u0014AC2pY2,7\r^5p]&!\u0011QBA\u0002\u0005\u0019\u0011UO\u001a4feB!\u0011\u0011CA\f\u001b\t\t\u0019BC\u0002\u0002\u0016\u0011\n\u0001bY1uC2L8\u000f^\u0005\u0005\u00033\t\u0019BA\u0006J]R,'O\\1m%><\u0018!\u0002:poN\u0004\u0013\u0001\u00042vM\u001a,'/\u001a3TSj,WCAA\u0011!\r\u0019\u00161E\u0005\u0004\u0003KQ$\u0001\u0002'p]\u001e\f\u0001CY;gM\u0016\u0014X\rZ*ju\u0016|F%Z9\u0015\u0007!\fY\u0003\u0003\u0005m#\u0005\u0005\t\u0019AA\u0011\u00035\u0011WO\u001a4fe\u0016$7+\u001b>fA\u0005YAo\\+og\u00064WMU8x+\t\t\u0019\u0004\u0005\u0003\u00026\u0005mRBAA\u001c\u0015\u0011\tI$a\u0005\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0005\u0003{\t9D\u0001\tV]N\fg-\u001a)s_*,7\r^5p]\u0006iQ.\u0019=Ck\u001a4WM]*ju\u0016\fa\"\\1y\u0005V4g-\u001a:TSj,\u0007%A\u0007nCb\u0014UO\u001a4feJ{wo]\u000b\u0003\u0003\u000f\u00022aUA%\u0013\r\tYE\u000f\u0002\u0004\u0013:$\u0018AD7bq\n+hMZ3s%><8\u000fI\u0001\u0017M&t\u0017\r\\5{KN\u001b\u0007.Z7b\u0003:$g\t\\;tQR\t\u0001.\u0001\nhKRd\u0015\r^3ti\u001a{w\u000e^3s\u001fB$\u0018!D:u_B\u0014UO\u001a4fe&tw\rF\u0002S\u00033Bq!a\u0017\u001b\u0001\u0004\ti&A\u0002s_^\u0004B!!\u000e\u0002`%!\u0011\u0011MA\u001c\u0005%)fn]1gKJ{w/A\u0003xe&$X\rF\u0002i\u0003OBq!a\u0017\u001c\u0001\u0004\ty!A\u0003dY>\u001cX\r")
public class ParquetOutputWriterWithVariantShredding
extends OutputWriter {
    private UnsafeProjection toUnsafeRow;
    private final String path;
    private final TaskAttemptContext context;
    private final InferVariantShreddingSchema inferenceHelper;
    private final boolean isShreddingSchemaForced;
    private Option<ParquetOutputWriter> parquetOutputWriter;
    private Option<ParquetMetadata> latestFooter;
    private final Buffer<InternalRow> rows;
    private long bufferedSize;
    private final long maxBufferSize;
    private final int maxBufferRows;
    private volatile boolean bitmap$0;

    @Override
    public String path() {
        return this.path;
    }

    public boolean isShreddingSchemaForced() {
        return this.isShreddingSchemaForced;
    }

    private Option<ParquetOutputWriter> parquetOutputWriter() {
        return this.parquetOutputWriter;
    }

    private void parquetOutputWriter_$eq(Option<ParquetOutputWriter> x$1) {
        this.parquetOutputWriter = x$1;
    }

    private Option<ParquetMetadata> latestFooter() {
        return this.latestFooter;
    }

    private void latestFooter_$eq(Option<ParquetMetadata> x$1) {
        this.latestFooter = x$1;
    }

    private Buffer<InternalRow> rows() {
        return this.rows;
    }

    private long bufferedSize() {
        return this.bufferedSize;
    }

    private void bufferedSize_$eq(long x$1) {
        this.bufferedSize = x$1;
    }

    private UnsafeProjection toUnsafeRow$lzycompute() {
        ParquetOutputWriterWithVariantShredding parquetOutputWriterWithVariantShredding = this;
        synchronized (parquetOutputWriterWithVariantShredding) {
            if (!this.bitmap$0) {
                this.toUnsafeRow = UnsafeProjection$.MODULE$.create(this.inferenceHelper.schema());
                this.bitmap$0 = true;
            }
        }
        return this.toUnsafeRow;
    }

    private UnsafeProjection toUnsafeRow() {
        if (!this.bitmap$0) {
            return this.toUnsafeRow$lzycompute();
        }
        return this.toUnsafeRow;
    }

    private long maxBufferSize() {
        return this.maxBufferSize;
    }

    private int maxBufferRows() {
        return this.maxBufferRows;
    }

    private void finalizeSchemaAndFlush() {
        if (!this.isShreddingSchemaForced()) {
            StructType finalSchema = this.inferenceHelper.inferSchema((Seq<InternalRow>)this.rows().toSeq());
            ParquetWriteSupport$.MODULE$.setShreddingSchema(finalSchema, this.context.getConfiguration());
        }
        this.parquetOutputWriter_$eq((Option<ParquetOutputWriter>)new Some((Object)new ParquetOutputWriter(this.path(), this.context)));
        this.rows().foreach((Function1 & Serializable)row -> {
            ParquetOutputWriterWithVariantShredding.$anonfun$finalizeSchemaAndFlush$1(this, row);
            return BoxedUnit.UNIT;
        });
        this.rows().clear();
        this.bufferedSize_$eq(0L);
    }

    public Option<ParquetMetadata> getLatestFooterOpt() {
        return this.latestFooter();
    }

    private boolean stopBuffering(UnsafeRow row) {
        if (this.rows().size() + 1 >= this.maxBufferRows()) {
            return true;
        }
        this.bufferedSize_$eq(this.bufferedSize() + (long)row.getSizeInBytes());
        return this.bufferedSize() > this.maxBufferSize();
    }

    @Override
    public void write(InternalRow row) {
        if (this.parquetOutputWriter().isEmpty()) {
            UnsafeRow unsafeRow;
            UnsafeRow unsafeRow2;
            InternalRow internalRow = row;
            UnsafeRow unsafeRow3 = unsafeRow2 = internalRow instanceof UnsafeRow ? (unsafeRow = (UnsafeRow)internalRow) : this.toUnsafeRow().apply(row);
            if (this.stopBuffering(unsafeRow2)) {
                this.rows().$plus$eq((Object)unsafeRow2);
                this.finalizeSchemaAndFlush();
                return;
            }
            this.rows().$plus$eq((Object)unsafeRow2.copy());
            return;
        }
        ((ParquetOutputWriter)this.parquetOutputWriter().get()).write(row);
    }

    @Override
    public void close() {
        try {
            if (this.parquetOutputWriter().isEmpty()) {
                this.finalizeSchemaAndFlush();
            }
        }
        finally {
            this.parquetOutputWriter().foreach((Function1 & Serializable)writer -> {
                writer.close();
                return BoxedUnit.UNIT;
            });
            this.parquetOutputWriter_$eq((Option<ParquetOutputWriter>)None$.MODULE$);
        }
    }

    public static final /* synthetic */ void $anonfun$finalizeSchemaAndFlush$1(ParquetOutputWriterWithVariantShredding $this, InternalRow row) {
        ((ParquetOutputWriter)$this.parquetOutputWriter().get()).write(row);
    }

    public ParquetOutputWriterWithVariantShredding(String path, TaskAttemptContext context, InferVariantShreddingSchema inferenceHelper, boolean isShreddingSchemaForced) {
        this.path = path;
        this.context = context;
        this.inferenceHelper = inferenceHelper;
        this.isShreddingSchemaForced = isShreddingSchemaForced;
        this.parquetOutputWriter = None$.MODULE$;
        this.latestFooter = None$.MODULE$;
        this.rows = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.bufferedSize = 0L;
        this.maxBufferSize = 0x4000000L;
        this.maxBufferRows = 4096;
    }
}

