/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.orc;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.orc.CompressionKind;

public enum OrcCompressionCodec {
    NONE(CompressionKind.NONE),
    UNCOMPRESSED(CompressionKind.NONE),
    ZLIB(CompressionKind.ZLIB),
    SNAPPY(CompressionKind.SNAPPY),
    LZO(CompressionKind.LZO),
    LZ4(CompressionKind.LZ4),
    ZSTD(CompressionKind.ZSTD),
    BROTLI(CompressionKind.BROTLI);

    private final CompressionKind compressionKind;
    private static final EnumMap<OrcCompressionCodec, String> codecNameMap;

    private OrcCompressionCodec(CompressionKind compressionKind) {
        this.compressionKind = compressionKind;
    }

    public CompressionKind getCompressionKind() {
        return this.compressionKind;
    }

    public String lowerCaseName() {
        return codecNameMap.get((Object)this);
    }

    static {
        codecNameMap = Arrays.stream(OrcCompressionCodec.values()).collect(Collectors.toMap(codec -> codec, codec -> codec.name().toLowerCase(Locale.ROOT), (oldValue, newValue) -> oldValue, () -> new EnumMap(OrcCompressionCodec.class)));
    }
}

