/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.spark.SparkException$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.QueryPlanningTracker;
import org.apache.spark.sql.catalyst.QueryPlanningTracker$;
import org.apache.spark.sql.catalyst.analysis.NameParameterizedQuery;
import org.apache.spark.sql.catalyst.plans.logical.CompoundBody;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.ReturnAnswer;
import org.apache.spark.sql.catalyst.rules.PlanChangeLogger;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.classic.SparkSession;
import org.apache.spark.sql.execution.ApplyColumnarRulesAndInsertTransitions;
import org.apache.spark.sql.execution.CollapseCodegenStages;
import org.apache.spark.sql.execution.CollapseCodegenStages$;
import org.apache.spark.sql.execution.CommandExecutionMode$;
import org.apache.spark.sql.execution.DoNotCleanup$;
import org.apache.spark.sql.execution.InsertSortForLimitAndOffset$;
import org.apache.spark.sql.execution.PlanSubqueries;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.RemoveRedundantProjects$;
import org.apache.spark.sql.execution.RemoveRedundantSorts$;
import org.apache.spark.sql.execution.RemoveRedundantWindowGroupLimits$;
import org.apache.spark.sql.execution.RemoveShuffleFiles$;
import org.apache.spark.sql.execution.ReplaceHashWithSortAgg$;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.ShuffleCleanupMode;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.SparkPlanner;
import org.apache.spark.sql.execution.adaptive.AdaptiveExecutionContext;
import org.apache.spark.sql.execution.adaptive.InsertAdaptiveSparkPlan;
import org.apache.spark.sql.execution.bucketing.CoalesceBucketsInJoin$;
import org.apache.spark.sql.execution.bucketing.DisableUnnecessaryBucketedScan$;
import org.apache.spark.sql.execution.dynamicpruning.PlanDynamicPruningFilters;
import org.apache.spark.sql.execution.exchange.EnsureRequirements;
import org.apache.spark.sql.execution.exchange.EnsureRequirements$;
import org.apache.spark.sql.execution.reuse.ReuseExchangeAndSubquery$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.util.UUIDv7Generator;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class QueryExecution$ {
    public static final QueryExecution$ MODULE$ = new QueryExecution$();
    private static final AtomicLong _nextExecutionId = new AtomicLong(0L);

    public QueryPlanningTracker $lessinit$greater$default$3() {
        return new QueryPlanningTracker(QueryPlanningTracker$.MODULE$.$lessinit$greater$default$1());
    }

    public Enumeration.Value $lessinit$greater$default$4() {
        return CommandExecutionMode$.MODULE$.ALL();
    }

    public ShuffleCleanupMode $lessinit$greater$default$5() {
        return DoNotCleanup$.MODULE$;
    }

    public boolean $lessinit$greater$default$6() {
        return true;
    }

    public UUID $lessinit$greater$default$7() {
        return UUIDv7Generator.generate();
    }

    private AtomicLong _nextExecutionId() {
        return _nextExecutionId;
    }

    public long org$apache$spark$sql$execution$QueryExecution$$nextExecutionId() {
        return this._nextExecutionId().getAndIncrement();
    }

    public QueryExecution create(SparkSession sparkSession, LogicalPlan logical, boolean refreshPhaseEnabled) {
        SparkSession x$1 = sparkSession;
        LogicalPlan x$2 = logical;
        Enumeration.Value x$3 = CommandExecutionMode$.MODULE$.ALL();
        ShuffleCleanupMode x$4 = this.determineShuffleCleanupMode(sparkSession.sessionState().conf());
        boolean x$5 = refreshPhaseEnabled;
        QueryPlanningTracker x$6 = this.$lessinit$greater$default$3();
        UUID x$7 = this.$lessinit$greater$default$7();
        return new QueryExecution(x$1, x$2, x$6, x$3, x$4, x$5, x$7);
    }

    public boolean create$default$3() {
        return true;
    }

    public Seq<Rule<SparkPlan>> preparations(SparkSession sparkSession, Option<InsertAdaptiveSparkPlan> adaptiveExecutionRule, boolean subquery) {
        return (Seq)((IterableOps)Option$.MODULE$.option2Iterable(adaptiveExecutionRule).toSeq().$plus$plus((IterableOnce)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Rule[]{CoalesceBucketsInJoin$.MODULE$, new PlanDynamicPruningFilters(sparkSession), new PlanSubqueries(sparkSession), RemoveRedundantProjects$.MODULE$, new EnsureRequirements(EnsureRequirements$.MODULE$.apply$default$1(), EnsureRequirements$.MODULE$.apply$default$2()), InsertSortForLimitAndOffset$.MODULE$, ReplaceHashWithSortAgg$.MODULE$, RemoveRedundantSorts$.MODULE$, RemoveRedundantWindowGroupLimits$.MODULE$, DisableUnnecessaryBucketedScan$.MODULE$, new ApplyColumnarRulesAndInsertTransitions(sparkSession.sessionState().columnarRules(), false), new CollapseCodegenStages(CollapseCodegenStages$.MODULE$.apply$default$1())})))).$plus$plus((IterableOnce)(subquery ? Nil$.MODULE$ : new .colon.colon((Object)ReuseExchangeAndSubquery$.MODULE$, (List)Nil$.MODULE$)));
    }

    public Option<InsertAdaptiveSparkPlan> preparations$default$2() {
        return None$.MODULE$;
    }

    public SparkPlan prepareForExecution(Seq<Rule<SparkPlan>> preparations, SparkPlan plan) {
        PlanChangeLogger planChangeLogger = new PlanChangeLogger();
        SparkPlan preparedPlan = (SparkPlan)preparations.foldLeft((Object)plan, (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                SparkPlan sp2 = (SparkPlan)tuple2._1();
                Rule rule = (Rule)tuple2._2();
                SparkPlan result = (SparkPlan)rule.apply((TreeNode)sp2);
                planChangeLogger.logRule(rule.ruleName(), (TreeNode)sp2, (TreeNode)result);
                return result;
            }
            throw new MatchError((Object)tuple2);
        });
        planChangeLogger.logBatch("Preparations", (TreeNode)plan, (TreeNode)preparedPlan);
        return preparedPlan;
    }

    public SparkPlan createSparkPlan(SparkPlanner planner, LogicalPlan plan) {
        return (SparkPlan)planner.plan((LogicalPlan)new ReturnAnswer(plan)).next();
    }

    public SparkPlan prepareExecutedPlan(SparkSession spark, SparkPlan plan) {
        SparkSession x$1 = spark;
        boolean x$2 = true;
        Option<InsertAdaptiveSparkPlan> x$3 = this.preparations$default$2();
        return this.prepareForExecution(this.preparations(x$1, x$3, true), plan);
    }

    public SparkPlan prepareExecutedPlan(SparkSession spark, LogicalPlan plan) {
        SparkPlan sparkPlan = this.createSparkPlan(spark.sessionState().planner(), plan.clone());
        return this.prepareExecutedPlan(spark, sparkPlan);
    }

    public SparkPlan prepareExecutedPlan(LogicalPlan plan, AdaptiveExecutionContext context) {
        SparkPlan sparkPlan = this.createSparkPlan(context.session().sessionState().planner(), plan.clone());
        Seq<Rule<SparkPlan>> preparationRules = this.preparations(context.session(), (Option<InsertAdaptiveSparkPlan>)Option$.MODULE$.apply((Object)new InsertAdaptiveSparkPlan(context)), true);
        return this.prepareForExecution(preparationRules, (SparkPlan)sparkPlan.clone());
    }

    public boolean isInternalError(Throwable e) {
        Throwable throwable = e;
        if (throwable instanceof NullPointerException) {
            return true;
        }
        if (throwable instanceof AssertionError) {
            return true;
        }
        return throwable instanceof MatchError;
    }

    public Throwable toInternalError(String msg, Throwable e) {
        if (this.isInternalError(e)) {
            return SparkException$.MODULE$.internalError(msg + " You hit a bug in Spark or the Spark plugins you use. Please, report this bug to the corresponding communities or vendors, and provide the full stack trace.", e);
        }
        return e;
    }

    public <T> T withInternalError(String msg, Function0<T> block) {
        Object object;
        try {
            object = block.apply();
        }
        catch (Throwable e) {
            throw this.toInternalError(msg, e);
        }
        return (T)object;
    }

    public LogicalPlan normalize(SparkSession session, LogicalPlan plan, Option<QueryPlanningTracker> tracker) {
        Seq<Rule<LogicalPlan>> normalizationRules = session.sessionState().planNormalizationRules();
        if (normalizationRules.isEmpty()) {
            return plan;
        }
        PlanChangeLogger planChangeLogger = new PlanChangeLogger();
        LogicalPlan normalized = (LogicalPlan)normalizationRules.foldLeft((Object)plan, (Function2 & Serializable)(p, rule) -> {
            long startTime = System.nanoTime();
            LogicalPlan result = (LogicalPlan)rule.apply((TreeNode)p);
            long runTime = System.nanoTime() - startTime;
            boolean effective = !result.fastEquals((TreeNode)p);
            tracker.foreach((Function1 & Serializable)x$9 -> {
                x$9.recordRuleInvocation(rule.ruleName(), runTime, effective);
                return BoxedUnit.UNIT;
            });
            planChangeLogger.logRule(rule.ruleName(), (TreeNode)p, (TreeNode)result);
            return result;
        });
        planChangeLogger.logBatch("Plan Normalization", (TreeNode)plan, (TreeNode)normalized);
        return normalized;
    }

    public Option<QueryPlanningTracker> normalize$default$3() {
        return None$.MODULE$;
    }

    public ShuffleCleanupMode determineShuffleCleanupMode(SQLConf conf) {
        if (BoxesRunTime.unboxToBoolean((Object)conf.getConf(SQLConf$.MODULE$.CLASSIC_SHUFFLE_DEPENDENCY_FILE_CLEANUP_ENABLED()))) {
            return RemoveShuffleFiles$.MODULE$;
        }
        return DoNotCleanup$.MODULE$;
    }

    public boolean isUnresolvedPlanSqlScript(LogicalPlan plan) {
        NameParameterizedQuery nameParameterizedQuery;
        LogicalPlan logicalPlan2 = plan;
        if (logicalPlan2 instanceof CompoundBody) {
            return true;
        }
        return logicalPlan2 instanceof NameParameterizedQuery && (nameParameterizedQuery = (NameParameterizedQuery)logicalPlan2).child() instanceof CompoundBody;
    }

    public Tuple2<QueryExecution, InternalRow[]> runCommand(SparkSession sparkSession, LogicalPlan command, String name, boolean refreshPhaseEnabled, Enumeration.Value mode, Option<ShuffleCleanupMode> shuffleCleanupModeOpt) {
        ShuffleCleanupMode shuffleCleanupMode = (ShuffleCleanupMode)shuffleCleanupModeOpt.getOrElse((Function0 & Serializable)() -> MODULE$.determineShuffleCleanupMode(sparkSession.sessionState().conf()));
        SparkSession x$1 = sparkSession;
        LogicalPlan x$2 = command;
        Enumeration.Value x$3 = mode;
        ShuffleCleanupMode x$4 = shuffleCleanupMode;
        boolean x$5 = refreshPhaseEnabled;
        QueryPlanningTracker x$6 = this.$lessinit$greater$default$3();
        UUID x$7 = this.$lessinit$greater$default$7();
        QueryExecution qe = new QueryExecution(x$1, x$2, x$6, x$3, x$4, x$5, x$7);
        InternalRow[] result = (InternalRow[])this.withInternalError("Executed " + name + " failed.", (Function0 & Serializable)() -> (InternalRow[])SQLExecution$.MODULE$.withNewExecutionId(qe, (Option<String>)new Some((Object)name), (Function0 & Serializable)() -> qe.executedPlan().executeCollect()));
        return new Tuple2((Object)qe, (Object)result);
    }

    public boolean runCommand$default$4() {
        return true;
    }

    public Enumeration.Value runCommand$default$5() {
        return CommandExecutionMode$.MODULE$.SKIP();
    }

    public Option<ShuffleCleanupMode> runCommand$default$6() {
        return None$.MODULE$;
    }

    private QueryExecution$() {
    }
}

