/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.dmg.pmml;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.sparkproject.dmg.pmml.Extension;
import org.sparkproject.dmg.pmml.Field;
import org.sparkproject.dmg.pmml.HasExtensions;
import org.sparkproject.dmg.pmml.HasFieldReference;
import org.sparkproject.dmg.pmml.HasValue;
import org.sparkproject.dmg.pmml.PMMLAttributes;
import org.sparkproject.dmg.pmml.PMMLObject;
import org.sparkproject.dmg.pmml.Predicate;
import org.sparkproject.dmg.pmml.StringValue;
import org.sparkproject.dmg.pmml.Visitor;
import org.sparkproject.dmg.pmml.VisitorAction;
import org.sparkproject.dmg.pmml.adapters.FieldNameAdapter;
import org.sparkproject.dmg.pmml.adapters.ObjectAdapter;
import org.sparkproject.jpmml.model.MissingAttributeException;
import org.sparkproject.jpmml.model.annotations.AlternateValueConstructor;
import org.sparkproject.jpmml.model.annotations.CollectionElementType;
import org.sparkproject.jpmml.model.annotations.Property;
import org.sparkproject.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="SimplePredicate", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions"})
@JsonRootName(value="SimplePredicate")
@JsonPropertyOrder(value={"field", "operator", "value", "extensions"})
public class SimplePredicate
extends Predicate
implements HasExtensions<SimplePredicate>,
HasFieldReference<SimplePredicate>,
HasValue<SimplePredicate> {
    @XmlAttribute(name="field", required=true)
    @XmlJavaTypeAdapter(value=FieldNameAdapter.class)
    @JsonProperty(value="field")
    private String field;
    @XmlAttribute(name="operator", required=true)
    @JsonProperty(value="operator")
    private Operator operator;
    @XmlAttribute(name="value")
    @XmlJavaTypeAdapter(value=ObjectAdapter.class)
    @XmlSchemaType(name="anySimpleType")
    @JsonProperty(value="value")
    private Object value;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    @CollectionElementType(value=Extension.class)
    private List<Extension> extensions;
    private static final long serialVersionUID = 67371272L;

    public SimplePredicate() {
    }

    @ValueConstructor
    public SimplePredicate(@Property(value="field") String field, @Property(value="operator") Operator operator, @Property(value="value") Object value) {
        this.field = field;
        this.operator = operator;
        this.value = value;
    }

    @AlternateValueConstructor
    public SimplePredicate(Field<?> field, Operator operator, Object value) {
        this(field != null ? field.requireName() : null, operator, value);
    }

    @Override
    public String requireField() {
        if (this.field == null) {
            throw new MissingAttributeException(this, PMMLAttributes.SIMPLEPREDICATE_FIELD);
        }
        return this.field;
    }

    @Override
    public String getField() {
        return this.field;
    }

    @Override
    public SimplePredicate setField(@Property(value="field") String field) {
        this.field = field;
        return this;
    }

    public Operator requireOperator() {
        if (this.operator == null) {
            throw new MissingAttributeException(this, PMMLAttributes.SIMPLEPREDICATE_OPERATOR);
        }
        return this.operator;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public SimplePredicate setOperator(@Property(value="operator") Operator operator) {
        this.operator = operator;
        return this;
    }

    @Override
    public Object requireValue() {
        if (this.value == null) {
            throw new MissingAttributeException(this, PMMLAttributes.SIMPLEPREDICATE_VALUE);
        }
        return this.value;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public SimplePredicate setValue(@Property(value="value") Object value) {
        this.value = value;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public SimplePredicate addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum Operator implements StringValue<Operator>
    {
        EQUAL("equal"),
        NOT_EQUAL("notEqual"),
        LESS_THAN("lessThan"),
        LESS_OR_EQUAL("lessOrEqual"),
        GREATER_THAN("greaterThan"),
        GREATER_OR_EQUAL("greaterOrEqual"),
        IS_MISSING("isMissing"),
        IS_NOT_MISSING("isNotMissing");

        private final String value;

        private Operator(String v) {
            this.value = v;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static Operator fromValue(String v) {
            for (Operator c : Operator.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public String toString() {
            return this.value();
        }
    }
}

