/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Locale;
import org.apache.spark.SparkException$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.ArrayOps$;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.package;
import scala.math.Numeric;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class MetricUtils$ {
    public static final MetricUtils$ MODULE$ = new MetricUtils$();
    private static final String SUM_METRIC = "sum";
    private static final String SIZE_METRIC = "size";
    private static final String TIMING_METRIC = "timing";
    private static final String NS_TIMING_METRIC = "nsTiming";
    private static final String AVERAGE_METRIC = "average";
    private static final int baseForAvgMetric = 10;
    private static final String METRICS_NAME_SUFFIX = "(min, med, max (stageId: taskId))";

    public String SUM_METRIC() {
        return SUM_METRIC;
    }

    public String SIZE_METRIC() {
        return SIZE_METRIC;
    }

    public String TIMING_METRIC() {
        return TIMING_METRIC;
    }

    public String NS_TIMING_METRIC() {
        return NS_TIMING_METRIC;
    }

    public String AVERAGE_METRIC() {
        return AVERAGE_METRIC;
    }

    private int baseForAvgMetric() {
        return baseForAvgMetric;
    }

    private String METRICS_NAME_SUFFIX() {
        return METRICS_NAME_SUFFIX;
    }

    private String toNumberFormat(long value) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.US);
        return numberFormat.format((double)value / (double)this.baseForAvgMetric());
    }

    public boolean metricNeedsMax(String metricsType) {
        String string = metricsType;
        String string2 = this.SUM_METRIC();
        return string == null ? string2 != null : !string.equals(string2);
    }

    public String stringValue(String metricsType, long[] values, long[] maxMetrics) {
        SeqOps seqOps;
        Function1 & Serializable intersect;
        String taskInfo = ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.longArrayOps(maxMetrics)) ? "(driver)" : "(stage " + maxMetrics[1] + "." + maxMetrics[2] + ": task " + maxMetrics[3] + ")";
        String string = metricsType;
        String string2 = this.SUM_METRIC();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            NumberFormat numberFormat = NumberFormat.getIntegerInstance(Locale.US);
            return numberFormat.format(BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.wrapLongArray(values).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
        }
        String string3 = metricsType;
        String string4 = this.AVERAGE_METRIC();
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            SeqOps seqOps2;
            long[] validValues = (long[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.longArrayOps(values), (Function1)(JFunction1.mcZJ.sp & Serializable)x$1 -> x$1 > 0L);
            if (validValues.length <= 1) {
                return this.toNumberFormat(BoxesRunTime.unboxToLong((Object)ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.longArrayOps(validValues)).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)));
            }
            Arrays.sort(validValues);
            .colon.colon colon2 = new .colon.colon((Object)this.toNumberFormat(validValues[0]), (List)new .colon.colon((Object)this.toNumberFormat(validValues[validValues.length / 2]), (List)new .colon.colon((Object)this.toNumberFormat(validValues[validValues.length - 1]), (List)Nil$.MODULE$)));
            if (colon2 == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = package$.MODULE$.Seq().unapplySeq((SeqOps)colon2)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 3) != 0) {
                throw new MatchError((Object)colon2);
            }
            String min = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0);
            String med = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1);
            String max = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 2);
            Tuple3 tuple3 = new Tuple3((Object)min, (Object)med, (Object)max);
            String min2 = (String)tuple3._1();
            String med2 = (String)tuple3._2();
            String max2 = (String)tuple3._3();
            return this.METRICS_NAME_SUFFIX() + ":\n(" + min2 + ", " + med2 + ", " + max2 + " " + taskInfo + ")";
        }
        String string5 = metricsType;
        String string6 = this.SIZE_METRIC();
        if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
            intersect = (Function1 & Serializable)size -> Utils$.MODULE$.bytesToString(BoxesRunTime.unboxToLong((Object)size));
        } else {
            String string7 = metricsType;
            String string8 = this.TIMING_METRIC();
            if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
                intersect = (Function1 & Serializable)ms -> Utils$.MODULE$.msDurationToString(BoxesRunTime.unboxToLong((Object)ms));
            } else {
                String string9 = metricsType;
                String string10 = this.NS_TIMING_METRIC();
                if (!(string9 != null ? !string9.equals(string10) : string10 != null)) {
                    intersect = (Function1 & Serializable)duration -> Utils$.MODULE$.msDurationToString(new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(BoxesRunTime.unboxToLong((Object)duration))).nanos().toMillis());
                } else {
                    throw SparkException$.MODULE$.internalError("unexpected metrics type: " + metricsType);
                }
            }
        }
        Function1 & Serializable strFormat = intersect;
        long[] validValues = (long[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.longArrayOps(values), (Function1)(JFunction1.mcZJ.sp & Serializable)x$3 -> x$3 >= 0L);
        if (validValues.length <= 1) {
            return (String)strFormat.apply(ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.longArrayOps(validValues)).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
        }
        Arrays.sort(validValues);
        .colon.colon colon3 = new .colon.colon((Object)((String)strFormat.apply(Predef$.MODULE$.wrapLongArray(validValues).sum((Numeric)Numeric.LongIsIntegral$.MODULE$))), (List)new .colon.colon((Object)((String)strFormat.apply((Object)BoxesRunTime.boxToLong((long)validValues[0]))), (List)new .colon.colon((Object)((String)strFormat.apply((Object)BoxesRunTime.boxToLong((long)validValues[validValues.length / 2]))), (List)new .colon.colon((Object)((String)strFormat.apply((Object)BoxesRunTime.boxToLong((long)validValues[validValues.length - 1]))), (List)Nil$.MODULE$))));
        if (colon3 == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)colon3)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 4) != 0) {
            throw new MatchError((Object)colon3);
        }
        String sum = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
        String min = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
        String med = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2);
        String max = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 3);
        Tuple4 tuple4 = new Tuple4((Object)sum, (Object)min, (Object)med, (Object)max);
        String sum2 = (String)tuple4._1();
        String min3 = (String)tuple4._2();
        String med3 = (String)tuple4._3();
        String max3 = (String)tuple4._4();
        return "total " + this.METRICS_NAME_SUFFIX() + "\n" + sum2 + " (" + min3 + ", " + med3 + ", " + max3 + " " + taskInfo + ")";
    }

    private MetricUtils$() {
    }
}

