/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.tree.DecisionTree$;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.mllib.tree.model.DecisionTreeModel$;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class DecisionTreeRegressionExample$ {
    public static DecisionTreeRegressionExample$ MODULE$;

    static {
        new DecisionTreeRegressionExample$();
    }

    public void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("DecisionTreeRegressionExample");
        SparkContext sc = new SparkContext(conf);
        RDD data = MLUtils$.MODULE$.loadLibSVMFile(sc, "data/mllib/sample_libsvm_data.txt");
        RDD[] splits = data.randomSplit(new double[]{0.7, 0.3}, data.randomSplit$default$2());
        Tuple2 tuple2 = new Tuple2((Object)splits[0], (Object)splits[1]);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        RDD trainingData = (RDD)tuple2._1();
        RDD testData = (RDD)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)trainingData, (Object)testData);
        RDD trainingData2 = (RDD)tuple22._1();
        RDD testData2 = (RDD)tuple22._2();
        Map categoricalFeaturesInfo = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        String impurity = "variance";
        int maxDepth = 5;
        int maxBins = 32;
        DecisionTreeModel model = DecisionTree$.MODULE$.trainRegressor(trainingData2, categoricalFeaturesInfo, impurity, maxDepth, maxBins);
        RDD labelsAndPredictions = testData2.map((Function1 & Serializable & scala.Serializable)point -> {
            double prediction = model.predict(point.features());
            return new Tuple2.mcDD.sp(point.label(), prediction);
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        double testMSE = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(labelsAndPredictions.map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)DecisionTreeRegressionExample$.$anonfun$main$2(x0$1)), ClassTag$.MODULE$.Double())).mean();
        Predef$.MODULE$.println((Object)new StringBuilder(26).append("Test Mean Squared Error = ").append(testMSE).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(32).append("Learned regression tree model:\n ").append(model.toDebugString()).toString());
        model.save(sc, "target/tmp/myDecisionTreeRegressionModel");
        DecisionTreeModel sameModel = DecisionTreeModel$.MODULE$.load(sc, "target/tmp/myDecisionTreeRegressionModel");
        sc.stop();
    }

    public static final /* synthetic */ double $anonfun$main$2(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            double v = tuple2._1$mcD$sp();
            double p = tuple2._2$mcD$sp();
            return package$.MODULE$.pow(v - p, 2.0);
        }
        throw new MatchError((Object)tuple2);
    }

    private DecisionTreeRegressionExample$() {
        MODULE$ = this;
    }
}

