/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.tree;

import java.io.Serializable;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.internal.Logging;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.regression.DecisionTreeRegressionModel;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.GradientBoostedTrees$;
import org.apache.spark.mllib.tree.configuration.BoostingStrategy;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.mllib.tree.model.GradientBoostedTreesModel;
import org.apache.spark.rdd.RDD;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005%b\u0001B\t\u0013\u0001uA\u0001\"\f\u0001\u0003\u0006\u0004%IA\f\u0005\tk\u0001\u0011\t\u0011)A\u0005_!Aa\u0007\u0001BC\u0002\u0013%q\u0007\u0003\u0005<\u0001\t\u0005\t\u0015!\u00039\u0011\u0019a\u0004\u0001\"\u0001\u0017{!)A\b\u0001C\u0001\u0005\")Q\n\u0001C\u0001\u001d\")Q\n\u0001C\u0001I\")q\u000e\u0001C\u0001a\")q\u000e\u0001C\u0001o\u001e)AP\u0005E\u0001{\u001a)\u0011C\u0005E\u0001}\")A\b\u0004C\u0001\u007f\"9\u0011\u0011\u0001\u0007\u0005\u0002\u0005\r\u0001bBA\u0001\u0019\u0011\u0005\u00111\u0002\u0005\n\u0003'a\u0011\u0011!C\u0005\u0003+\u0011Ac\u0012:bI&,g\u000e\u001e\"p_N$X\r\u001a+sK\u0016\u001c(BA\n\u0015\u0003\u0011!(/Z3\u000b\u0005U1\u0012!B7mY&\u0014'BA\f\u0019\u0003\u0015\u0019\b/\u0019:l\u0015\tI\"$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00027\u0005\u0019qN]4\u0004\u0001M!\u0001A\b\u0013(!\ty\"%D\u0001!\u0015\u0005\t\u0013!B:dC2\f\u0017BA\u0012!\u0005\u0019\te.\u001f*fMB\u0011q$J\u0005\u0003M\u0001\u0012AbU3sS\u0006d\u0017N_1cY\u0016\u0004\"\u0001K\u0016\u000e\u0003%R!A\u000b\f\u0002\u0011%tG/\u001a:oC2L!\u0001L\u0015\u0003\u000f1{wmZ5oO\u0006\u0001\"m\\8ti&twm\u0015;sCR,w-_\u000b\u0002_A\u0011\u0001gM\u0007\u0002c)\u0011!GE\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\n\u0005Q\n$\u0001\u0005\"p_N$\u0018N\\4TiJ\fG/Z4z\u0003E\u0011wn\\:uS:<7\u000b\u001e:bi\u0016<\u0017\u0010I\u0001\u0005g\u0016,G-F\u00019!\ty\u0012(\u0003\u0002;A\t\u0019\u0011J\u001c;\u0002\u000bM,W\r\u001a\u0011\u0002\rqJg.\u001b;?)\rq\u0004)\u0011\t\u0003\u007f\u0001i\u0011A\u0005\u0005\u0006[\u0015\u0001\ra\f\u0005\u0006m\u0015\u0001\r\u0001\u000f\u000b\u0003}\rCQ!\f\u0004A\u0002=B3AB#L!\t1\u0015*D\u0001H\u0015\tAe#\u0001\u0006b]:|G/\u0019;j_:L!AS$\u0003\u000bMKgnY3\"\u00031\u000bQ!\r\u00183]A\n1A];o)\tyU\u000b\u0005\u0002Q'6\t\u0011K\u0003\u0002S%\u0005)Qn\u001c3fY&\u0011A+\u0015\u0002\u001a\u000fJ\fG-[3oi\n{wn\u001d;fIR\u0013X-Z:N_\u0012,G\u000eC\u0003W\u000f\u0001\u0007q+A\u0003j]B,H\u000fE\u0002Y7vk\u0011!\u0017\u0006\u00035Z\t1A\u001d3e\u0013\ta\u0016LA\u0002S\t\u0012\u0003\"AX1\u000e\u0003}S!\u0001\u0019\u000b\u0002\u0015I,wM]3tg&|g.\u0003\u0002c?\naA*\u00192fY\u0016$\u0007k\\5oi\"\u001aq!R&\u0015\u0005=+\u0007\"\u0002,\t\u0001\u00041\u0007cA4m;6\t\u0001N\u0003\u0002jU\u0006!!.\u0019<b\u0015\tYg#A\u0002ba&L!!\u001c5\u0003\u000f)\u000bg/\u0019*E\t\"\u001a\u0001\"R&\u0002#I,hnV5uQZ\u000bG.\u001b3bi&|g\u000eF\u0002PcJDQAV\u0005A\u0002]CQa]\u0005A\u0002]\u000bqB^1mS\u0012\fG/[8o\u0013:\u0004X\u000f\u001e\u0015\u0004\u0013\u0015+\u0018%\u0001<\u0002\u000bErCG\f\u0019\u0015\u0007=C\u0018\u0010C\u0003W\u0015\u0001\u0007a\rC\u0003t\u0015\u0001\u0007a\rK\u0002\u000b\u000bVD3\u0001A#L\u0003Q9%/\u00193jK:$(i\\8ti\u0016$GK]3fgB\u0011q\bD\n\u0005\u0019y9C\u0005F\u0001~\u0003\u0015!(/Y5o)\u0015y\u0015QAA\u0004\u0011\u00151f\u00021\u0001X\u0011\u0015ic\u00021\u00010Q\rqQi\u0013\u000b\u0006\u001f\u00065\u0011q\u0002\u0005\u0006->\u0001\rA\u001a\u0005\u0006[=\u0001\ra\f\u0015\u0004\u001f\u0015[\u0015a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a\u0006\u0011\t\u0005e\u0011\u0011E\u0007\u0003\u00037QA!!\b\u0002 \u0005!A.\u00198h\u0015\u0005I\u0017\u0002BA\u0012\u00037\u0011aa\u00142kK\u000e$\bf\u0001\u0007F\u0017\"\u001a1\"R&")
public class GradientBoostedTrees
implements scala.Serializable,
Logging {
    private final BoostingStrategy boostingStrategy;
    private final int seed;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static GradientBoostedTreesModel train(JavaRDD<LabeledPoint> javaRDD, BoostingStrategy boostingStrategy) {
        return GradientBoostedTrees$.MODULE$.train(javaRDD, boostingStrategy);
    }

    public static GradientBoostedTreesModel train(RDD<LabeledPoint> rDD, BoostingStrategy boostingStrategy) {
        return GradientBoostedTrees$.MODULE$.train(rDD, boostingStrategy);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private BoostingStrategy boostingStrategy() {
        return this.boostingStrategy;
    }

    private int seed() {
        return this.seed;
    }

    public GradientBoostedTreesModel run(RDD<LabeledPoint> input) {
        Enumeration.Value algo = this.boostingStrategy().treeStrategy().algo();
        Tuple2<DecisionTreeRegressionModel[], double[]> tuple2 = org.apache.spark.ml.tree.impl.GradientBoostedTrees$.MODULE$.run((RDD<Instance>)input.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            LabeledPoint labeledPoint = x0$1;
            if (labeledPoint != null) {
                double label = labeledPoint.label();
                Vector features = labeledPoint.features();
                return new Instance(label, 1.0, features.asML());
            }
            throw new MatchError((Object)labeledPoint);
        }, ClassTag$.MODULE$.apply(Instance.class)), this.boostingStrategy(), this.seed(), "all", org.apache.spark.ml.tree.impl.GradientBoostedTrees$.MODULE$.run$default$5());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        DecisionTreeRegressionModel[] trees = (DecisionTreeRegressionModel[])tuple2._1();
        double[] treeWeights = (double[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)trees, (Object)treeWeights);
        DecisionTreeRegressionModel[] trees2 = (DecisionTreeRegressionModel[])tuple22._1();
        double[] treeWeights2 = (double[])tuple22._2();
        return new GradientBoostedTreesModel(algo, (DecisionTreeModel[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])trees2)).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toOld(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DecisionTreeModel.class))), treeWeights2);
    }

    public GradientBoostedTreesModel run(JavaRDD<LabeledPoint> input) {
        return this.run((RDD<LabeledPoint>)input.rdd());
    }

    public GradientBoostedTreesModel runWithValidation(RDD<LabeledPoint> input, RDD<LabeledPoint> validationInput) {
        Enumeration.Value algo = this.boostingStrategy().treeStrategy().algo();
        Tuple2<DecisionTreeRegressionModel[], double[]> tuple2 = org.apache.spark.ml.tree.impl.GradientBoostedTrees$.MODULE$.runWithValidation((RDD<Instance>)input.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            LabeledPoint labeledPoint = x0$1;
            if (labeledPoint != null) {
                double label = labeledPoint.label();
                Vector features = labeledPoint.features();
                return new Instance(label, 1.0, features.asML());
            }
            throw new MatchError((Object)labeledPoint);
        }, ClassTag$.MODULE$.apply(Instance.class)), (RDD<Instance>)validationInput.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            LabeledPoint labeledPoint = x0$2;
            if (labeledPoint != null) {
                double label = labeledPoint.label();
                Vector features = labeledPoint.features();
                return new Instance(label, 1.0, features.asML());
            }
            throw new MatchError((Object)labeledPoint);
        }, ClassTag$.MODULE$.apply(Instance.class)), this.boostingStrategy(), this.seed(), "all", org.apache.spark.ml.tree.impl.GradientBoostedTrees$.MODULE$.runWithValidation$default$6());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        DecisionTreeRegressionModel[] trees = (DecisionTreeRegressionModel[])tuple2._1();
        double[] treeWeights = (double[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)trees, (Object)treeWeights);
        DecisionTreeRegressionModel[] trees2 = (DecisionTreeRegressionModel[])tuple22._1();
        double[] treeWeights2 = (double[])tuple22._2();
        return new GradientBoostedTreesModel(algo, (DecisionTreeModel[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])trees2)).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.toOld(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DecisionTreeModel.class))), treeWeights2);
    }

    public GradientBoostedTreesModel runWithValidation(JavaRDD<LabeledPoint> input, JavaRDD<LabeledPoint> validationInput) {
        return this.runWithValidation((RDD<LabeledPoint>)input.rdd(), (RDD<LabeledPoint>)validationInput.rdd());
    }

    public GradientBoostedTrees(BoostingStrategy boostingStrategy, int seed) {
        this.boostingStrategy = boostingStrategy;
        this.seed = seed;
        Logging.$init$((Logging)this);
    }

    public GradientBoostedTrees(BoostingStrategy boostingStrategy) {
        this(boostingStrategy, 0);
    }
}

